/*
 * RelationEditPart.java
 * Created on 2003/10/14
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import jp.ac.keio.sfc.crew.swing.visuals.Decoration;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EConnectionEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalRootEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.ELineConnectionVisualComponent;

import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.components.commviewer.model.RelationName;

/**
 * Class RelationEditPart.
 * 
 * @author macchan
 * @version $Id: RelationEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class RelationEditPart extends EConnectionEditPart {

	private RelationName relationName;

	/**
	 * Constructor for RelationEditPart.
	 */
	public RelationEditPart() {
		super();
	}

	protected void initialize() {
		relationName = new RelationName(getRelation());
	}

	protected Relation getRelation() {
		return (Relation) getModel();
	}

	public Object getModelSource() {
		return getRelation().getSource();
	}

	public Object getModelTarget() {
		return getRelation().getTarget();
	}

	public Object getLayerConstants() {
		return EGraphicalRootEditPart.LAYER_LOWER_CONNECTIONS;
	}

	public List getModelAccessories() {
		List accessories = new ArrayList();
		accessories.add(relationName);
		return accessories;
	}

	protected VisualComponent createVisual() {
		return createRelationVisual();
	}

	public static ELineConnectionVisualComponent createRelationVisual() {
		ELineConnectionVisualComponent c = new ELineConnectionVisualComponent();

		//sets color
		Color lineColor = new Color(100, 100, 100);
		c.setForeground(lineColor);

		//Sets stroke
		float[] dashPattern = { 10f, 8f };
		float lineWidth = 4f;
		int cap = BasicStroke.CAP_ROUND;
		int join = BasicStroke.JOIN_ROUND;
		BasicStroke s =
			new BasicStroke(lineWidth, cap, join, 1f, dashPattern, 0f);
		c.setStroke(s);

		//Sets decoration
		Decoration decoration = Decoration.createTriangleInstance();
		decoration.setScale(8, 6);
		c.setTargetDecoration(decoration);

		//Sets multiple lines policy.
		c.setMultipleLineInterval(20);

		return c;
	}

}
