/*
 * RelationNameEditPart.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Font;
import java.awt.Rectangle;

import javax.swing.JLabel;

import jp.ac.keio.sfc.crew.swing.visuals.PanelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.ELineConnectionVisualComponent;

import org.boxed_economy.components.commviewer.model.RelationName;

/**
 * Class RelationNameEditPart.
 * 
 * @author macchan
 * @version $Id: RelationNameEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class RelationNameEditPart extends EAttachmentEditPart {

	public static final Font FONT = new Font("MS Gothic", Font.PLAIN, 14);

	private PanelVisualComponent panel = new PanelVisualComponent();
	private JLabel label = new JLabel();

	/**
	 * Constructor for RelationNameEditPart.
	 */
	public RelationNameEditPart() {
		super();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart#getLayer()
	 */
	protected Object getLayer() {
		return CommunicationViewerRootEditPart.LAYER_RELATION_LABELS;
	}

	protected RelationName getRelationName() {
		return (RelationName) getModel();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
	 */
	protected VisualComponent createVisual() {
		label.setFont(FONT);
		panel.add(label);
		panel.setOpaque(false);
		return panel;
	}

	public void refreshVisual() {
		//Sets Text
		label.setText(getRelationName().getName());

		//Sets Size
		getVisual().setSize(getVisual().getPreferredSize());

		//Sets Location
		ELineConnectionVisualComponent linevisual =
			((ELineConnectionVisualComponent) getParent().getVisual());
		Rectangle rectangle = linevisual.getLineBounds();
		double cx = rectangle.getCenterX();
		double cy = rectangle.getCenterY();
		cx = cx - getVisual().getWidth() / 2;
		cy = cy - getVisual().getHeight() + 5;
		getVisual().setLocation((int) cx, (int) cy);
	}

}
