/*
 * WorldEditPart.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.util.ArrayList;
import java.util.List;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

import org.boxed_economy.besp.model.fmfw.World;

/**
 * Class WorldEditPart.
 * 
 * @author macchan
 * @version $Id: WorldEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class WorldEditPart extends EGraphicalEditPart {

	/**
	 * Constructor for WorldEditPart.
	 */
	public WorldEditPart() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#getModelChildren()
	 */
	public List getModelChildren() {
		World world = (World) getModel();
		return new ArrayList(world.getAllAgents());
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
	 */
	protected VisualComponent createVisual() {
		return new LayerVisualComponent();
	}

}
