/*
 * BehaviorManagerVisualComponent.java
 * Created on 2003/10/15
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.visuals;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.Stroke;

import javax.swing.BorderFactory;

import jp.ac.keio.sfc.crew.swing.visuals.PanelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class BehaviorManagerVisualComponent.
 * 
 * @author macchan
 * @version $Id: BehaviorManagerVisualComponent.java,v 1.1 2003/12/11 10:27:02 macchan Exp $
 */
public class BehaviorManagerVisualComponent extends VisualComponent {

	public static final int CORN_HEIGHT = 25;
	public static final int CORN_LEFT_FOOT_X = 10;
	public static final int CORN_RIGHT_FOOT_X = 20;
	public static final int CORN_SUMMIT_X = 35;
	public static final int MINIMUM_WIDTH = 100;
	public static final int PEN_WIDTH = 3;

	/*****************************************
	 * Instance Variables.
	 *****************************************/

	private VisualComponent dummy = new VisualComponent();
	private PanelVisualComponent contentPane = new PanelVisualComponent();

	/**
	 * Constructor for BehaviorManagerVisualComponent.
	 */
	public BehaviorManagerVisualComponent() {
		this.setLayout(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

		//Adds Dummy
		dummy.setPreferredSize(new Dimension(MINIMUM_WIDTH, CORN_HEIGHT));
		add(dummy, BorderLayout.NORTH);

		//Adds ContentPane
		GridLayout layout = new GridLayout(0, 1);
		layout.setHgap(5);
		layout.setVgap(5);
		contentPane.setLayout(layout);
		add(contentPane, BorderLayout.CENTER);
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.swing.visuals.VisualComponent#paintVisual(java.awt.Graphics2D)
	 */
	protected void paintVisual(Graphics2D g) {
		//pre process
		Stroke defaultStroke = g.getStroke();
		g.setStroke(new BasicStroke(PEN_WIDTH));

		//Create Figure
		int x = PEN_WIDTH / 2;
		int y = PEN_WIDTH / 2;
		int width = getWidth() - PEN_WIDTH / 2 - 1;
		int height = getHeight() - PEN_WIDTH / 2 - 1;
		Polygon polygon = new Polygon();
		polygon.addPoint(CORN_SUMMIT_X, y);
		polygon.addPoint(CORN_SUMMIT_X - CORN_LEFT_FOOT_X, CORN_HEIGHT);
		polygon.addPoint(x, CORN_HEIGHT);
		polygon.addPoint(x, height);
		polygon.addPoint(width, height);
		polygon.addPoint(width, CORN_HEIGHT);
		polygon.addPoint(CORN_SUMMIT_X + CORN_RIGHT_FOOT_X, CORN_HEIGHT);

		//Draw Figure
		g.setColor(Color.WHITE);
		g.fill(polygon);
		g.setColor(Color.BLACK);
		g.draw(polygon);

		//post process
		g.setStroke(defaultStroke);
	}

	/**
	 * @return
	 */
	public PanelVisualComponent getContentPane() {
		return contentPane;
	}

}
