/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.model;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DDocument
extends DElement {
    private static final Logger logger;
    public static final String XML_ENCODING = "UTF-8";
    public static final String NODES = "node";
    public static final String LABELS = "labels";
    public static final String CONNECTIONS = "connections";
    private Map nodes = new LinkedHashMap();
    private Map connections = new LinkedHashMap();
    private Map labels = new LinkedHashMap();
    private Map hiddenNodes = new LinkedHashMap();
    private int connectionType = 1;
    private int nodeType = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("diagrammodelfw.model.DDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("diagrammodelfw.model.DDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public DNode createNode(String id) {
        DNode node = new DNode();
        node.setId(id);
        return node;
    }

    public DConnection createConnection(String id, DNode source, DNode target) {
        DConnection connection = new DConnection();
        connection.setId(id);
        this.setNodeToConnection(connection, source, target);
        return connection;
    }

    public DLabel createLabel(String id, DConnection connection) {
        DLabel label = new DLabel();
        label.setId(id);
        label.setParent(connection);
        return label;
    }

    public List getAllNodes() {
        ArrayList list = new ArrayList();
        list.addAll(this.nodes.values());
        return list;
    }

    public List getAllConnections() {
        ArrayList list = new ArrayList();
        list.addAll(this.connections.values());
        return list;
    }

    public List getAllLabels() {
        ArrayList list = new ArrayList();
        list.addAll(this.labels.values());
        return list;
    }

    public List getAllHiddenNodes() {
        ArrayList list = new ArrayList();
        list.addAll(this.hiddenNodes.values());
        return list;
    }

    public List getAllElements() {
        ArrayList allElements = new ArrayList();
        allElements.addAll(this.getAllNodes());
        allElements.addAll(this.getAllConnections());
        allElements.addAll(this.getAllLabels());
        allElements.addAll(this.getAllHiddenNodes());
        return allElements;
    }

    public DElement getElement(String id) {
        return (DElement)((Object)this.getAllElementsMap().get(id));
    }

    private Map getAllElementsMap() {
        LinkedHashMap allElements = new LinkedHashMap();
        allElements.putAll(this.nodes);
        allElements.putAll(this.connections);
        allElements.putAll(this.labels);
        allElements.putAll(this.hiddenNodes);
        return allElements;
    }

    public void addElement(DElement element) {
        logger.info((Object)("DElement ADD element=" + (Object)((Object)element) + ")"));
        if (element instanceof DNode) {
            this.addNode((DNode)element);
        } else if (element instanceof DConnection) {
            this.addConnection((DConnection)element);
        } else if (element instanceof DLabel) {
            this.addLabel((DLabel)element);
        }
    }

    public void addHiddenNode(DNode node) {
        logger.info((Object)("DElement HIDDEN ADD node=" + (Object)((Object)node) + ")"));
        this.hiddenNodes.put(node.getId(), node);
    }

    public void removeElement(DElement element) {
        logger.info((Object)("DElement REMOVE element=" + (Object)((Object)element) + ")"));
        if (element instanceof DNode) {
            this.removeNode((DNode)element);
        } else if (element instanceof DConnection) {
            this.removeConnection((DConnection)element);
        } else if (element instanceof DLabel) {
            this.removeLabel((DLabel)element);
        }
    }

    private void addNode(DNode node) {
        this.nodes.put(node.getId(), node);
        this.fireStructureChange(NODES);
    }

    private void removeNode(DNode node) {
        this.nodes.remove(node.getId());
        this.fireStructureChange(NODES);
    }

    public void setSize(DNode node, Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException("Size to set is null");
        }
        node.setSize(size);
    }

    public void setLocation(DNode node, Point location) {
        if (location == null) {
            throw new IllegalArgumentException("Location to set is null");
        }
        node.setLocation(location);
    }

    public void setBounds(DNode node, Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("Bounds to set is null");
        }
        node.setBounds(bounds);
    }

    public void setNodeType(DNode node, int nodeType) {
        node.setNodeType(nodeType);
    }

    public void setNodeToConnection(DConnection connection, DNode source, DNode target) {
        connection.setSource(source);
        connection.setTarget(target);
    }

    private void addConnection(DConnection connection) {
        DNode target;
        if (!$assertionsDisabled && connection.getSource() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && connection.getTarget() == null) {
            throw new AssertionError();
        }
        DNode source = connection.getSource();
        if (!source.getSourceConnections().contains((Object)connection)) {
            source.addSourceConnection(connection);
        }
        if (!(target = connection.getTarget()).getTargetConnections().contains((Object)connection)) {
            target.addTargetConnection(connection);
        }
        if (!this.connections.containsKey(connection.getId())) {
            this.connections.put(connection.getId(), connection);
        }
        this.fireStructureChange(CONNECTIONS);
    }

    private void removeConnection(DConnection connection) {
        DNode target;
        if (!$assertionsDisabled && connection.getSource() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && connection.getTarget() == null) {
            throw new AssertionError();
        }
        DNode source = connection.getSource();
        if (source.getSourceConnections().contains((Object)connection)) {
            source.removeSourceConnection(connection);
        }
        if ((target = connection.getTarget()).getTargetConnections().contains((Object)connection)) {
            target.removeTargetConnection(connection);
        }
        if (this.connections.containsKey(connection.getId())) {
            this.connections.remove(connection.getId());
        }
        this.fireStructureChange(CONNECTIONS);
    }

    public void reconnectConnection(DConnection connection, DNode source, DNode target) {
        if (source != null) {
            connection.getSource().removeSourceConnection(connection);
            connection.setSource(source);
            source.addSourceConnection(connection);
        }
        if (target != null) {
            connection.getTarget().removeTargetConnection(connection);
            connection.setTarget(target);
            target.addTargetConnection(connection);
        }
    }

    public void setConnectionType(DConnection connection, int connectionType) {
        if (connectionType < 1 || connectionType > 2) {
            throw new IllegalArgumentException("Illegal connectionType");
        }
        connection.setConnectionType(connectionType);
    }

    public void setSourceConnectionConstraint(DConnection connection, Object connectionType) {
        connection.setSourceConstraint(connectionType);
    }

    public void setTargetConnectionConstraint(DConnection connection, Object connectionType) {
        connection.setTargetConstraint(connectionType);
    }

    public void addBendpoint(DConnection connection, DRelativePoint bendpoint, int index) {
        if (bendpoint == null) {
            throw new IllegalArgumentException("Bendpoint is null");
        }
        connection.addBendpoint(bendpoint, index);
    }

    public void removeBendpoint(DConnection connection, int index) {
        if (index >= connection.getBendpoints().size()) {
            throw new IllegalArgumentException("Illegal Index.");
        }
        connection.removeBendpoint(index);
    }

    public void moveBendpoint(DConnection connection, int index, DRelativePoint bendpoint) {
        if (bendpoint == null) {
            throw new IllegalArgumentException("Bendpoint is null");
        }
        if (index >= connection.getBendpoints().size()) {
            throw new IllegalArgumentException("Illegal Index.");
        }
        connection.moveBendpoint(index, bendpoint);
    }

    private void addLabel(DLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        label.getParent().addLabel(label);
        this.labels.put(label.getId(), label);
        this.fireStructureChange(LABELS);
    }

    private void removeLabel(DLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        label.getParent().removeLabel(label);
        this.labels.remove(label.getId());
        this.fireStructureChange(LABELS);
    }

    public void setLocation(DLabel label, DRelativePoint location) {
        if (location == null) {
            throw new IllegalArgumentException("Location to set is null");
        }
        label.setLocation(location);
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int connectionType) {
        int oldConnectionType = this.connectionType;
        this.connectionType = connectionType;
        super.firePropertyChange("connectionType", (Object)new Integer(oldConnectionType), (Object)new Integer(connectionType));
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        int oldNodeType = this.nodeType;
        this.nodeType = nodeType;
        super.firePropertyChange("nodeType", (Object)new Integer(oldNodeType), (Object)new Integer(nodeType));
    }

    public String getId() {
        if (super.getId() == null || super.getId().length() == 0) {
            return "DDocument";
        }
        return super.getId();
    }

    public void setId(String id) {
        super.setId(id);
    }

    public String getTagName() {
        return "DiagramDocument";
    }
}

