/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.serialization;

import diagrammodelfw.model.DDocument;
import diagrammodelfw.xml.DXMLInput;
import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.XDocument;
import java.io.BufferedInputStream;
import java.io.InputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectSerializer;
import org.apache.log4j.Logger;

public class DDocumentSerializer
extends XMLObjectSerializer {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("diagrammodelfw.serialization.DDocumentSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public Object loadObject(InputStream inputStream, Class callerClass) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            return super.loadObject((InputStream)bufferedInputStream, callerClass);
        }
        catch (Exception ex) {
            logger.warn((Object)"To load diagram using XMLObjectReader is failed.", (Throwable)ex);
            try {
                logger.info((Object)"Trying RelaxSerialization");
                bufferedInputStream.reset();
                return this.loadObjectByRelaxSerialization(bufferedInputStream);
            }
            catch (Exception exex) {
                logger.warn((Object)"To load diagram using Relax Serialization is failed.", (Throwable)ex);
                throw new RuntimeException("Load Object Failed.", exex);
            }
        }
    }

    private DDocument loadObjectByRelaxSerialization(InputStream inputStream) throws Exception {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        XDocument xDocument = factory.createXDocument();
        xDocument.setup(inputStream);
        DDocument document = new DDocument();
        DXMLInput xIn = new DXMLInput(document);
        xIn.process(xDocument);
        return document;
    }
}

