/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.XConnection;
import diagrammodelfw.xml.model.XDimension;
import diagrammodelfw.xml.model.XDocument;
import diagrammodelfw.xml.model.XLabel;
import diagrammodelfw.xml.model.XNode;
import diagrammodelfw.xml.model.XPoint;
import diagrammodelfw.xml.model.XRelativePoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DXMLInput {
    private DDocument doc = null;

    public DXMLInput(DDocument doc) {
        this.doc = doc;
    }

    public void process(XDocument xDocument) {
        this.setEDocument(xDocument);
    }

    private void setEDocument(XDocument xDocument) {
        this.doc.setConnectionType(xDocument.getConnectionType());
        this.doc.setNodeType(xDocument.getNodeType());
        XNode[] nodes = xDocument.getNodes().getNode();
        int i = 0;
        while (i < nodes.length) {
            this.createDNode(nodes[i]);
            ++i;
        }
        XConnection[] connections = xDocument.getConnections().getConnection();
        i = 0;
        while (i < connections.length) {
            this.createDConnection(connections[i]);
            ++i;
        }
        XLabel[] labels = xDocument.getLabels().getLabel();
        i = 0;
        while (i < labels.length) {
            this.createDLabel(labels[i]);
            ++i;
        }
    }

    private DElement createEElement(IRNode xElement) {
        if (xElement == null) {
            return null;
        }
        if (xElement instanceof XNode) {
            return this.createDNode((XNode)xElement);
        }
        if (xElement instanceof XConnection) {
            return this.createDConnection((XConnection)xElement);
        }
        if (xElement instanceof XLabel) {
            return this.createDLabel((XLabel)xElement);
        }
        throw new RuntimeException("Illegal Element Type for XML to Model");
    }

    private DNode createDNode(XNode xNode) {
        DNode dNode = this.doc.createNode(xNode.getId());
        this.doc.addElement(dNode);
        this.doc.setNodeType(dNode, xNode.getNodeType());
        Rectangle bounds = new Rectangle(this.createPoint(xNode.getPoint()), this.createDimension(xNode.getDimension()));
        this.doc.setBounds(dNode, bounds);
        return dNode;
    }

    private DConnection createDConnection(XConnection xConnection) {
        DNode source = (DNode)this.doc.getElement(xConnection.getSourceId());
        DNode target = (DNode)this.doc.getElement(xConnection.getTargetId());
        DConnection dConnection = this.doc.createConnection(xConnection.getId(), source, target);
        this.doc.addElement(dConnection);
        this.doc.setConnectionType(dConnection, xConnection.getConnectionType());
        XRelativePoint[] points = xConnection.getBendpoints().getRelativePoint();
        int i = 0;
        while (i < points.length) {
            this.doc.addBendpoint(dConnection, this.createRelativePoint(points[i]), i);
            ++i;
        }
        return dConnection;
    }

    private DLabel createDLabel(XLabel xLabel) {
        DConnection connection = (DConnection)this.doc.getElement(xLabel.getParentId());
        DLabel dLabel = this.doc.createLabel(xLabel.getId(), connection);
        this.doc.addElement(dLabel);
        this.doc.setLocation(dLabel, this.createRelativePoint(xLabel.getRelativePoint()));
        return dLabel;
    }

    private Point createPoint(XPoint xPoint) {
        return new Point(xPoint.getX(), xPoint.getY());
    }

    private Dimension createDimension(XDimension xDimension) {
        return new Dimension(xDimension.getWidth(), xDimension.getHeight());
    }

    private DRelativePoint createRelativePoint(XRelativePoint xPoint) {
        Dimension d1 = this.createDimension(xPoint.getDimension1());
        Dimension d2 = this.createDimension(xPoint.getDimension2());
        float weight = xPoint.getWeight();
        return new DRelativePoint(d1, d2, weight);
    }
}

