/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import diagrammodelfw.xml.model.XBendpoints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XConnection
implements Serializable,
Cloneable,
IRNode {
    private String id_;
    private String sourceId_;
    private String targetId_;
    private int connectionType_;
    private XBendpoints bendpoints_;
    private IRNode parentRNode_;

    public XConnection() {
        this.id_ = "";
        this.sourceId_ = "";
        this.targetId_ = "";
    }

    public XConnection(XConnection source) {
        this.setup(source);
    }

    public XConnection(RStack stack) {
        this.setup(stack);
    }

    public XConnection(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XConnection(Element element) {
        this.setup(element);
    }

    public XConnection(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XConnection(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XConnection(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XConnection(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XConnection(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XConnection(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XConnection source) {
        this.setId(source.getId());
        this.setSourceId(source.getSourceId());
        this.setTargetId(source.getTargetId());
        this.setConnectionType(source.getConnectionType());
        this.setBendpoints(source.getBendpoints());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.sourceId_ = URelaxer.getAttributePropertyAsString(element, "sourceId");
        this.targetId_ = URelaxer.getAttributePropertyAsString(element, "targetId");
        this.connectionType_ = URelaxer.getAttributePropertyAsInt(element, "connectionType");
        if (XBendpoints.isMatch(stack)) {
            this.setBendpoints(factory.createXBendpoints(stack));
        }
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXConnection(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("connection");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        URelaxer.setAttributePropertyByString(element, "sourceId", this.sourceId_);
        URelaxer.setAttributePropertyByString(element, "targetId", this.targetId_);
        URelaxer.setAttributePropertyByInt(element, "connectionType", this.connectionType_);
        if (this.bendpoints_ != null) {
            this.bendpoints_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getSourceId() {
        return this.sourceId_;
    }

    public final void setSourceId(String sourceId) {
        this.sourceId_ = sourceId;
    }

    public final String getTargetId() {
        return this.targetId_;
    }

    public final void setTargetId(String targetId) {
        this.targetId_ = targetId;
    }

    public final int getConnectionType() {
        return this.connectionType_;
    }

    public final void setConnectionType(int connectionType) {
        this.connectionType_ = connectionType;
    }

    public final XBendpoints getBendpoints() {
        return this.bendpoints_;
    }

    public final void setBendpoints(XBendpoints bendpoints) {
        this.bendpoints_ = bendpoints;
        if (bendpoints != null) {
            bendpoints.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<connection");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.sourceId_ != null) {
            buffer.append(" sourceId=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceId())));
            buffer.append("\"");
        }
        if (this.targetId_ != null) {
            buffer.append(" targetId=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetId())));
            buffer.append("\"");
        }
        buffer.append(" connectionType=\"");
        buffer.append(URelaxer.getString(this.getConnectionType()));
        buffer.append("\"");
        buffer.append(">");
        if (this.bendpoints_ != null) {
            this.bendpoints_.makeTextElement(buffer);
        }
        buffer.append("</connection>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<connection");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.sourceId_ != null) {
            buffer.write(" sourceId=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceId())));
            buffer.write("\"");
        }
        if (this.targetId_ != null) {
            buffer.write(" targetId=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetId())));
            buffer.write("\"");
        }
        buffer.write(" connectionType=\"");
        buffer.write(URelaxer.getString(this.getConnectionType()));
        buffer.write("\"");
        buffer.write(">");
        if (this.bendpoints_ != null) {
            this.bendpoints_.makeTextElement(buffer);
        }
        buffer.write("</connection>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<connection");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.sourceId_ != null) {
            buffer.print(" sourceId=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceId())));
            buffer.print("\"");
        }
        if (this.targetId_ != null) {
            buffer.print(" targetId=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetId())));
            buffer.print("\"");
        }
        buffer.print(" connectionType=\"");
        buffer.print(URelaxer.getString(this.getConnectionType()));
        buffer.print("\"");
        buffer.print(">");
        if (this.bendpoints_ != null) {
            this.bendpoints_.makeTextElement(buffer);
        }
        buffer.print("</connection>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getSourceIdAsString() {
        return URelaxer.getString(this.getSourceId());
    }

    public String getTargetIdAsString() {
        return URelaxer.getString(this.getTargetId());
    }

    public String getConnectionTypeAsString() {
        return URelaxer.getString(this.getConnectionType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setSourceIdByString(String string) {
        this.setSourceId(string);
    }

    public void setTargetIdByString(String string) {
        this.setTargetId(string);
    }

    public void setConnectionTypeByString(String string) {
        this.setConnectionType(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<XBendpoints> classNodes = new ArrayList<XBendpoints>();
        if (this.bendpoints_ != null) {
            classNodes.add(this.bendpoints_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "connection")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "sourceId")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "targetId")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "connectionType")) {
            return false;
        }
        if (!XBendpoints.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XConnection.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XConnection.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

