/*
 * Decompiled with CFR 0.152.
 */
package diagrammodelfw.xml.model;

import diagrammodelfw.xml.model.DiagramModelFwFactory;
import diagrammodelfw.xml.model.IDiagramModelFwFactory;
import diagrammodelfw.xml.model.IRNode;
import diagrammodelfw.xml.model.RStack;
import diagrammodelfw.xml.model.UJAXP;
import diagrammodelfw.xml.model.URelaxer;
import diagrammodelfw.xml.model.XDimension;
import diagrammodelfw.xml.model.XPoint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XNode
implements Serializable,
Cloneable,
IRNode {
    private String id_;
    private Integer nodeType_;
    private XPoint point_;
    private XDimension dimension_;
    private IRNode parentRNode_;

    public XNode() {
        this.id_ = "";
    }

    public XNode(XNode source) {
        this.setup(source);
    }

    public XNode(RStack stack) {
        this.setup(stack);
    }

    public XNode(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XNode(Element element) {
        this.setup(element);
    }

    public XNode(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XNode(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XNode(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XNode(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XNode(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XNode(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XNode source) {
        this.setId(source.getId());
        this.setNodeType(source.getNodeType());
        this.setPoint(source.getPoint());
        this.setDimension(source.getDimension());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.nodeType_ = URelaxer.getAttributePropertyAsIntObject(element, "nodeType");
        if (XPoint.isMatch(stack)) {
            this.setPoint(factory.createXPoint(stack));
        }
        if (XDimension.isMatch(stack)) {
            this.setDimension(factory.createXDimension(stack));
        }
    }

    public Object clone() {
        IDiagramModelFwFactory factory = DiagramModelFwFactory.getFactory();
        return factory.createXNode(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("node");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.nodeType_ != null) {
            URelaxer.setAttributePropertyByInt(element, "nodeType", this.nodeType_);
        }
        if (this.point_ != null) {
            this.point_.makeElement(element);
        }
        if (this.dimension_ != null) {
            this.dimension_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public int getNodeType() throws IllegalStateException {
        if (this.nodeType_ == null) {
            throw new IllegalStateException("nodeType_");
        }
        return this.nodeType_;
    }

    public int getNodeType(int nodeType) {
        if (this.nodeType_ == null) {
            return nodeType;
        }
        return this.nodeType_;
    }

    public Integer getNodeTypeAsInteger() {
        return this.nodeType_;
    }

    public boolean checkNodeType() {
        return this.nodeType_ != null;
    }

    public void setNodeType(int nodeType) {
        this.nodeType_ = new Integer(nodeType);
    }

    public void setNodeType(Integer nodeType) {
        this.nodeType_ = nodeType;
    }

    public final XPoint getPoint() {
        return this.point_;
    }

    public final void setPoint(XPoint point) {
        this.point_ = point;
        if (point != null) {
            point.rSetParentRNode(this);
        }
    }

    public final XDimension getDimension() {
        return this.dimension_;
    }

    public final void setDimension(XDimension dimension) {
        this.dimension_ = dimension;
        if (dimension != null) {
            dimension.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<node");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        buffer.append(" nodeType=\"");
        buffer.append(URelaxer.getString(this.getNodeType()));
        buffer.append("\"");
        buffer.append(">");
        if (this.point_ != null) {
            this.point_.makeTextElement(buffer);
        }
        if (this.dimension_ != null) {
            this.dimension_.makeTextElement(buffer);
        }
        buffer.append("</node>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<node");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        buffer.write(" nodeType=\"");
        buffer.write(URelaxer.getString(this.getNodeType()));
        buffer.write("\"");
        buffer.write(">");
        if (this.point_ != null) {
            this.point_.makeTextElement(buffer);
        }
        if (this.dimension_ != null) {
            this.dimension_.makeTextElement(buffer);
        }
        buffer.write("</node>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<node");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        buffer.print(" nodeType=\"");
        buffer.print(URelaxer.getString(this.getNodeType()));
        buffer.print("\"");
        buffer.print(">");
        if (this.point_ != null) {
            this.point_.makeTextElement(buffer);
        }
        if (this.dimension_ != null) {
            this.dimension_.makeTextElement(buffer);
        }
        buffer.print("</node>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNodeTypeAsString() {
        return URelaxer.getString(this.getNodeType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNodeTypeByString(String string) {
        this.setNodeType(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.point_ != null) {
            classNodes.add(this.point_);
        }
        if (this.dimension_ != null) {
            classNodes.add(this.dimension_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "node")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        if (!XPoint.isMatchHungry(target)) {
            return false;
        }
        if (!XDimension.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XNode.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XNode.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

