/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMCSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;

    public String getLocalName() {
        return "use";
    }

    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode, ReferencedElementMutationListener referencedElementMutationListener) {
        Node node;
        Object object;
        Object object2;
        Object object3;
        String string = XLinkSupport.getXLinkHref((Element)element);
        if (string.length() == 0) {
            throw new BridgeException(element, "uri.malformed", new Object[]{string});
        }
        Element element2 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element2.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        Object object4 = object3 = bl ? (Element)element2.cloneNode(true) : (Element)sVGOMDocument.importNode((Node)element2, true);
        if ("symbol".equals(object3.getLocalName())) {
            object2 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object = object3.getAttributes();
            int n = object.getLength();
            int n2 = 0;
            while (n2 < n) {
                node = (Attr)object.item(n2);
                object2.setAttributeNS(node.getNamespaceURI(), node.getName(), node.getValue());
                ++n2;
            }
            node = object3.getFirstChild();
            while (node != null) {
                object2.appendChild(node);
                node = object3.getFirstChild();
            }
            object3 = object2;
        }
        if ("svg".equals(object3.getLocalName())) {
            object2 = element.getAttributeNS(null, "width");
            if (((String)object2).length() != 0) {
                object3.setAttributeNS(null, "width", (String)object2);
            }
            if (((String)(object = element.getAttributeNS(null, "height"))).length() != 0) {
                object3.setAttributeNS(null, "height", (String)object);
            }
        }
        object2 = new SVGOMCSSImportedElementRoot((AbstractDocument)sVGOMDocument, element);
        object2.appendChild((Node)object3);
        object = (SVGOMUseElement)element;
        object.setCSSImportedElementRoot((CSSImportedElementRoot)object2);
        Element element3 = object3;
        CSSUtilities.computeStyleAndURIs(element2, (Element)object3, string);
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        node = gVTBuilder.build(bridgeContext, element3);
        boolean bl2 = true;
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            bl2 = false;
        }
        if (bl2) {
            int n = compositeGraphicsNode.size();
            int n3 = 0;
            while (n3 < n) {
                compositeGraphicsNode.remove(0);
                ++n3;
            }
        }
        compositeGraphicsNode.getChildren().add(node);
        compositeGraphicsNode.setTransform(this.computeTransform(element, bridgeContext));
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        if (bl && bridgeContext.isDynamic()) {
            EventTarget eventTarget;
            if (referencedElementMutationListener == null) {
                referencedElementMutationListener = new ReferencedElementMutationListener();
                referencedElementMutationListener.target = (EventTarget)((Object)element2);
            } else {
                EventTarget eventTarget2 = referencedElementMutationListener.target;
                eventTarget2.removeEventListener("DOMAttrModified", referencedElementMutationListener, true);
                eventTarget2.removeEventListener("DOMNodeInserted", referencedElementMutationListener, true);
                eventTarget2.removeEventListener("DOMNodeRemoved", referencedElementMutationListener, true);
                eventTarget2.removeEventListener("DOMCharacterDataModified", referencedElementMutationListener, true);
            }
            referencedElementMutationListener.target = eventTarget = (EventTarget)((Object)element2);
            eventTarget.addEventListener("DOMAttrModified", referencedElementMutationListener, true);
            bridgeContext.storeEventListener(eventTarget, "DOMAttrModified", referencedElementMutationListener, true);
            eventTarget.addEventListener("DOMNodeInserted", referencedElementMutationListener, true);
            bridgeContext.storeEventListener(eventTarget, "DOMNodeInserted", referencedElementMutationListener, true);
            eventTarget.addEventListener("DOMNodeRemoved", referencedElementMutationListener, true);
            bridgeContext.storeEventListener(eventTarget, "DOMNodeRemoved", referencedElementMutationListener, true);
            eventTarget.addEventListener("DOMCharacterDataModified", referencedElementMutationListener, true);
            bridgeContext.storeEventListener(eventTarget, "DOMCharacterDataModified", referencedElementMutationListener, true);
        }
        return compositeGraphicsNode;
    }

    protected AffineTransform computeTransform(Element element, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        float f = 0.0f;
        String string = element.getAttributeNS(null, "x");
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        float f2 = 0.0f;
        string = element.getAttributeNS(null, "y");
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        string = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        if (string.length() != 0) {
            affineTransform.preConcatenate(SVGUtilities.convertTransform(element, "transform", string));
        }
        return affineTransform;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            CursorMouseOverListener cursorMouseOverListener = new CursorMouseOverListener(bridgeContext);
            eventTarget.addEventListener("mouseover", cursorMouseOverListener, false);
            bridgeContext.storeEventListener(eventTarget, "mouseover", cursorMouseOverListener, false);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        Node node = mutationEvent.getRelatedNode();
        if (string.equals("x") || string.equals("y") || string.equals("transform")) {
            String string2 = mutationEvent.getNewValue();
            this.node.setTransform(this.computeTransform(this.e, this.ctx));
            this.handleGeometryChanged();
        } else if ("http://www.w3.org/1999/xlink".equals(node.getNamespaceURI()) && "href".equals(node.getLocalName())) {
            this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node, this.l);
        }
    }

    public class ReferencedElementMutationListener
    implements EventListener {
        EventTarget target;

        public void handleEvent(Event event) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node, this);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext bridgeContext) {
            this.ctx = bridgeContext;
        }

        public void handleEvent(Event event) {
            Cursor cursor;
            Element element = (Element)((Object)event.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(element) && (cursor = CSSUtilities.convertCursor(element, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

