/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.StringReader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.Document;

public class WindowWrapper
extends ImporterTopLevel {
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    static /* synthetic */ Class class$org$apache$batik$script$rhino$WindowWrapper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public WindowWrapper(Context context) {
        super(context);
        String[] stringArray = new String[]{"setInterval", "setTimeout", "clearInterval", "clearTimeout", "parseXML", "getURL", "alert", "confirm", "prompt"};
        try {
            this.defineFunctionProperties(stringArray, class$org$apache$batik$script$rhino$WindowWrapper == null ? (class$org$apache$batik$script$rhino$WindowWrapper = WindowWrapper.class$("org.apache.batik.script.rhino.WindowWrapper")) : class$org$apache$batik$script$rhino$WindowWrapper, 2);
        }
        catch (PropertyException propertyException) {
            throw new Error();
        }
    }

    public String getClassName() {
        return "Window";
    }

    public String toString() {
        return "[object Window]";
    }

    public static Object setInterval(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long l = (Long)Context.toType((Object)objectArray[1], Long.TYPE);
        if (objectArray[0] instanceof Function) {
            RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper functionWrapper = new FunctionWrapper(rhinoInterpreter, (Function)objectArray[0], EMPTY_ARGUMENTS);
            return window.setInterval(functionWrapper, l);
        }
        String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
        return window.setInterval(string, l);
    }

    public static Object setTimeout(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long l = (Long)Context.toType((Object)objectArray[1], Long.TYPE);
        if (objectArray[0] instanceof Function) {
            RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper functionWrapper = new FunctionWrapper(rhinoInterpreter, (Function)objectArray[0], EMPTY_ARGUMENTS);
            return window.setTimeout(functionWrapper, l);
        }
        String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
        return window.setTimeout(string, l);
    }

    public static void clearInterval(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n >= 1) {
            window.clearInterval(Context.toType((Object)objectArray[0], (Class)(class$java$lang$Object == null ? (class$java$lang$Object = WindowWrapper.class$("java.lang.Object")) : class$java$lang$Object)));
        }
    }

    public static void clearTimeout(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n >= 1) {
            window.clearTimeout(Context.toType((Object)objectArray[0], (Class)(class$java$lang$Object == null ? (class$java$lang$Object = WindowWrapper.class$("java.lang.Object")) : class$java$lang$Object)));
        }
    }

    public static Object parseXML(Context context, Scriptable scriptable, final Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        final Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        AccessControlContext accessControlContext = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        return AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$org$w3c$dom$Document;

            public Object run() {
                return window.parseXML((String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = 1.class$("java.lang.String")) : class$java$lang$String)), (Document)Context.toType((Object)objectArray[1], (Class)(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = 1.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)));
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, accessControlContext);
    }

    public static void getURL(Context context, Scriptable scriptable, final Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        final Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        ScriptableObject scriptableObject = ((RhinoInterpreter.ExtendedContext)context).getGlobalObject();
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
        final String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
        Window.GetURLHandler getURLHandler = null;
        getURLHandler = objectArray[1] instanceof Function ? new GetURLFunctionWrapper(rhinoInterpreter, (Function)objectArray[1], scriptableObject) : new GetURLObjectWrapper(rhinoInterpreter, (ScriptableObject)((NativeObject)objectArray[1]), scriptableObject);
        final Window.GetURLHandler getURLHandler2 = getURLHandler;
        AccessControlContext accessControlContext = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        if (n == 2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    window.getURL(string, getURLHandler2);
                    return null;
                }
            }, accessControlContext);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$java$lang$String;

                public Object run() {
                    window.getURL(string, getURLHandler2, (String)Context.toType((Object)objectArray[2], (Class)(class$java$lang$String == null ? (class$java$lang$String = 3.class$("java.lang.String")) : class$java$lang$String)));
                    return null;
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }, accessControlContext);
        }
    }

    public static void alert(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n >= 1) {
            String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
            window.alert(string);
        }
    }

    public static boolean confirm(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        if (n >= 1) {
            String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
            return window.confirm(string);
        }
        return false;
    }

    public static String prompt(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        int n = objectArray.length;
        Window window = ((RhinoInterpreter.ExtendedContext)context).getWindow();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
                return window.prompt(string);
            }
        }
        String string = (String)Context.toType((Object)objectArray[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
        String string2 = (String)Context.toType((Object)objectArray[1], (Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String));
        return window.prompt(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class GetURLObjectWrapper
    implements Window.GetURLHandler {
        private RhinoInterpreter interpreter;
        private ScriptableObject object;
        private ScriptableObject scope;
        private Object[] array = new Object[1];
        private static final String COMPLETE = "operationComplete";

        public GetURLObjectWrapper(RhinoInterpreter rhinoInterpreter, ScriptableObject scriptableObject, ScriptableObject scriptableObject2) {
            this.interpreter = rhinoInterpreter;
            this.object = scriptableObject;
            this.scope = scriptableObject2;
        }

        public void getURLDone(boolean bl, String string, String string2) {
            try {
                this.interpreter.callMethod(this.object, COMPLETE, new RhinoInterpreter.ArgumentsBuilder(this, bl, string, string2){
                    private final /* synthetic */ boolean val$success;
                    private final /* synthetic */ String val$mime;
                    private final /* synthetic */ String val$content;
                    private final /* synthetic */ GetURLObjectWrapper this$0;
                    {
                        this.this$0 = getURLObjectWrapper;
                        this.val$success = bl;
                        this.val$mime = string;
                        this.val$content = string2;
                    }

                    public Object[] buildArguments() {
                        Object[] objectArray = new Object[1];
                        NativeObject nativeObject = new NativeObject();
                        nativeObject.put("success", (Scriptable)nativeObject, (Object)(this.val$success ? Boolean.TRUE : Boolean.FALSE));
                        if (this.val$mime != null) {
                            nativeObject.put("contentType", (Scriptable)nativeObject, (Object)Context.toObject((Object)this.val$mime, (Scriptable)GetURLObjectWrapper.access$000(this.this$0)));
                        }
                        if (this.val$content != null) {
                            nativeObject.put("content", (Scriptable)nativeObject, (Object)Context.toObject((Object)this.val$content, (Scriptable)GetURLObjectWrapper.access$000(this.this$0)));
                        }
                        objectArray[0] = nativeObject;
                        return objectArray;
                    }
                });
            }
            catch (JavaScriptException javaScriptException) {
                Context.exit();
                throw new WrappedException((Throwable)javaScriptException);
            }
        }

        static /* synthetic */ ScriptableObject access$000(GetURLObjectWrapper getURLObjectWrapper) {
            return getURLObjectWrapper.scope;
        }
    }

    protected static class GetURLFunctionWrapper
    implements Window.GetURLHandler {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected ScriptableObject scope;

        public GetURLFunctionWrapper(RhinoInterpreter rhinoInterpreter, Function function, ScriptableObject scriptableObject) {
            this.interpreter = rhinoInterpreter;
            this.function = function;
            this.scope = scriptableObject;
        }

        public void getURLDone(boolean bl, String string, String string2) {
            try {
                this.interpreter.callHandler(this.function, new RhinoInterpreter.ArgumentsBuilder(this, bl, string, string2){
                    private final /* synthetic */ boolean val$success;
                    private final /* synthetic */ String val$mime;
                    private final /* synthetic */ String val$content;
                    private final /* synthetic */ GetURLFunctionWrapper this$0;
                    {
                        this.this$0 = getURLFunctionWrapper;
                        this.val$success = bl;
                        this.val$mime = string;
                        this.val$content = string2;
                    }

                    public Object[] buildArguments() {
                        try {
                            Object[] objectArray = new Object[1];
                            ScriptableObject scriptableObject = (ScriptableObject)this.this$0.interpreter.evaluate(new StringReader("new Object()"));
                            scriptableObject.put("success", (Scriptable)scriptableObject, (Object)(this.val$success ? Boolean.TRUE : Boolean.FALSE));
                            if (this.val$mime != null) {
                                scriptableObject.put("contentType", (Scriptable)scriptableObject, (Object)Context.toObject((Object)this.val$mime, (Scriptable)this.this$0.scope));
                            }
                            if (this.val$content != null) {
                                scriptableObject.put("content", (Scriptable)scriptableObject, (Object)Context.toObject((Object)this.val$content, (Scriptable)this.this$0.scope));
                            }
                            objectArray[0] = scriptableObject;
                            return objectArray;
                        }
                        catch (IOException iOException) {
                            throw new WrappedException((Throwable)iOException);
                        }
                        catch (InterpreterException interpreterException) {
                            throw new WrappedException((Throwable)interpreterException);
                        }
                    }
                });
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }

    protected static class FunctionWrapper
    implements Runnable {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected Object[] arguments;

        public FunctionWrapper(RhinoInterpreter rhinoInterpreter, Function function, Object[] objectArray) {
            this.interpreter = rhinoInterpreter;
            this.function = function;
            this.arguments = objectArray;
        }

        public void run() {
            try {
                this.interpreter.callHandler(this.function, this.arguments);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }
}

