/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.util.StreamUtilities;

public class PDFDocument {
    private static final Integer LOCATION_PLACEHOLDER = new Integer(0);
    protected static final String PDF_VERSION = "1.4";
    public static final String ENCODING = "ISO-8859-1";
    protected int position = 0;
    protected List location = new ArrayList();
    private List trailerObjects = new ArrayList();
    protected int objectcount = 0;
    protected List objects = new ArrayList();
    protected int xref;
    protected PDFRoot root;
    private PDFOutline outlineRoot = null;
    private PDFPages pages;
    protected PDFInfo info;
    protected PDFResources resources;
    protected PDFEncryption encryption;
    protected PDFColorSpace colorspace = new PDFColorSpace(2);
    protected int patternCount = 0;
    protected int shadingCount = 0;
    protected int xObjectCount = 0;
    protected Map xObjectsMap = new HashMap();
    protected Map fontMap = new HashMap();
    protected Map filterMap = new HashMap();
    protected List gstates = new ArrayList();
    protected List functions = new ArrayList();
    protected List shadings = new ArrayList();
    protected List patterns = new ArrayList();
    protected List links = new ArrayList();
    protected List filespecs = new ArrayList();
    protected List gotoremotes = new ArrayList();
    protected List gotos = new ArrayList();

    public PDFDocument(String prod) {
        this.pages = this.makePages();
        this.root = this.makeRoot(this.pages);
        this.resources = this.makeResources();
        this.info = this.makeInfo(prod);
    }

    public void setProducer(String producer) {
        this.info.setProducer(producer);
    }

    public void setCreator(String creator) {
        this.info.setCreator(creator);
    }

    public void setFilterMap(Map map) {
        this.filterMap = map;
    }

    public Map getFilterMap() {
        return this.filterMap;
    }

    public void setEncryption(PDFEncryptionParams params) {
        this.encryption = PDFEncryptionManager.newInstance(++this.objectcount, params);
        if (this.encryption != null) {
            this.addTrailerObject((PDFObject)((Object)this.encryption));
        } else {
            System.out.println("PDF encryption is unavailable. PDF will be generated without encryption.");
        }
    }

    public boolean isEncryptionActive() {
        return this.encryption != null;
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(++this.objectcount, pages);
        this.addTrailerObject(pdfRoot);
        return pdfRoot;
    }

    public PDFRoot getRoot() {
        return this.root;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(++this.objectcount);
        this.addTrailerObject(pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(++this.objectcount);
        this.addTrailerObject(pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo(String prod) {
        PDFInfo pdfInfo = new PDFInfo(++this.objectcount);
        pdfInfo.setProducer(prod);
        this.objects.add(pdfInfo);
        return pdfInfo;
    }

    public PDFInfo getInfo() {
        return this.info;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theSize, int theBitsPerSample, int theOrder, List theEncode, List theDecode, StringBuffer theFunctionDataStream, List theFilter) {
        PDFFunction function;
        PDFFunction oldfunc;
        if ((oldfunc = this.findFunction(function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theSize, theBitsPerSample, theOrder, theEncode, theDecode, theFunctionDataStream, theFilter))) == null) {
            this.functions.add(function);
            this.objects.add(function);
        } else {
            --this.objectcount;
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theCZero, List theCOne, double theInterpolationExponentN) {
        PDFFunction function;
        PDFFunction oldfunc;
        if ((oldfunc = this.findFunction(function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theCZero, theCOne, theInterpolationExponentN))) == null) {
            this.functions.add(function);
            this.objects.add(function);
        } else {
            --this.objectcount;
            function = oldfunc;
        }
        return function;
    }

    private Object findPDFObject(List list, PDFObject compare) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!compare.equals(obj)) continue;
            return obj;
        }
        return null;
    }

    private PDFFunction findFunction(PDFFunction compare) {
        return (PDFFunction)this.findPDFObject(this.functions, compare);
    }

    private PDFShading findShading(PDFShading compare) {
        return (PDFShading)this.findPDFObject(this.shadings, compare);
    }

    private PDFPattern findPattern(PDFPattern compare) {
        return (PDFPattern)this.findPDFObject(this.patterns, compare);
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theFunctions, List theBounds, List theEncode) {
        PDFFunction function;
        PDFFunction oldfunc;
        if ((oldfunc = this.findFunction(function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theFunctions, theBounds, theEncode))) == null) {
            this.functions.add(function);
            this.objects.add(function);
        } else {
            --this.objectcount;
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theNumber, int theFunctionType, List theDomain, List theRange, StringBuffer theFunctionDataStream) {
        PDFFunction function;
        PDFFunction oldfunc;
        if ((oldfunc = this.findFunction(function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theFunctionDataStream))) == null) {
            this.functions.add(function);
            this.objects.add(function);
        } else {
            --this.objectcount;
            function = oldfunc;
        }
        return function;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        PDFShading shading;
        PDFShading oldshad;
        String theShadingName = new String("Sh" + ++this.shadingCount);
        if ((oldshad = this.findShading(shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theDomain, theMatrix, theFunction))) == null) {
            this.shadings.add(shading);
            this.objects.add(shading);
        } else {
            --this.objectcount;
            --this.shadingCount;
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.resources.addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        PDFShading shading;
        PDFShading oldshad;
        String theShadingName = new String("Sh" + ++this.shadingCount);
        if ((oldshad = this.findShading(shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theCoords, theDomain, theFunction, theExtend))) == null) {
            this.shadings.add(shading);
            this.objects.add(shading);
        } else {
            --this.objectcount;
            --this.shadingCount;
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.resources.addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        PDFShading shading;
        PDFShading oldshad;
        String theShadingName = new String("Sh" + ++this.shadingCount);
        if ((oldshad = this.findShading(shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theBitsPerFlag, theDecode, theFunction))) == null) {
            this.shadings.add(shading);
            this.objects.add(shading);
        } else {
            --this.objectcount;
            --this.shadingCount;
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.resources.addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        PDFShading shading;
        PDFShading oldshad;
        String theShadingName = new String("Sh" + ++this.shadingCount);
        if ((oldshad = this.findShading(shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theDecode, theVerticesPerRow, theFunction))) == null) {
            this.shadings.add(shading);
            this.objects.add(shading);
        } else {
            --this.objectcount;
            --this.shadingCount;
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.resources.addShading(shading);
        }
        return shading;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        PDFPattern pattern;
        PDFPattern oldpatt;
        String thePatternName = new String("Pa" + ++this.patternCount);
        if ((oldpatt = this.findPattern(pattern = new PDFPattern(++this.objectcount, thePatternName, theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream))) == null) {
            this.patterns.add(pattern);
            this.objects.add(pattern);
        } else {
            --this.objectcount;
            --this.patternCount;
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.resources.addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        PDFPattern pattern;
        PDFPattern oldpatt;
        String thePatternName = new String("Pa" + ++this.patternCount);
        if ((oldpatt = this.findPattern(pattern = new PDFPattern(++this.objectcount, thePatternName, 2, theShading, theXUID, theExtGState, theMatrix))) == null) {
            this.patterns.add(pattern);
            this.objects.add(pattern);
        } else {
            --this.objectcount;
            --this.patternCount;
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.resources.addPattern(pattern);
        }
        return pattern;
    }

    public int getColorSpace() {
        return this.colorspace.getColorSpace();
    }

    public void setColorSpace(int theColorspace) {
        this.colorspace.setColorSpace(theColorspace);
    }

    public PDFPattern createGradient(PDFResourceContext res, boolean radial, PDFColorSpace theColorspace, List theColors, List theBounds, List theCoords) {
        PDFShading myShad;
        double interpolation = 1.0;
        ArrayList<PDFFunction> theFunctions = new ArrayList<PDFFunction>();
        int lastPosition = theColors.size() - 1;
        int currentPosition = 0;
        while (currentPosition < lastPosition) {
            PDFColor currentColor = (PDFColor)theColors.get(currentPosition);
            PDFColor nextColor = (PDFColor)theColors.get(currentPosition + 1);
            if (this.colorspace.getColorSpace() != currentColor.getColorSpace()) {
                currentColor.setColorSpace(this.colorspace.getColorSpace());
            }
            if (this.colorspace.getColorSpace() != nextColor.getColorSpace()) {
                nextColor.setColorSpace(this.colorspace.getColorSpace());
            }
            List theCzero = currentColor.getVector();
            List theCone = nextColor.getVector();
            PDFFunction myfunc = this.makeFunction(2, null, null, theCzero, theCone, interpolation);
            theFunctions.add(myfunc);
            ++currentPosition;
        }
        PDFFunction myfunky = this.makeFunction(3, null, null, theFunctions, theBounds, null);
        if (radial) {
            if (theCoords.size() == 6) {
                myShad = this.makeShading(res, 3, this.colorspace, null, null, false, theCoords, null, myfunky, null);
            } else {
                ArrayList newCoords = new ArrayList();
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(theCoords.get(2));
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(new Double(0.0));
                myShad = this.makeShading(res, 3, this.colorspace, null, null, false, newCoords, null, myfunky, null);
            }
        } else {
            myShad = this.makeShading(res, 2, this.colorspace, null, null, false, theCoords, null, myfunky, null);
        }
        PDFPattern myPattern = this.makePattern(res, 2, myShad, null, null, null);
        return myPattern;
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(++this.objectcount, encodingName);
        this.objects.add(encoding);
        return encoding;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream(++this.objectcount);
        this.objects.add(iccStream);
        return iccStream;
    }

    public Map getFontMap() {
        return this.fontMap;
    }

    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetrics metrics, FontDescriptor descriptor) {
        if (this.fontMap.containsKey(fontname)) {
            return (PDFFont)this.fontMap.get(fontname);
        }
        if (descriptor == null) {
            PDFFont font = new PDFFont(++this.objectcount, fontname, FontType.TYPE1, basefont, encoding);
            this.objects.add(font);
            this.fontMap.put(fontname, font);
            return font;
        }
        FontType fonttype = metrics.getFontType();
        PDFFontDescriptor pdfdesc = this.makeFontDescriptor(descriptor);
        PDFFontNonBase14 font = null;
        font = fonttype == FontType.TYPE0 ? (PDFFontNonBase14)PDFFont.createFont(++this.objectcount, fontname, fonttype, basefont, "Identity-H") : (PDFFontNonBase14)PDFFont.createFont(++this.objectcount, fontname, fonttype, basefont, encoding);
        this.objects.add(font);
        font.setDescriptor(pdfdesc);
        if (fonttype == FontType.TYPE0) {
            CIDFont cidMetrics = metrics instanceof LazyFont ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
            PDFCIDSystemInfo sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
            PDFCIDFont cidFont = new PDFCIDFont(++this.objectcount, basefont, cidMetrics.getCIDType(), cidMetrics.getDefaultWidth(), cidMetrics.getWidths(), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
            this.objects.add(cidFont);
            ((PDFFontType0)font).setDescendantFonts(cidFont);
        } else {
            int firstChar = 0;
            int lastChar = 255;
            if (metrics instanceof CustomFont) {
                CustomFont cf = (CustomFont)metrics;
                firstChar = cf.getFirstChar();
                lastChar = cf.getLastChar();
            }
            font.setWidthMetrics(firstChar, lastChar, this.makeArray(metrics.getWidths()));
        }
        this.fontMap.put(fontname, font);
        return font;
    }

    public PDFFontDescriptor makeFontDescriptor(FontDescriptor desc) {
        PDFStream stream;
        PDFFontDescriptor font = null;
        font = desc.getFontType() == FontType.TYPE0 ? new PDFCIDFontDescriptor(++this.objectcount, desc.getFontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(++this.objectcount, desc.getFontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getStemV(), desc.getItalicAngle());
        this.objects.add(font);
        if (desc.isEmbeddable() && (stream = this.makeFontFile(this.objectcount + 1, desc)) != null) {
            ++this.objectcount;
            font.setFontFile(desc.getFontType(), stream);
            this.objects.add(stream);
        }
        return font;
    }

    protected InputStream resolveURI(String uri) throws FileNotFoundException {
        try {
            return new URL(uri).openStream();
        }
        catch (Exception e) {
            throw new FileNotFoundException("URI could not be resolved (" + e.getMessage() + "): " + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PDFStream makeFontFile(int obj, FontDescriptor desc) {
        if (desc.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + desc.getFontType());
        }
        if (!(desc instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + desc.getClass().getName());
        }
        CustomFont font = (CustomFont)desc;
        InputStream in = null;
        try {
            PDFStream pDFStream;
            if (font.getEmbedFileName() != null) {
                try {
                    in = this.resolveURI(font.getEmbedFileName());
                }
                catch (Exception e) {
                    System.out.println("Failed to embed fontfile: " + font.getEmbedFileName());
                }
            }
            if (in == null && font.getEmbedResourceName() != null) {
                try {
                    in = new BufferedInputStream(this.getClass().getResourceAsStream(font.getEmbedResourceName()));
                }
                catch (Exception e) {
                    System.out.println("Failed to embed fontresource: " + font.getEmbedResourceName());
                }
            }
            if (in == null) {
                return null;
            }
            try {
                PDFStream embeddedFont;
                if (desc.getFontType() == FontType.TYPE0) {
                    MultiByteFont mbfont = (MultiByteFont)font;
                    FontFileReader reader = new FontFileReader(in);
                    TTFSubSetFile subset = new TTFSubSetFile();
                    byte[] subsetFont = subset.readFont(reader, mbfont.getTTCName(), mbfont.getUsedGlyphs());
                    embeddedFont = new PDFTTFStream(obj, subsetFont.length);
                    ((PDFTTFStream)embeddedFont).setData(subsetFont, subsetFont.length);
                } else if (desc.getFontType() == FontType.TYPE1) {
                    PFBParser parser = new PFBParser();
                    PFBData pfb = parser.parsePFB(in);
                    embeddedFont = new PDFT1Stream(obj);
                    ((PDFT1Stream)embeddedFont).setData(pfb);
                } else {
                    byte[] file = StreamUtilities.toByteArray(in, 128000);
                    embeddedFont = new PDFTTFStream(obj, file.length);
                    ((PDFTTFStream)embeddedFont).setData(file, file.length);
                }
                embeddedFont.addFilter("flate");
                embeddedFont.addFilter("ascii-85");
                pDFStream = embeddedFont;
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return pDFStream;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(++this.objectcount, values);
        this.objects.add(array);
        return array;
    }

    public PDFGState makeGState(Map settings, PDFGState current) {
        PDFGState wanted = new PDFGState(0);
        wanted.addValues(PDFGState.DEFAULT);
        wanted.addValues(settings);
        Iterator iter = this.gstates.iterator();
        while (iter.hasNext()) {
            PDFGState avail = (PDFGState)iter.next();
            PDFGState poss = new PDFGState(0);
            poss.addValues(current);
            poss.addValues(avail);
            if (!poss.equals(wanted)) continue;
            return avail;
        }
        PDFGState gstate = new PDFGState(++this.objectcount);
        gstate.addValues(settings);
        this.objects.add(gstate);
        this.gstates.add(gstate);
        return gstate;
    }

    public PDFXObject getImage(String key) {
        PDFXObject xObject = (PDFXObject)this.xObjectsMap.get(key);
        return xObject;
    }

    public PDFXObject addImage(PDFResourceContext res, PDFImage img) {
        String key = img.getKey();
        PDFXObject xObject = (PDFXObject)this.xObjectsMap.get(key);
        if (xObject != null) {
            if (res != null) {
                res.getPDFResources().addXObject(xObject);
            }
            return xObject;
        }
        img.setup(this);
        xObject = new PDFXObject(++this.objectcount, ++this.xObjectCount, img);
        this.objects.add(xObject);
        this.resources.addXObject(xObject);
        if (res != null) {
            res.getPDFResources().addXObject(xObject);
        }
        this.xObjectsMap.put(key, xObject);
        return xObject;
    }

    public PDFFormXObject addFormXObject(PDFResourceContext res, PDFStream cont, PDFResources formres, String key) {
        PDFFormXObject xObject = new PDFFormXObject(++this.objectcount, ++this.xObjectCount, cont, formres.referencePDF());
        this.objects.add(xObject);
        this.resources.addXObject(xObject);
        if (res != null) {
            res.getPDFResources().addXObject(xObject);
        }
        return xObject;
    }

    public PDFPage makePage(PDFResources resources, int pagewidth, int pageheight) {
        PDFPage page = new PDFPage(this, ++this.objectcount, resources, pagewidth, pageheight);
        this.pages.addPage(page);
        return page;
    }

    public void addPage(PDFPage page) {
        this.objects.add(page);
    }

    private PDFLink findLink(PDFLink compare) {
        return (PDFLink)this.findPDFObject(this.links, compare);
    }

    private PDFFileSpec findFileSpec(PDFFileSpec compare) {
        return (PDFFileSpec)this.findPDFObject(this.filespecs, compare);
    }

    private PDFGoToRemote findGoToRemote(PDFGoToRemote compare) {
        return (PDFGoToRemote)this.findPDFObject(this.gotoremotes, compare);
    }

    private PDFGoTo findGoTo(PDFGoTo compare) {
        return (PDFGoTo)this.findPDFObject(this.gotos, compare);
    }

    public PDFLink makeLink(Rectangle2D rect, String destination, int linkType, float yoffset) {
        PDFLink link = new PDFLink(++this.objectcount, rect);
        if (linkType == 0) {
            if (destination.startsWith("http://")) {
                PDFUri uri = new PDFUri(destination);
                link.setAction(uri);
            } else if (destination.endsWith(".pdf")) {
                PDFGoToRemote remote = this.getGoToPDFAction(destination, null, -1);
                link.setAction(remote);
            } else {
                int index = destination.indexOf(".pdf#page=");
                if (index > 0) {
                    int page = Integer.parseInt(destination.substring(index + 10));
                    PDFGoToRemote remote = this.getGoToPDFAction(destination, null, page);
                    link.setAction(remote);
                } else {
                    index = destination.indexOf(".pdf#dest=");
                    if (index > 0) {
                        String dest = destination.substring(index + 10);
                        PDFGoToRemote remote = this.getGoToPDFAction(destination, dest, -1);
                        link.setAction(remote);
                    } else {
                        PDFUri uri = new PDFUri(destination);
                        link.setAction(uri);
                    }
                }
            }
        } else {
            String goToReference = this.getGoToReference(destination, yoffset);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction(internalLink);
        }
        PDFLink oldlink = this.findLink(link);
        if (oldlink == null) {
            this.links.add(link);
            this.objects.add(link);
        } else {
            --this.objectcount;
            link = oldlink;
        }
        return link;
    }

    private PDFGoToRemote getGoToPDFAction(String file, String dest, int page) {
        PDFFileSpec fileSpec;
        PDFFileSpec oldspec;
        if ((oldspec = this.findFileSpec(fileSpec = new PDFFileSpec(++this.objectcount, file))) == null) {
            this.filespecs.add(fileSpec);
            this.objects.add(fileSpec);
        } else {
            --this.objectcount;
            fileSpec = oldspec;
        }
        PDFGoToRemote remote = dest == null && page == -1 ? new PDFGoToRemote(++this.objectcount, fileSpec) : (dest != null ? new PDFGoToRemote(++this.objectcount, fileSpec, dest) : new PDFGoToRemote(++this.objectcount, fileSpec, page));
        PDFGoToRemote oldremote = this.findGoToRemote(remote);
        if (oldremote == null) {
            this.gotoremotes.add(remote);
            this.objects.add(remote);
        } else {
            --this.objectcount;
            remote = oldremote;
        }
        return remote;
    }

    private String getGoToReference(String destination, float yoffset) {
        String goToReference = null;
        PDFGoTo gt = new PDFGoTo(++this.objectcount, destination);
        gt.setYPosition(yoffset);
        PDFGoTo oldgt = this.findGoTo(gt);
        if (oldgt == null) {
            this.gotos.add(gt);
            this.addTrailerObject(gt);
        } else {
            --this.objectcount;
            gt = oldgt;
        }
        goToReference = gt.referencePDF();
        return goToReference;
    }

    public void addTrailerObject(PDFObject object) {
        this.trailerObjects.add(object);
    }

    public PDFLink makeLink(Rectangle2D rect, String page, String dest) {
        PDFLink link = new PDFLink(++this.objectcount, rect);
        this.objects.add(link);
        PDFGoTo gt = new PDFGoTo(++this.objectcount, page);
        gt.setDestination(dest);
        this.addTrailerObject(gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction(internalLink);
        return link;
    }

    private void prepareLocations() {
        while (this.location.size() < this.objectcount) {
            this.location.add(LOCATION_PLACEHOLDER);
        }
    }

    public PDFStream makeStream(String type, boolean add) {
        PDFStream obj = new PDFStream(++this.objectcount);
        obj.addDefaultFilters(this.filterMap, type);
        if (this.isEncryptionActive()) {
            this.encryption.applyFilter(obj);
        }
        if (add) {
            this.objects.add(obj);
        }
        return obj;
    }

    public void addStream(PDFStream obj) {
        this.objects.add(obj);
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList(++this.objectcount);
        return obj;
    }

    public void addAnnotList(PDFAnnotList obj) {
        this.objects.add(obj);
    }

    public PDFOutline getOutlineRoot() {
        if (this.outlineRoot != null) {
            return this.outlineRoot;
        }
        this.outlineRoot = new PDFOutline(++this.objectcount, null, null);
        this.addTrailerObject(this.outlineRoot);
        this.root.setRootOutline(this.outlineRoot);
        return this.outlineRoot;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination, float yoffset) {
        String goToRef = this.getGoToReference(destination, yoffset);
        PDFOutline obj = new PDFOutline(++this.objectcount, label, goToRef);
        if (parent != null) {
            parent.addOutline(obj);
        }
        this.objects.add(obj);
        return obj;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public void output(OutputStream stream) throws IOException {
        this.prepareLocations();
        int count = 0;
        while (count < this.objects.size()) {
            PDFObject object = (PDFObject)this.objects.get(count);
            this.location.set(object.getNumber() - 1, new Integer(this.position));
            this.position += object.output(stream);
            ++count;
        }
        this.objects.clear();
    }

    public void outputHeader(OutputStream stream) throws IOException {
        this.position = 0;
        byte[] pdf = "%PDF-1.4\n".getBytes();
        stream.write(pdf);
        this.position += pdf.length;
        byte[] bin = new byte[]{37, -86, -85, -84, -83, 10};
        stream.write(bin);
        this.position += bin.length;
    }

    public void outputTrailer(OutputStream stream) throws IOException {
        this.output(stream);
        int count = 0;
        while (count < this.trailerObjects.size()) {
            PDFObject o = (PDFObject)this.trailerObjects.get(count);
            this.location.set(o.getNumber() - 1, new Integer(this.position));
            this.position += o.output(stream);
            ++count;
        }
        this.position += this.outputXref(stream);
        String encryptEntry = "";
        if (this.encryption != null) {
            encryptEntry = this.encryption.getTrailerEntry();
        }
        String pdf = "trailer\n<<\n/Size " + (this.objectcount + 1) + "\n" + "/Root " + this.root.number + " " + this.root.generation + " R\n" + "/Info " + this.info.number + " " + this.info.generation + " R\n" + encryptEntry + ">>\n" + "startxref\n" + this.xref + "\n" + "%%EOF\n";
        stream.write(pdf.getBytes());
    }

    private int outputXref(OutputStream stream) throws IOException {
        this.xref = this.position;
        StringBuffer pdf = new StringBuffer("xref\n0 " + (this.objectcount + 1) + "\n0000000000 65535 f \n");
        int count = 0;
        while (count < this.location.size()) {
            String x = this.location.get(count).toString();
            String padding = "0000000000";
            String loc = padding.substring(x.length()) + x;
            pdf = pdf.append(loc + " 00000 n \n");
            ++count;
        }
        byte[] pdfBytes = pdf.toString().getBytes();
        stream.write(pdfBytes);
        return pdfBytes.length;
    }
}

