/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFEncryptionJCE
extends PDFObject
implements PDFEncryption {
    private static final char[] PAD = new char[]{'(', '\u00bf', 'N', '^', 'N', 'u', '\u008a', 'A', 'd', '\u0000', 'N', 'V', '\u00ff', '\u00fa', '\u0001', '\b', '.', '.', '\u0000', '\u00b6', '\u00d0', 'h', '>', '\u0080', '/', '\f', '\u00a9', '\u00fe', 'd', 'S', 'i', 'z'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int PERMISSION_PRINT = 4;
    public static final int PERMISSION_EDIT_CONTENT = 8;
    public static final int PERMISSION_COPY_CONTENT = 16;
    public static final int PERMISSION_EDIT_ANNOTATIONS = 32;
    private MessageDigest digest = null;
    private Cipher cipher = null;
    private Random random = new Random();
    private PDFEncryptionParams params;
    private byte[] fileID = null;
    private byte[] encryptionKey = null;
    private String dictionary = null;

    public PDFEncryptionJCE(int number) {
        super(number);
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.cipher = Cipher.getInstance("RC4");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public static PDFEncryption make(int objnum, PDFEncryptionParams params) {
        PDFEncryptionJCE impl = new PDFEncryptionJCE(objnum);
        impl.setParams(params);
        impl.init();
        return impl;
    }

    public PDFEncryptionParams getParams() {
        return this.params;
    }

    public void setParams(PDFEncryptionParams params) {
        this.params = params;
    }

    private byte[] prepPassword(String password) {
        byte[] obuffer = new byte[32];
        byte[] pbuffer = password.getBytes();
        int i = 0;
        int j = 0;
        while (i < obuffer.length && i < pbuffer.length) {
            obuffer[i] = pbuffer[i];
            ++i;
        }
        while (i < obuffer.length) {
            obuffer[i++] = (byte)PAD[j++];
        }
        return obuffer;
    }

    private String toHex(byte[] value) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buffer.append(DIGITS[value[i] >>> 4 & 0xF]);
            buffer.append(DIGITS[value[i] & 0xF]);
            ++i;
        }
        return buffer.toString();
    }

    public byte[] getFileID() {
        if (this.fileID == null) {
            this.fileID = new byte[16];
            this.random.nextBytes(this.fileID);
        }
        return this.fileID;
    }

    public String getFileID(int index) {
        if (index == 1) {
            return this.toHex(this.getFileID());
        }
        byte[] id = new byte[16];
        this.random.nextBytes(id);
        return this.toHex(id);
    }

    private byte[] encryptWithKey(byte[] data, byte[] key) {
        try {
            SecretKeySpec keyspec = new SecretKeySpec(key, "RC4");
            this.cipher.init(1, keyspec);
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private byte[] encryptWithHash(byte[] data, byte[] hash, int size) {
        hash = this.digest.digest(hash);
        byte[] key = new byte[size];
        int i = 0;
        while (i < size) {
            key[i] = hash[i];
            ++i;
        }
        return this.encryptWithKey(data, key);
    }

    public void init() {
        byte[] oValue = this.params.getOwnerPassword().length() > 0 ? this.encryptWithHash(this.prepPassword(this.params.getUserPassword()), this.prepPassword(this.params.getOwnerPassword()), 5) : this.encryptWithHash(this.prepPassword(this.params.getUserPassword()), this.prepPassword(this.params.getUserPassword()), 5);
        int permissions = -4;
        if (!this.params.isAllowPrint()) {
            permissions -= 4;
        }
        if (!this.params.isAllowCopyContent()) {
            permissions -= 16;
        }
        if (!this.params.isAllowEditContent()) {
            permissions -= 8;
        }
        if (!this.params.isAllowEditAnnotations()) {
            permissions -= 32;
        }
        this.digest.update(this.prepPassword(this.params.getUserPassword()));
        this.digest.update(oValue);
        this.digest.update((byte)(permissions >>> 0));
        this.digest.update((byte)(permissions >>> 8));
        this.digest.update((byte)(permissions >>> 16));
        this.digest.update((byte)(permissions >>> 24));
        this.digest.update(this.getFileID());
        byte[] hash = this.digest.digest();
        this.encryptionKey = new byte[5];
        int i = 0;
        while (i < 5) {
            this.encryptionKey[i] = hash[i];
            ++i;
        }
        byte[] uValue = this.encryptWithKey(this.prepPassword(""), this.encryptionKey);
        this.dictionary = this.number + " " + this.generation + " obj\n<< /Filter /Standard\n" + "/V 1\n" + "/R 2\n" + "/Length 40\n" + "/P " + permissions + "\n" + "/O <" + this.toHex(oValue) + ">\n" + "/U <" + this.toHex(uValue) + ">\n" + ">>\n" + "endobj\n";
    }

    public byte[] encryptData(byte[] data, int number, int generation) {
        if (this.encryptionKey == null) {
            throw new IllegalStateException("PDF Encryption has not been initialized");
        }
        byte[] hash = new byte[this.encryptionKey.length + 5];
        int i = 0;
        while (i < this.encryptionKey.length) {
            hash[i] = this.encryptionKey[i];
            ++i;
        }
        hash[i++] = (byte)(number >>> 0);
        hash[i++] = (byte)(number >>> 8);
        hash[i++] = (byte)(number >>> 16);
        hash[i++] = (byte)(generation >>> 0);
        hash[i++] = (byte)(generation >>> 8);
        return this.encryptWithHash(data, hash, hash.length);
    }

    public PDFFilter makeFilter(int number, int generation) {
        return new EncryptionFilter(this, number, generation);
    }

    public void applyFilter(PDFStream stream) {
        stream.addFilter(this.makeFilter(stream.number, stream.generation));
    }

    public byte[] toPDF() {
        if (this.dictionary == null) {
            throw new IllegalStateException("PDF Encryption has not been initialized");
        }
        try {
            return this.dictionary.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return this.dictionary.getBytes();
        }
    }

    public String getTrailerEntry() {
        return "/Encrypt " + this.number + " " + this.generation + " R\n" + "/ID[<" + this.getFileID(1) + "><" + this.getFileID(2) + ">]\n";
    }

    private class EncryptionFilter
    extends PDFFilter {
        private PDFEncryptionJCE encryption;
        private int number;
        private int generation;

        public EncryptionFilter(PDFEncryptionJCE encryption, int number, int generation) {
            this.encryption = encryption;
            this.number = number;
            this.generation = generation;
        }

        public String getName() {
            return "";
        }

        public String getDecodeParms() {
            return null;
        }

        public byte[] encode(byte[] data) {
            return this.encryption.encryptData(data, this.number, this.generation);
        }

        public void encode(InputStream in, OutputStream out, int length) throws IOException {
            byte[] buffer = new byte[length];
            in.read(buffer);
            buffer = this.encode(buffer);
            out.write(buffer);
        }
    }
}

