/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;

public class PDFGoToRemote
extends PDFAction {
    private PDFFileSpec pdfFileSpec;
    private int pageReference = 0;
    private String destination = null;

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
    }

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec, int page) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
        this.pageReference = page;
    }

    public PDFGoToRemote(int number, PDFFileSpec pdfFileSpec, String dest) {
        super(number);
        this.pdfFileSpec = pdfFileSpec;
        this.destination = dest;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public byte[] toPDF() {
        String p = new String(this.number + " " + this.generation + " obj\n" + "<<\n/S /GoToR\n" + "/F " + this.pdfFileSpec.referencePDF() + "\n");
        p = this.destination != null ? p + "/D (" + this.destination + ")" : p + "/D [ " + this.pageReference + " /XYZ null null null ]";
        p = p + " \n>>\nendobj\n";
        return p.getBytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFGoToRemote)) {
            return false;
        }
        PDFGoToRemote remote = (PDFGoToRemote)obj;
        if (!remote.pdfFileSpec.referencePDF().equals(this.pdfFileSpec.referencePDF())) {
            return false;
        }
        return !(this.destination != null ? !this.destination.equals(remote.destination) : this.pageReference != remote.pageReference);
    }
}

