/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFObject;

public class PDFOutline
extends PDFObject {
    private List subentries = new ArrayList();
    private PDFOutline parent = null;
    private PDFOutline prev = null;
    private PDFOutline next = null;
    private PDFOutline first = null;
    private PDFOutline last = null;
    private int count = 0;
    private String title;
    private String actionRef;

    public PDFOutline(int number, String title, String action) {
        super(number);
        this.title = title;
        this.actionRef = action;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void addOutline(PDFOutline outline) {
        if (this.subentries.size() > 0) {
            outline.prev = (PDFOutline)this.subentries.get(this.subentries.size() - 1);
            outline.prev.next = outline;
        } else {
            this.first = outline;
        }
        this.subentries.add(outline);
        outline.parent = this;
        this.incrementCount();
        this.last = outline;
    }

    private void incrementCount() {
        ++this.count;
        if (this.parent != null) {
            this.parent.incrementCount();
        }
    }

    protected byte[] toPDF() {
        StringBuffer result = new StringBuffer(this.number + " " + this.generation + " obj\n<<\n");
        if (this.parent == null) {
            if (this.first != null && this.last != null) {
                result.append(" /First " + this.first.referencePDF() + "\n");
                result.append(" /Last " + this.last.referencePDF() + "\n");
            }
        } else {
            result.append(" /Title (" + this.escapeString(this.title) + ")\n");
            result.append(" /Parent " + this.parent.referencePDF() + "\n");
            if (this.first != null && this.last != null) {
                result.append(" /First " + this.first.referencePDF() + "\n");
                result.append(" /Last " + this.last.referencePDF() + "\n");
            }
            if (this.prev != null) {
                result.append(" /Prev " + this.prev.referencePDF() + "\n");
            }
            if (this.next != null) {
                result.append(" /Next " + this.next.referencePDF() + "\n");
            }
            if (this.count > 0) {
                result.append(" /Count -" + this.count + "\n");
            }
            if (this.actionRef != null) {
                result.append(" /A " + this.actionRef + "\n");
            }
        }
        result.append(">> endobj\n");
        return result.toString().getBytes();
    }

    private String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            int l = s.length();
            result.append("\\376\\377");
            int i = 0;
            while (i < l) {
                char ch = s.charAt(i);
                int high = (ch & 0xFF00) >>> 8;
                int low = ch & 0xFF;
                result.append("\\");
                result.append(Integer.toOctalString(high));
                result.append("\\");
                result.append(Integer.toOctalString(low));
                ++i;
            }
        }
        return result.toString();
    }
}

