/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D {
    private PDFPage currentPage;
    private PDFStream pdfStream;
    private int width;
    private int height;

    PDFDocumentGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        if (!textAsShapes) {
            this.fontInfo = new FontInfo();
            FontSetup.setup(this.fontInfo, null);
        }
        this.pdfDoc = new PDFDocument("FOP SVG Renderer");
        this.graphicsState = new PDFState();
        this.currentFontName = "";
        this.currentFontSize = 0.0f;
        this.pdfStream = this.pdfDoc.makeStream("content", false);
    }

    public void setupDocument(OutputStream stream, int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        PDFResources pdfResources = this.pdfDoc.getResources();
        this.currentPage = this.pdfDoc.makePage(pdfResources, width, height);
        this.resourceContext = this.currentPage;
        this.pageRef = this.currentPage.referencePDF();
        this.currentStream.write("1 0 0 -1 0 " + height + " cm\n");
        this.graphicsState.setTransform(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)height));
        this.pdfDoc.outputHeader(stream);
        this.setOutputStream(stream);
    }

    public PDFDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws IOException {
        this(textAsShapes);
        this.setupDocument(stream, width, height);
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public void setSVGDimension(float w, float h) {
        this.currentStream.write("" + PDFNumber.doubleOut((float)this.width / w) + " 0 0 " + PDFNumber.doubleOut((float)this.height / h) + " 0 0 cm\n");
    }

    public void setBackgroundColor(Color col) {
        Color c = col;
        PDFColor currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
        this.currentStream.write("q\n");
        this.currentStream.write(currentColour.getColorSpaceOut(true));
        this.currentStream.write("0 0 " + this.width + " " + this.height + " re\n");
        this.currentStream.write("f\n");
        this.currentStream.write("Q\n");
    }

    public void finish() throws IOException {
        this.pdfStream.add(this.getString());
        this.pdfDoc.addStream(this.pdfStream);
        this.currentPage.setContents(this.pdfStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addAnnotList(annots);
        }
        this.pdfDoc.addPage(this.currentPage);
        if (this.fontInfo != null) {
            FontSetup.addToResources(this.pdfDoc, this.pdfDoc.getResources(), this.fontInfo);
        }
        this.pdfDoc.output(this.outputStream);
        this.pdfDoc.outputTrailer(this.outputStream);
        this.outputStream.flush();
    }

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D g) {
        super(g);
    }

    public Graphics create() {
        return new PDFDocumentGraphics2D(this);
    }

    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext frc = super.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, s);
            Shape glyphOutline = gv.getOutline(x, y);
            super.fill(glyphOutline);
        } else {
            super.drawString(s, x, y);
        }
    }
}

