/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectOutputStream;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class XMLObjectWriter {
    private String encoding = null;
    private int whiteSpaceNumForIndent = 2;
    private OutputStream outputStream;

    public XMLObjectWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeObject(Object object) throws Exception {
        Document document = this.buildDocument(object);
        this.writeDocument(document);
    }

    protected Document buildDocument(Object object) throws Exception {
        Document doc = this.createDocument();
        XMLObjectOutputStream xmlStream = new XMLObjectOutputStream(doc);
        xmlStream.writeObject(object);
        return doc;
    }

    protected void writeDocument(Document document) throws IOException {
        OutputFormat format = new OutputFormat(document);
        format.setIndent(this.whiteSpaceNumForIndent);
        format.setIndenting(true);
        format.setLineWidth(150);
        if (this.encoding != null) {
            format.setEncoding(this.encoding);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
        XMLSerializer serial = new XMLSerializer((Writer)writer, format);
        serial.asDOMSerializer();
        serial.serialize(document.getDocumentElement());
        writer.flush();
    }

    protected Document createDocument() {
        return new DocumentImpl();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encode) {
        this.encoding = encode;
    }

    public int getWhiteSpaceNumForIndent() {
        return this.whiteSpaceNumForIndent;
    }

    public void setWhiteSpaceNumForIndent(int indent) {
        this.whiteSpaceNumForIndent = indent;
    }
}

