/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PropertyUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class PNGRed
extends AbstractRed {
    public static final int PNG_COLOR_GRAY = 0;
    public static final int PNG_COLOR_RGB = 2;
    public static final int PNG_COLOR_PALETTE = 3;
    public static final int PNG_COLOR_GRAY_ALPHA = 4;
    public static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final String[] colorTypeNames = new String[]{"Grayscale", "Error", "Truecolor", "Index", "Grayscale with alpha", "Error", "Truecolor with alpha"};
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    private static final int RED_OFFSET = 2;
    private static final int GREEN_OFFSET = 1;
    private static final int BLUE_OFFSET = 0;
    private int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int paletteEntries;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private int bkgdRed;
    private int bkgdGreen;
    private int bkgdBlue;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private int maxOpacity;
    private int[] significantBits = null;
    private boolean hasBackground = false;
    private boolean suppressAlpha = false;
    private boolean expandPalette = false;
    private boolean output8BitGray = false;
    private boolean outputHasAlphaPalette = false;
    private boolean performGammaCorrection = false;
    private boolean expandGrayAlpha = false;
    private boolean generateEncodeParam = false;
    private PNGDecodeParam decodeParam = null;
    private PNGEncodeParam encodeParam = null;
    private boolean emitProperties = true;
    private float fileGamma = 0.45455f;
    private float userExponent = 1.0f;
    private float displayExponent = 2.2f;
    private float[] chromaticity = null;
    private int sRGBRenderingIntent = -1;
    private int postProcess = 0;
    private static final int POST_NONE = 0;
    private static final int POST_GAMMA = 1;
    private static final int POST_GRAY_LUT = 2;
    private static final int POST_GRAY_LUT_ADD_TRANS = 3;
    private static final int POST_PALETTE_TO_RGB = 4;
    private static final int POST_PALETTE_TO_RGBA = 5;
    private static final int POST_ADD_GRAY_TRANS = 6;
    private static final int POST_ADD_RGB_TRANS = 7;
    private static final int POST_REMOVE_GRAY_TRANS = 8;
    private static final int POST_REMOVE_RGB_TRANS = 9;
    private static final int POST_EXP_MASK = 16;
    private static final int POST_GRAY_ALPHA_EXP = 16;
    private static final int POST_GAMMA_EXP = 17;
    private static final int POST_GRAY_LUT_ADD_TRANS_EXP = 19;
    private static final int POST_ADD_GRAY_TRANS_EXP = 22;
    private Vector streamVec = new Vector();
    private DataInputStream dataStream;
    private int bytesPerPixel;
    private int inputBands;
    private int outputBands;
    private int chunkIndex = 0;
    private Vector textKeys = new Vector();
    private Vector textStrings = new Vector();
    private Vector ztextKeys = new Vector();
    private Vector ztextStrings = new Vector();
    private WritableRaster theTile;
    private Rectangle bounds;
    private Hashtable properties = new Hashtable();
    private int[] gammaLut = null;
    private final byte[][] expandBits = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
    private int[] grayLut = null;
    private static final int[] GrayBits8 = new int[]{8};
    private static final ComponentColorModel colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
    private static final int[] GrayAlphaBits8 = new int[]{8, 8};
    private static final ComponentColorModel colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
    private static final int[] GrayBits16 = new int[]{16};
    private static final ComponentColorModel colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
    private static final int[] GrayAlphaBits16 = new int[]{16, 16};
    private static final ComponentColorModel colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
    private static final int[] GrayBits32 = new int[]{32};
    private static final ComponentColorModel colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
    private static final int[] GrayAlphaBits32 = new int[]{32, 32};
    private static final ComponentColorModel colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
    private static final int[] RGBABits8 = new int[]{8, 8, 8, 8};
    private static final ComponentColorModel colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
    private static final int[] RGBBits16 = new int[]{16, 16, 16};
    private static final ComponentColorModel colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
    private static final int[] RGBABits16 = new int[]{16, 16, 16, 16};
    private static final ComponentColorModel colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
    private static final int[] RGBBits32 = new int[]{32, 32, 32};
    private static final ComponentColorModel colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
    private static final int[] RGBABits32 = new int[]{32, 32, 32, 32};
    private static final ComponentColorModel colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);

    private void initGammaLut(int n) {
        double d = (double)this.userExponent / (double)(this.fileGamma * this.displayExponent);
        int n2 = 1 << n;
        int n3 = n == 16 ? 65535 : 255;
        this.gammaLut = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            double d2 = (double)n4 / (double)(n2 - 1);
            double d3 = Math.pow(d2, d);
            int n5 = (int)(d3 * (double)n3 + 0.5);
            if (n5 > n3) {
                n5 = n3;
            }
            this.gammaLut[n4] = n5;
            ++n4;
        }
    }

    private void initGrayLut(int n) {
        int n2 = 1 << n;
        this.grayLut = new int[n2];
        if (this.performGammaCorrection) {
            int n3 = 0;
            while (n3 < n2) {
                this.grayLut[n3] = this.gammaLut[n3];
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.grayLut[n4] = this.expandBits[n][n4];
                ++n4;
            }
        }
    }

    public PNGRed(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public PNGRed(InputStream inputStream, PNGDecodeParam pNGDecodeParam) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (pNGDecodeParam == null) {
            pNGDecodeParam = new PNGDecodeParam();
        }
        this.decodeParam = pNGDecodeParam;
        this.suppressAlpha = pNGDecodeParam.getSuppressAlpha();
        this.expandPalette = pNGDecodeParam.getExpandPalette();
        this.output8BitGray = pNGDecodeParam.getOutput8BitGray();
        this.expandGrayAlpha = pNGDecodeParam.getExpandGrayAlpha();
        if (pNGDecodeParam.getPerformGammaCorrection()) {
            this.userExponent = pNGDecodeParam.getUserExponent();
            this.displayExponent = pNGDecodeParam.getDisplayExponent();
            this.performGammaCorrection = true;
            this.output8BitGray = true;
        }
        this.generateEncodeParam = pNGDecodeParam.getGenerateEncodeParam();
        if (this.emitProperties) {
            this.properties.put("file_type", "PNG v. 1.0");
        }
        try {
            long l = dataInputStream.readLong();
            if (l != -8552249625308161526L) {
                String string = PropertyUtil.getString("PNGImageDecoder0");
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = PropertyUtil.getString("PNGImageDecoder1");
            throw new RuntimeException(string);
        }
        try {
            while (true) {
                PNGChunk pNGChunk;
                String string;
                if ((string = PNGRed.getChunkType(dataInputStream)).equals("IHDR")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_IHDR_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("PLTE")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_PLTE_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("IDAT")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.streamVec.add(new ByteArrayInputStream(pNGChunk.getData()));
                    continue;
                }
                if (string.equals("IEND")) {
                    PNGChunk pNGChunk2 = PNGRed.readChunk(dataInputStream);
                    this.parse_IEND_chunk(pNGChunk2);
                    break;
                }
                if (string.equals("bKGD")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_bKGD_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("cHRM")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_cHRM_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("gAMA")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_gAMA_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("hIST")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_hIST_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("iCCP")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_iCCP_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("pHYs")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_pHYs_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("sBIT")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_sBIT_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("sRGB")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_sRGB_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tEXt")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_tEXt_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tIME")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_tIME_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tRNS")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_tRNS_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("zTXt")) {
                    pNGChunk = PNGRed.readChunk(dataInputStream);
                    this.parse_zTXt_chunk(pNGChunk);
                    continue;
                }
                pNGChunk = PNGRed.readChunk(dataInputStream);
                String string2 = pNGChunk.getTypeString();
                byte[] byArray = pNGChunk.getData();
                if (this.encodeParam != null) {
                    this.encodeParam.addPrivateChunk(string2, byArray);
                }
                if (!this.emitProperties) continue;
                String string3 = "chunk_" + this.chunkIndex++ + ":" + string2;
                this.properties.put(string3.toLowerCase(), byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = PropertyUtil.getString("PNGImageDecoder2");
            throw new RuntimeException(string);
        }
        if (this.significantBits == null) {
            this.significantBits = new int[this.inputBands];
            int n = 0;
            while (n < this.inputBands) {
                this.significantBits[n] = this.bitDepth;
                ++n;
            }
            if (this.emitProperties) {
                this.properties.put("significant_bits", this.significantBits);
            }
        }
    }

    private static String getChunkType(DataInputStream dataInputStream) {
        try {
            dataInputStream.mark(8);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            dataInputStream.reset();
            String string = new String();
            string = string + (char)(n2 >> 24);
            string = string + (char)(n2 >> 16 & 0xFF);
            string = string + (char)(n2 >> 8 & 0xFF);
            string = string + (char)(n2 & 0xFF);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static PNGChunk readChunk(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            int n3 = dataInputStream.readInt();
            return new PNGChunk(n, n2, byArray, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void parse_IHDR_chunk(PNGChunk pNGChunk) {
        int n = pNGChunk.getInt4(0);
        int n2 = pNGChunk.getInt4(4);
        this.bounds = new Rectangle(0, 0, n, n2);
        this.bitDepth = pNGChunk.getInt1(8);
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            String string = PropertyUtil.getString("PNGImageDecoder3");
            throw new RuntimeException(string);
        }
        this.maxOpacity = (1 << this.bitDepth) - 1;
        this.colorType = pNGChunk.getInt1(9);
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            System.out.println(PropertyUtil.getString("PNGImageDecoder4"));
        }
        if (this.colorType == 2 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder5");
            throw new RuntimeException(string);
        }
        if (this.colorType == 3 && this.bitDepth == 16) {
            String string = PropertyUtil.getString("PNGImageDecoder6");
            throw new RuntimeException(string);
        }
        if (this.colorType == 4 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder7");
            throw new RuntimeException(string);
        }
        if (this.colorType == 6 && this.bitDepth < 8) {
            String string = PropertyUtil.getString("PNGImageDecoder8");
            throw new RuntimeException(string);
        }
        if (this.emitProperties) {
            this.properties.put("color_type", colorTypeNames[this.colorType]);
        }
        if (this.generateEncodeParam) {
            this.encodeParam = this.colorType == 3 ? new PNGEncodeParam.Palette() : (this.colorType == 0 || this.colorType == 4 ? new PNGEncodeParam.Gray() : new PNGEncodeParam.RGB());
            this.decodeParam.setEncodeParam(this.encodeParam);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setBitDepth(this.bitDepth);
        }
        if (this.emitProperties) {
            this.properties.put("bit_depth", new Integer(this.bitDepth));
        }
        if (this.performGammaCorrection) {
            float f = 0.45454544f * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f));
            }
        }
        this.compressionMethod = pNGChunk.getInt1(10);
        if (this.compressionMethod != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder9");
            throw new RuntimeException(string);
        }
        this.filterMethod = pNGChunk.getInt1(11);
        if (this.filterMethod != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder10");
            throw new RuntimeException(string);
        }
        this.interlaceMethod = pNGChunk.getInt1(12);
        if (this.interlaceMethod == 0) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(false);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "None");
            }
        } else if (this.interlaceMethod == 1) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(true);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "Adam7");
            }
        } else {
            String string = PropertyUtil.getString("PNGImageDecoder11");
            throw new RuntimeException(string);
        }
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                this.inputBands = 1;
                this.outputBands = 1;
                if (this.output8BitGray && this.bitDepth < 8) {
                    this.postProcess = 2;
                    break;
                }
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 2: {
                this.inputBands = 3;
                this.bytesPerPixel *= 3;
                this.outputBands = 3;
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 3: {
                this.inputBands = 1;
                this.bytesPerPixel = 1;
                int n3 = this.outputBands = this.expandPalette ? 3 : 1;
                if (this.expandPalette) {
                    this.postProcess = 4;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 4: {
                this.inputBands = 2;
                this.bytesPerPixel *= 2;
                if (this.suppressAlpha) {
                    this.outputBands = 1;
                    this.postProcess = 8;
                    break;
                }
                this.postProcess = this.performGammaCorrection ? 1 : 0;
                if (this.expandGrayAlpha) {
                    this.postProcess |= 0x10;
                    this.outputBands = 4;
                    break;
                }
                this.outputBands = 2;
                break;
            }
            case 6: {
                this.inputBands = 4;
                this.bytesPerPixel *= 4;
                int n4 = this.outputBands = !this.suppressAlpha ? 4 : 3;
                this.postProcess = this.suppressAlpha ? 9 : (this.performGammaCorrection ? 1 : 0);
            }
        }
    }

    private void parse_IEND_chunk(PNGChunk pNGChunk) throws Exception {
        ColorModel colorModel;
        Object object;
        Object object2;
        String[] stringArray;
        int n = this.textKeys.size();
        String[] stringArray2 = new String[2 * n];
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.textKeys.elementAt(n2);
            stringArray = (String)this.textStrings.elementAt(n2);
            stringArray2[2 * n2] = string;
            stringArray2[2 * n2 + 1] = stringArray;
            if (this.emitProperties) {
                String string2 = "text_" + n2 + ":" + string;
                this.properties.put(string2.toLowerCase(), stringArray);
            }
            ++n2;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setText(stringArray2);
        }
        int n3 = this.ztextKeys.size();
        stringArray = new String[2 * n3];
        int n4 = 0;
        while (n4 < n3) {
            object2 = (String)this.ztextKeys.elementAt(n4);
            object = (String)this.ztextStrings.elementAt(n4);
            stringArray[2 * n4] = object2;
            stringArray[2 * n4 + 1] = object;
            if (this.emitProperties) {
                String string = "ztext_" + n4 + ":" + (String)object2;
                this.properties.put(string.toLowerCase(), object);
            }
            ++n4;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setCompressedText(stringArray);
        }
        object2 = new SequenceInputStream(this.streamVec.elements());
        object = new InflaterInputStream((InputStream)object2, new Inflater());
        this.dataStream = new DataInputStream((InputStream)object);
        int n5 = this.bitDepth;
        if (this.colorType == 0 && this.bitDepth < 8 && this.output8BitGray) {
            n5 = 8;
        }
        if (this.colorType == 3 && this.expandPalette) {
            n5 = 8;
        }
        int n6 = this.bounds.width;
        int n7 = this.bounds.height;
        int n8 = (this.outputBands * n6 * n5 + 7) / 8;
        int n9 = n5 == 16 ? n8 / 2 : n8;
        this.theTile = this.createRaster(n6, n7, this.outputBands, n9, n5);
        if (this.performGammaCorrection && this.gammaLut == null) {
            this.initGammaLut(this.bitDepth);
        }
        if (this.postProcess == 2 || this.postProcess == 3 || this.postProcess == 19) {
            this.initGrayLut(this.bitDepth);
        }
        this.decodeImage(this.interlaceMethod == 1);
        SampleModel sampleModel = this.theTile.getSampleModel();
        if (this.colorType == 3 && !this.expandPalette) {
            colorModel = this.outputHasAlphaPalette ? new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette) : new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette);
        } else if (this.colorType == 0 && this.bitDepth < 8 && !this.output8BitGray) {
            byte[] byArray = this.expandBits[this.bitDepth];
            colorModel = new IndexColorModel(this.bitDepth, byArray.length, byArray, byArray, byArray);
        } else {
            colorModel = PNGRed.createComponentColorModel(sampleModel);
        }
        this.init((CachableRed)null, this.bounds, colorModel, sampleModel, 0, 0, (Map)this.properties);
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n == 0) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray8;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha8;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB8;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA8;
                }
            }
        } else if (n == 1) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray16;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha16;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB16;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA16;
                }
            }
        } else if (n == 3) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray32;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha32;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB32;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA32;
                }
            }
        }
        return componentColorModel;
    }

    private void parse_PLTE_chunk(PNGChunk pNGChunk) {
        this.paletteEntries = pNGChunk.getLength() / 3;
        this.redPalette = new byte[this.paletteEntries];
        this.greenPalette = new byte[this.paletteEntries];
        this.bluePalette = new byte[this.paletteEntries];
        int n = 0;
        if (this.performGammaCorrection) {
            if (this.gammaLut == null) {
                this.initGammaLut(this.bitDepth == 16 ? 16 : 8);
            }
            int n2 = 0;
            while (n2 < this.paletteEntries) {
                byte by = pNGChunk.getByte(n++);
                byte by2 = pNGChunk.getByte(n++);
                byte by3 = pNGChunk.getByte(n++);
                this.redPalette[n2] = (byte)this.gammaLut[by & 0xFF];
                this.greenPalette[n2] = (byte)this.gammaLut[by2 & 0xFF];
                this.bluePalette[n2] = (byte)this.gammaLut[by3 & 0xFF];
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.paletteEntries) {
                this.redPalette[n3] = pNGChunk.getByte(n++);
                this.greenPalette[n3] = pNGChunk.getByte(n++);
                this.bluePalette[n3] = pNGChunk.getByte(n++);
                ++n3;
            }
        }
    }

    private void parse_bKGD_chunk(PNGChunk pNGChunk) {
        this.hasBackground = true;
        switch (this.colorType) {
            case 3: {
                int n = pNGChunk.getByte(0) & 0xFF;
                this.bkgdRed = this.redPalette[n] & 0xFF;
                this.bkgdGreen = this.greenPalette[n] & 0xFF;
                this.bkgdBlue = this.bluePalette[n] & 0xFF;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Palette)this.encodeParam).setBackgroundPaletteIndex(n);
                break;
            }
            case 0: 
            case 4: {
                int n;
                this.bkgdGreen = this.bkgdBlue = (n = pNGChunk.getInt2(0));
                this.bkgdRed = this.bkgdBlue;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Gray)this.encodeParam).setBackgroundGray(n);
                break;
            }
            case 2: 
            case 6: {
                this.bkgdRed = pNGChunk.getInt2(0);
                this.bkgdGreen = pNGChunk.getInt2(2);
                this.bkgdBlue = pNGChunk.getInt2(4);
                int[] nArray = new int[]{this.bkgdRed, this.bkgdGreen, this.bkgdBlue};
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.RGB)this.encodeParam).setBackgroundRGB(nArray);
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.colorType == 3 || this.bitDepth == 8) {
            n = this.bkgdRed;
            n2 = this.bkgdGreen;
            n3 = this.bkgdBlue;
        } else if (this.bitDepth < 8) {
            n = this.expandBits[this.bitDepth][this.bkgdRed];
            n2 = this.expandBits[this.bitDepth][this.bkgdGreen];
            n3 = this.expandBits[this.bitDepth][this.bkgdBlue];
        } else if (this.bitDepth == 16) {
            n = this.bkgdRed >> 8;
            n2 = this.bkgdGreen >> 8;
            n3 = this.bkgdBlue >> 8;
        }
        if (this.emitProperties) {
            this.properties.put("background_color", new Color(n, n2, n3));
        }
    }

    private void parse_cHRM_chunk(PNGChunk pNGChunk) {
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.chromaticity = new float[8];
        this.chromaticity[0] = (float)pNGChunk.getInt4(0) / 100000.0f;
        this.chromaticity[1] = (float)pNGChunk.getInt4(4) / 100000.0f;
        this.chromaticity[2] = (float)pNGChunk.getInt4(8) / 100000.0f;
        this.chromaticity[3] = (float)pNGChunk.getInt4(12) / 100000.0f;
        this.chromaticity[4] = (float)pNGChunk.getInt4(16) / 100000.0f;
        this.chromaticity[5] = (float)pNGChunk.getInt4(20) / 100000.0f;
        this.chromaticity[6] = (float)pNGChunk.getInt4(24) / 100000.0f;
        this.chromaticity[7] = (float)pNGChunk.getInt4(28) / 100000.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setChromaticity(this.chromaticity);
        }
        if (this.emitProperties) {
            this.properties.put("white_point_x", new Float(this.chromaticity[0]));
            this.properties.put("white_point_y", new Float(this.chromaticity[1]));
            this.properties.put("red_x", new Float(this.chromaticity[2]));
            this.properties.put("red_y", new Float(this.chromaticity[3]));
            this.properties.put("green_x", new Float(this.chromaticity[4]));
            this.properties.put("green_y", new Float(this.chromaticity[5]));
            this.properties.put("blue_x", new Float(this.chromaticity[6]));
            this.properties.put("blue_y", new Float(this.chromaticity[7]));
        }
    }

    private void parse_gAMA_chunk(PNGChunk pNGChunk) {
        float f;
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.fileGamma = (float)pNGChunk.getInt4(0) / 100000.0f;
        float f2 = f = this.performGammaCorrection ? this.displayExponent / this.userExponent : 1.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setGamma(this.fileGamma * f);
        }
        if (this.emitProperties) {
            this.properties.put("gamma", new Float(this.fileGamma * f));
        }
    }

    private void parse_hIST_chunk(PNGChunk pNGChunk) {
        if (this.redPalette == null) {
            String string = PropertyUtil.getString("PNGImageDecoder18");
            throw new RuntimeException(string);
        }
        int n = this.redPalette.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = pNGChunk.getInt2(2 * n2);
            ++n2;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setPaletteHistogram(nArray);
        }
    }

    private void parse_iCCP_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        int n = 0;
        while ((by = pNGChunk.getByte(n++)) != 0) {
            string = string + (char)by;
        }
    }

    private void parse_pHYs_chunk(PNGChunk pNGChunk) {
        int n = pNGChunk.getInt4(0);
        int n2 = pNGChunk.getInt4(4);
        int n3 = pNGChunk.getInt1(8);
        if (this.encodeParam != null) {
            this.encodeParam.setPhysicalDimension(n, n2, n3);
        }
        if (this.emitProperties) {
            this.properties.put("x_pixels_per_unit", new Integer(n));
            this.properties.put("y_pixels_per_unit", new Integer(n2));
            this.properties.put("pixel_aspect_ratio", new Float((float)n / (float)n2));
            if (n3 == 1) {
                this.properties.put("pixel_units", "Meters");
            } else if (n3 != 0) {
                String string = PropertyUtil.getString("PNGImageDecoder12");
                throw new RuntimeException(string);
            }
        }
    }

    private void parse_sBIT_chunk(PNGChunk pNGChunk) {
        this.significantBits = this.colorType == 3 ? new int[3] : new int[this.inputBands];
        int n = 0;
        while (n < this.significantBits.length) {
            int n2;
            int n3 = pNGChunk.getByte(n);
            int n4 = n2 = this.colorType == 3 ? 8 : this.bitDepth;
            if (n3 <= 0 || n3 > n2) {
                String string = PropertyUtil.getString("PNGImageDecoder13");
                throw new RuntimeException(string);
            }
            this.significantBits[n] = n3;
            ++n;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setSignificantBits(this.significantBits);
        }
        if (this.emitProperties) {
            this.properties.put("significant_bits", this.significantBits);
        }
    }

    private void parse_sRGB_chunk(PNGChunk pNGChunk) {
        this.sRGBRenderingIntent = pNGChunk.getByte(0);
        this.fileGamma = 0.45455f;
        this.chromaticity = new float[8];
        this.chromaticity[0] = 3.127f;
        this.chromaticity[1] = 3.29f;
        this.chromaticity[2] = 6.4f;
        this.chromaticity[3] = 3.3f;
        this.chromaticity[4] = 3.0f;
        this.chromaticity[5] = 6.0f;
        this.chromaticity[6] = 1.5f;
        this.chromaticity[7] = 0.6f;
        if (this.performGammaCorrection) {
            float f = this.fileGamma * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f);
                this.encodeParam.setChromaticity(this.chromaticity);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f));
                this.properties.put("white_point_x", new Float(this.chromaticity[0]));
                this.properties.put("white_point_y", new Float(this.chromaticity[1]));
                this.properties.put("red_x", new Float(this.chromaticity[2]));
                this.properties.put("red_y", new Float(this.chromaticity[3]));
                this.properties.put("green_x", new Float(this.chromaticity[4]));
                this.properties.put("green_y", new Float(this.chromaticity[5]));
                this.properties.put("blue_x", new Float(this.chromaticity[6]));
                this.properties.put("blue_y", new Float(this.chromaticity[7]));
            }
        }
    }

    private void parse_tEXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n = 0;
        while ((by = pNGChunk.getByte(n++)) != 0) {
            string = string + (char)by;
        }
        int n2 = n;
        while (n2 < pNGChunk.getLength()) {
            string2 = string2 + (char)pNGChunk.getByte(n2);
            ++n2;
        }
        this.textKeys.add(string);
        this.textStrings.add(string2);
    }

    private void parse_tIME_chunk(PNGChunk pNGChunk) {
        int n = pNGChunk.getInt2(0);
        int n2 = pNGChunk.getInt1(2) - 1;
        int n3 = pNGChunk.getInt1(3);
        int n4 = pNGChunk.getInt1(4);
        int n5 = pNGChunk.getInt1(5);
        int n6 = pNGChunk.getInt1(6);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        Date date = gregorianCalendar.getTime();
        if (this.encodeParam != null) {
            this.encodeParam.setModificationTime(date);
        }
        if (this.emitProperties) {
            this.properties.put("timestamp", date);
        }
    }

    private void parse_tRNS_chunk(PNGChunk pNGChunk) {
        if (this.colorType == 3) {
            int n = pNGChunk.getLength();
            if (n > this.paletteEntries) {
                String string = PropertyUtil.getString("PNGImageDecoder14");
                throw new RuntimeException(string);
            }
            this.alphaPalette = new byte[this.paletteEntries];
            int n2 = 0;
            while (n2 < n) {
                this.alphaPalette[n2] = pNGChunk.getByte(n2);
                ++n2;
            }
            int n3 = n;
            while (n3 < this.paletteEntries) {
                this.alphaPalette[n3] = -1;
                ++n3;
            }
            if (!this.suppressAlpha) {
                if (this.expandPalette) {
                    this.postProcess = 5;
                    this.outputBands = 4;
                } else {
                    this.outputHasAlphaPalette = true;
                }
            }
        } else if (this.colorType == 0) {
            this.grayTransparentAlpha = pNGChunk.getInt2(0);
            if (!this.suppressAlpha) {
                if (this.bitDepth < 8) {
                    this.output8BitGray = true;
                    this.maxOpacity = 255;
                    this.postProcess = 3;
                } else {
                    this.postProcess = 6;
                }
                if (this.expandGrayAlpha) {
                    this.outputBands = 4;
                    this.postProcess |= 0x10;
                } else {
                    this.outputBands = 2;
                }
                if (this.encodeParam != null) {
                    ((PNGEncodeParam.Gray)this.encodeParam).setTransparentGray(this.grayTransparentAlpha);
                }
            }
        } else if (this.colorType == 2) {
            this.redTransparentAlpha = pNGChunk.getInt2(0);
            this.greenTransparentAlpha = pNGChunk.getInt2(2);
            this.blueTransparentAlpha = pNGChunk.getInt2(4);
            if (!this.suppressAlpha) {
                this.outputBands = 4;
                this.postProcess = 7;
                if (this.encodeParam != null) {
                    int[] nArray = new int[]{this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha};
                    ((PNGEncodeParam.RGB)this.encodeParam).setTransparentRGB(nArray);
                }
            }
        } else if (this.colorType == 4 || this.colorType == 6) {
            String string = PropertyUtil.getString("PNGImageDecoder15");
            throw new RuntimeException(string);
        }
    }

    private void parse_zTXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n = 0;
        while ((by = pNGChunk.getByte(n++)) != 0) {
            string = string + (char)by;
        }
        byte by2 = pNGChunk.getByte(n++);
        try {
            int n2;
            int n3 = pNGChunk.getLength() - n;
            byte[] byArray = pNGChunk.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n3);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            while ((n2 = ((InputStream)inflaterInputStream).read()) != -1) {
                string2 = string2 + (char)n2;
            }
            this.ztextKeys.add(string);
            this.ztextStrings.add(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private WritableRaster createRaster(int n, int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n5 < 8 && n3 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n5, point);
        } else if (n5 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n4, n3, this.bandOffsets[n3], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n, n2, n4, n3, this.bandOffsets[n3], point);
        }
        return writableRaster;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2) {
        int n3 = n2;
        while (n3 < n) {
            int n4 = byArray[n3] & 0xFF;
            byArray[n3] = (byte)(n4 += byArray[n3 - n2] & 0xFF);
            ++n3;
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray2[n2] & 0xFF;
            byArray[n2] = (byte)(n3 + n4);
            ++n2;
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < n2) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3 / 2);
            ++n5;
        }
        int n6 = n2;
        while (n6 < n) {
            n4 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n2] & 0xFF;
            n3 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n4 + (n7 + n3) / 2);
            ++n6;
        }
    }

    private static int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < n2) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3);
            ++n5;
        }
        int n6 = n2;
        while (n6 < n) {
            n4 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n2] & 0xFF;
            n3 = byArray2[n6] & 0xFF;
            int n8 = byArray2[n6 - n2] & 0xFF;
            byArray[n6] = (byte)(n4 + PNGRed.paethPredictor(n7, n3, n8));
            ++n6;
        }
    }

    private void processPixels(int n, Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5) {
        int[] nArray = raster.getPixel(0, 0, (int[])null);
        int[] nArray2 = writableRaster.getPixel(0, 0, (int[])null);
        int n6 = n2;
        switch (n) {
            case 0: {
                int n7 = 0;
                while (n7 < n5) {
                    raster.getPixel(n7, 0, nArray);
                    writableRaster.setPixel(n6, n4, nArray);
                    n6 += n3;
                    ++n7;
                }
                break;
            }
            case 1: {
                int n8 = 0;
                while (n8 < n5) {
                    raster.getPixel(n8, 0, nArray);
                    int n9 = 0;
                    while (n9 < this.inputBands) {
                        int n10 = nArray[n9];
                        nArray[n9] = this.gammaLut[n10];
                        ++n9;
                    }
                    writableRaster.setPixel(n6, n4, nArray);
                    n6 += n3;
                    ++n8;
                }
                break;
            }
            case 2: {
                int n11 = 0;
                while (n11 < n5) {
                    raster.getPixel(n11, 0, nArray);
                    nArray2[0] = this.grayLut[nArray[0]];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n11;
                }
                break;
            }
            case 3: {
                int n12 = 0;
                while (n12 < n5) {
                    raster.getPixel(n12, 0, nArray);
                    int n13 = nArray[0];
                    nArray2[0] = this.grayLut[n13];
                    nArray2[1] = n13 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n12;
                }
                break;
            }
            case 4: {
                int n14 = 0;
                while (n14 < n5) {
                    raster.getPixel(n14, 0, nArray);
                    int n15 = nArray[0];
                    nArray2[0] = this.redPalette[n15];
                    nArray2[1] = this.greenPalette[n15];
                    nArray2[2] = this.bluePalette[n15];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n14;
                }
                break;
            }
            case 5: {
                int n16 = 0;
                while (n16 < n5) {
                    raster.getPixel(n16, 0, nArray);
                    int n17 = nArray[0];
                    nArray2[0] = this.redPalette[n17];
                    nArray2[1] = this.greenPalette[n17];
                    nArray2[2] = this.bluePalette[n17];
                    nArray2[3] = this.alphaPalette[n17];
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n16;
                }
                break;
            }
            case 6: {
                int n18 = 0;
                while (n18 < n5) {
                    raster.getPixel(n18, 0, nArray);
                    int n19 = nArray[0];
                    if (this.performGammaCorrection) {
                        n19 = this.gammaLut[n19];
                    }
                    nArray2[0] = n19;
                    nArray2[1] = n19 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n18;
                }
                break;
            }
            case 7: {
                int n20 = 0;
                while (n20 < n5) {
                    raster.getPixel(n20, 0, nArray);
                    int n21 = nArray[0];
                    int n22 = nArray[1];
                    int n23 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n21];
                        nArray2[1] = this.gammaLut[n22];
                        nArray2[2] = this.gammaLut[n23];
                    } else {
                        nArray2[0] = n21;
                        nArray2[1] = n22;
                        nArray2[2] = n23;
                    }
                    nArray2[3] = n21 == this.redTransparentAlpha && n22 == this.greenTransparentAlpha && n23 == this.blueTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n20;
                }
                break;
            }
            case 8: {
                int n24 = 0;
                while (n24 < n5) {
                    raster.getPixel(n24, 0, nArray);
                    int n25 = nArray[0];
                    nArray2[0] = this.performGammaCorrection ? this.gammaLut[n25] : n25;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n24;
                }
                break;
            }
            case 9: {
                int n26 = 0;
                while (n26 < n5) {
                    raster.getPixel(n26, 0, nArray);
                    int n27 = nArray[0];
                    int n28 = nArray[1];
                    int n29 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n27];
                        nArray2[1] = this.gammaLut[n28];
                        nArray2[2] = this.gammaLut[n29];
                    } else {
                        nArray2[0] = n27;
                        nArray2[1] = n28;
                        nArray2[2] = n29;
                    }
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n26;
                }
                break;
            }
            case 17: {
                int n30 = 0;
                while (n30 < n5) {
                    int n31;
                    raster.getPixel(n30, 0, nArray);
                    int n32 = nArray[0];
                    int n33 = nArray[1];
                    nArray2[0] = n31 = this.gammaLut[n32];
                    nArray2[1] = n31;
                    nArray2[2] = n31;
                    nArray2[3] = n33;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n30;
                }
                break;
            }
            case 16: {
                int n34 = 0;
                while (n34 < n5) {
                    raster.getPixel(n34, 0, nArray);
                    int n35 = nArray[0];
                    int n36 = nArray[1];
                    nArray2[0] = n35;
                    nArray2[1] = n35;
                    nArray2[2] = n35;
                    nArray2[3] = n36;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n34;
                }
                break;
            }
            case 22: {
                int n37 = 0;
                while (n37 < n5) {
                    raster.getPixel(n37, 0, nArray);
                    int n38 = nArray[0];
                    if (this.performGammaCorrection) {
                        n38 = this.gammaLut[n38];
                    }
                    nArray2[0] = n38;
                    nArray2[1] = n38;
                    nArray2[2] = n38;
                    nArray2[3] = n38 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n37;
                }
                break;
            }
            case 19: {
                int n39 = 0;
                while (n39 < n5) {
                    int n40;
                    raster.getPixel(n39, 0, nArray);
                    int n41 = nArray[0];
                    nArray2[0] = n40 = this.grayLut[n41];
                    nArray2[1] = n40;
                    nArray2[2] = n40;
                    nArray2[3] = n41 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n6, n4, nArray2);
                    n6 += n3;
                    ++n39;
                }
                break;
            }
        }
    }

    private void decodePass(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int n7 = (this.inputBands * n5 * this.bitDepth + 7) / 8;
        int n8 = this.bitDepth == 16 ? n7 / 2 : n7;
        byte[] byArray = new byte[n7];
        byte[] byArray2 = new byte[n7];
        WritableRaster writableRaster2 = this.createRaster(n5, 1, this.inputBands, n8, this.bitDepth);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n9 = dataBuffer.getDataType();
        byte[] byArray3 = null;
        short[] sArray = null;
        if (n9 == 0) {
            byArray3 = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        int n10 = 0;
        int n11 = n2;
        while (n10 < n6) {
            int n12 = 0;
            try {
                n12 = this.dataStream.read();
                this.dataStream.readFully(byArray, 0, n7);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            switch (n12) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGRed.decodeSubFilter(byArray, n7, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PNGRed.decodeUpFilter(byArray, byArray2, n7);
                    break;
                }
                case 3: {
                    PNGRed.decodeAverageFilter(byArray, byArray2, n7, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PNGRed.decodePaethFilter(byArray, byArray2, n7, this.bytesPerPixel);
                    break;
                }
                default: {
                    String string = PropertyUtil.getString("PNGImageDecoder16");
                    throw new RuntimeException(string);
                }
            }
            if (this.bitDepth < 16) {
                System.arraycopy(byArray, 0, byArray3, 0, n7);
            } else {
                int n13 = 0;
                int n14 = 0;
                while (n14 < n8) {
                    sArray[n14] = (short)(byArray[n13] << 8 | byArray[n13 + 1] & 0xFF);
                    n13 += 2;
                    ++n14;
                }
            }
            this.processPixels(this.postProcess, writableRaster2, writableRaster, n, n3, n11, n5);
            byte[] byArray4 = byArray2;
            byArray2 = byArray;
            byArray = byArray4;
            ++n10;
            n11 += n4;
        }
    }

    private void decodeImage(boolean bl) {
        int n = this.bounds.width;
        int n2 = this.bounds.height;
        if (!bl) {
            this.decodePass(this.theTile, 0, 0, 1, 1, n, n2);
        } else {
            this.decodePass(this.theTile, 0, 0, 8, 8, (n + 7) / 8, (n2 + 7) / 8);
            this.decodePass(this.theTile, 4, 0, 8, 8, (n + 3) / 8, (n2 + 7) / 8);
            this.decodePass(this.theTile, 0, 4, 4, 8, (n + 3) / 4, (n2 + 3) / 8);
            this.decodePass(this.theTile, 2, 0, 4, 4, (n + 1) / 4, (n2 + 3) / 4);
            this.decodePass(this.theTile, 0, 2, 2, 4, (n + 1) / 2, (n2 + 1) / 4);
            this.decodePass(this.theTile, 1, 0, 2, 2, n / 2, (n2 + 1) / 2);
            this.decodePass(this.theTile, 0, 1, 1, 2, n, n2 / 2);
        }
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        GraphicsUtil.copyData(this.theTile, writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            String string = PropertyUtil.getString("PNGImageDecoder17");
            throw new IllegalArgumentException(string);
        }
        return this.theTile;
    }

    static class PNGChunk {
        int length;
        int type;
        byte[] data;
        int crc;
        String typeString;

        public PNGChunk(int n, int n2, byte[] byArray, int n3) {
            this.length = n;
            this.type = n2;
            this.data = byArray;
            this.crc = n3;
            this.typeString = new String();
            this.typeString = this.typeString + (char)(n2 >> 24);
            this.typeString = this.typeString + (char)(n2 >> 16 & 0xFF);
            this.typeString = this.typeString + (char)(n2 >> 8 & 0xFF);
            this.typeString = this.typeString + (char)(n2 & 0xFF);
        }

        public int getLength() {
            return this.length;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeString() {
            return this.typeString;
        }

        public byte[] getData() {
            return this.data;
        }

        public byte getByte(int n) {
            return this.data[n];
        }

        public int getInt1(int n) {
            return this.data[n] & 0xFF;
        }

        public int getInt2(int n) {
            return (this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF;
        }

        public int getInt4(int n) {
            return (this.data[n] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF;
        }

        public String getString4(int n) {
            String string = new String();
            string = string + (char)this.data[n];
            string = string + (char)this.data[n + 1];
            string = string + (char)this.data[n + 2];
            string = string + (char)this.data[n + 3];
            return string;
        }

        public boolean isType(String string) {
            return this.typeString.equals(string);
        }
    }
}

