/*
 * Decompiled with CFR 0.152.
 */
package trier.activitydiagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import trier.TrierPlugin;
import trier.activitydiagram.model.ADDocument;
import trier.diagrameditor.EConnectionCreationFactory;
import trier.diagrameditor.ENodeCreationFactory;
import trier.diagrameditor.EPaletteFactory;
import trier.diagrameditor.model.EEditDomain;

public class ADPaletteFactory
extends EPaletteFactory {
    private EEditDomain domain = null;

    public static PaletteRoot createPaletteRoot(EEditDomain domain) {
        ADPaletteFactory instance = new ADPaletteFactory(domain);
        return instance.createPalette();
    }

    protected ADPaletteFactory(EEditDomain domain) {
        super(domain);
    }

    protected List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(this.createControlCategory(root));
        categories.add(this.createNodeCategory());
        categories.add(this.createConnectionCategory());
        categories.add(this.createNoteCategory());
        return categories;
    }

    protected PaletteContainer createControlCategory(PaletteRoot root) {
        PaletteGroup category = new PaletteGroup("Control");
        ArrayList<SelectionToolEntry> entries = new ArrayList<SelectionToolEntry>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        category.addAll(entries);
        return category;
    }

    protected PaletteContainer createNodeCategory() {
        PaletteDrawer category = new PaletteDrawer("State");
        ArrayList<CreationToolEntry> entries = new ArrayList<CreationToolEntry>();
        CreationToolEntry activityCreationTool = new CreationToolEntry("ActivityState", "create activity state", (CreationFactory)new ENodeCreationFactory(ADDocument.ACTIVITY, this.getEDocument()), TrierPlugin.getDefault().getBannerImg("state/actionstate16.gif"), TrierPlugin.getDefault().getBannerImg("state/actionstate16.gif"));
        entries.add(activityCreationTool);
        CreationToolEntry decisionCreationTool = new CreationToolEntry("Decision", "create decision", (CreationFactory)new ENodeCreationFactory(ADDocument.DECISION, this.getEDocument()), TrierPlugin.getDefault().getBannerImg("state/decision16.gif"), TrierPlugin.getDefault().getBannerImg("state/decision16.gif"));
        entries.add(decisionCreationTool);
        CreationToolEntry initialStateCreationTool = new CreationToolEntry("InitialState", "create initial state", (CreationFactory)new ENodeCreationFactory(ADDocument.INITIAL_STATE, this.getEDocument()), TrierPlugin.getDefault().getBannerImg("state/initialstate16.gif"), TrierPlugin.getDefault().getBannerImg("state/initialstate16.gif"));
        entries.add(initialStateCreationTool);
        CreationToolEntry finalStateCreationTool = new CreationToolEntry("FinalState", "create final state", (CreationFactory)new ENodeCreationFactory(ADDocument.FINAL_STATE, this.getEDocument()), TrierPlugin.getDefault().getBannerImg("state/terminalstate16.gif"), TrierPlugin.getDefault().getBannerImg("state/terminalstate16.gif"));
        entries.add(finalStateCreationTool);
        category.addAll(entries);
        return category;
    }

    protected PaletteContainer createConnectionCategory() {
        PaletteDrawer category = new PaletteDrawer("Transition");
        ArrayList<ConnectionCreationToolEntry> entries = new ArrayList<ConnectionCreationToolEntry>();
        ConnectionCreationToolEntry transitionCreationTool = new ConnectionCreationToolEntry("Transition", "relate transition", (CreationFactory)new EConnectionCreationFactory(ADDocument.TRANSITION, this.getEDocument()), TrierPlugin.getDefault().getBannerImg("state/transition16.gif"), TrierPlugin.getDefault().getBannerImg("state/transition16.gif"));
        entries.add(transitionCreationTool);
        category.addAll(entries);
        return category;
    }
}

