/*
 * Decompiled with CFR 0.152.
 */
package trier.activitydiagram.edit.property;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import trier.activitydiagram.ADConstants;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.state.TGuardCondition;
import trier.model.state.TTransition;
import trier.model.state.TTransitionLabel;

public class ADTransitionEditDialog
extends EEditDialog {
    private Text guardText;

    public ADTransitionEditDialog(EEditDomain domain, EElement element) {
        super(domain, element);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Transition Specification");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.initializeGuardConditionComposite(composite);
        composite.pack();
        return composite;
    }

    private void initializeGuardConditionComposite(Composite composite) {
        Label guardLabel = new Label(composite, 0);
        guardLabel.setText("Guard Condition:");
        this.guardText = new Text(composite, 2048);
        if (!this.getTGuardCondition().isNull()) {
            this.guardText.setText(this.getTGuardCondition().getName());
        }
        this.guardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ADTransitionEditDialog.this.guardChanged(e);
            }
        });
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        this.guardText.setLayoutData((Object)gridData);
    }

    protected void guardChanged(ModifyEvent e) {
        if (this.guardText.getText().length() == 0) {
            CompoundCommand removeCommand = new CompoundCommand();
            removeCommand.add(super.getEEditDomain().createRemoveEElementCommand(this.getETransitionLabel()));
            removeCommand.add((Command)new ECommand(super.getTCommandFactory().createRemoveTElementCommand(this.getTGuardCondition())));
            super.executeCommand((Command)removeCommand);
        } else {
            CompoundCommand setGuardCommand = new CompoundCommand();
            if (this.getETransitionLabel() == null) {
                TTransitionLabel transitionLabel = super.getTDocument().createTransitionLabel();
                DLabel label = super.getDDocument().createLabel(transitionLabel.getId(), (DConnection)this.getEModel().getDModel());
                EElement element = new EElement(transitionLabel, (DElement)label);
                setGuardCommand.add((Command)new ECommand(super.getTCommandFactory().createSetTransitionLabelCommand(this.getTTransition(), transitionLabel)));
                TGuardCondition guard = this.getTDocument().createGuardCondition(this.guardText.getText());
                setGuardCommand.add((Command)new ECommand(this.getTCommandFactory().createSetGuardCommand(this.getTTransition(), guard)));
                setGuardCommand.add(super.getDCommandFactory().createSetLocationCommand(label, ADConstants.LABEL_RELATIVE_POINT));
                setGuardCommand.add(super.getEEditDomain().createAddEElementCommand(element));
            } else {
                setGuardCommand.add((Command)new ECommand(this.getTCommandFactory().createSetNameCommand(this.getTGuardCondition(), this.guardText.getText())));
            }
            super.executeCommand((Command)setGuardCommand);
        }
    }

    private TTransition getTTransition() {
        return (TTransition)this.getTModel();
    }

    private TGuardCondition getTGuardCondition() {
        return this.getTTransition().getGuardCondition();
    }

    private TTransitionLabel getTTransitionLabel() {
        return this.getTTransition().getLabel();
    }

    private EElement getETransitionLabel() {
        List eElements = super.getEDocument().getElementsByTElement(this.getTTransitionLabel());
        if (eElements.isEmpty()) {
            return null;
        }
        return (EElement)eElements.get(0);
    }
}

