/*
 * Decompiled with CFR 0.152.
 */
package trier.activitydiagram.model;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.model.EElement;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TModelElement;
import trier.model.core.TPackage;
import trier.model.state.TActivityState;
import trier.model.state.TDecision;
import trier.model.state.TFinalState;
import trier.model.state.TInitialState;
import trier.model.state.TRootStateMachine;
import trier.model.state.TTransition;

public class ADDocument
extends CDDocument {
    public static String ACTIVITY = "ActivityState";
    public static String TRANSITION = "Transition";
    public static String INITIAL_STATE = "InitialState";
    public static String FINAL_STATE = "FinalState";
    public static String GUARD = "Guard";
    public static String DECISION = "Decision";
    private static String DEFAULT_ACTIVITY_STATE_NAME = "NewActivity";
    private TRootStateMachine stateMachine;

    public ADDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
    }

    public EElement createNodeElement(String nodeType) {
        if (nodeType.equals(ACTIVITY)) {
            return this.createActivityState(DEFAULT_ACTIVITY_STATE_NAME);
        }
        if (nodeType.equals(INITIAL_STATE)) {
            return this.createInitialState();
        }
        if (nodeType.equals(FINAL_STATE)) {
            return this.createFinalState();
        }
        if (nodeType.equals(DECISION)) {
            return this.createDecision();
        }
        return super.createNodeElement(nodeType);
    }

    public EElement createConnectionEElement(String connectionType, DNode source, DNode target) {
        if (connectionType.equals(TRANSITION)) {
            return this.createTransition(source, target);
        }
        if (connectionType.equals("Anchor")) {
            return this.createAnchor(source, target);
        }
        return super.createConnectionEElement(connectionType, source, target);
    }

    protected EElement createTransition(DNode source, DNode target) {
        TTransition model = this.getTDocument().createTransition();
        DConnection connection = this.getDDocument().createConnection(model.getId(), source, target);
        return new EElement(model, (DElement)connection);
    }

    protected EElement createActivityState(String name) {
        TActivityState tElement = this.getTDocument().createActivityState(name);
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    protected EElement createDecision() {
        TDecision tElement = this.getTDocument().createDecision();
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    protected EElement createFinalState() {
        TFinalState tElement = this.getTDocument().createFinalState();
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    protected EElement createInitialState() {
        TInitialState tElement = this.getTDocument().createInitialState();
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    public void prepareStateMachine() {
        TPackage namespace = this.getPackage();
        String id = this.getDDocument().getId();
        TModelElement diagramModel = this.getTDocument().getTElement(id);
        if (diagramModel != null && diagramModel instanceof TRootStateMachine) {
            this.stateMachine = (TRootStateMachine)diagramModel;
        } else {
            this.stateMachine = this.getTDocument().createRootStateMachine();
            this.getTDocument().addOwnedElement(namespace, this.stateMachine);
            this.getDDocument().setId(this.stateMachine.getId());
        }
    }

    public TElement getDiagramOwner() {
        return this.stateMachine;
    }

    protected TDocument createInitialTDocument() {
        return new TDocument();
    }
}

