/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.dnd;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import diagrammodelfw.model.DRelativePoint;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import trier.classdiagram.CDConstants;
import trier.classdiagram.model.CDDocument;
import trier.classdiagram.model.CDEditDomain;
import trier.diagrameditor.dnd.TElementTransferDropTargetListener;
import trier.diagrameditor.model.EElement;
import trier.model.core.TAssociation;
import trier.model.core.TAssociationEnd;
import trier.model.core.TClass;
import trier.model.core.TGeneralization;

public class CDElementTransferDorpTargetListener
extends TElementTransferDropTargetListener {
    public CDElementTransferDorpTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected Command createAddEConnectionElementCommand(EElement eElement) {
        CompoundCommand commands = new CompoundCommand();
        if (eElement.getTModel() instanceof TClass) {
            Command generalizationsCommand;
            CompoundCommand associationsCommand = this.createAddAssociationsCommand(eElement);
            if (associationsCommand.canExecute()) {
                commands.add((Command)associationsCommand);
            }
            if ((generalizationsCommand = this.createAddGeneralizationsCommand(eElement)).canExecute()) {
                commands.add(generalizationsCommand);
            }
        }
        return commands;
    }

    private CompoundCommand createAddAssociationsCommand(EElement eElement) {
        TClass tClass = (TClass)eElement.getTModel();
        CompoundCommand associationCommands = new CompoundCommand();
        Collection referedAssociations = tClass.getReferedAssociations();
        Iterator i = referedAssociations.iterator();
        while (i.hasNext()) {
            EElement connection;
            DConnection dConnection;
            TAssociation association = (TAssociation)i.next();
            if (association.getTargetAssociationEnd().getOwner().equals(association.getSourceAssociationEnd().getOwner())) {
                DConnection dConnection2 = this.getCDDocument().getDDocument().createConnection(association.getId(), (DNode)eElement.getDModel(), (DNode)eElement.getDModel());
                EElement connection2 = new EElement(association, (DElement)dConnection2);
                this.addSelfAssociationCommands(associationCommands, connection2);
                this.addAssociationEndCommands(connection2, associationCommands);
                this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)connection2);
                continue;
            }
            if (association.getSourceAssociationEnd().getOwner().equals(tClass)) {
                TClass target = association.getTargetAssociationEnd().getOwner();
                List targetEElements = this.getCDDocument().getElementsByTElement(target);
                if (targetEElements.isEmpty()) continue;
                EElement targetEElement = (EElement)targetEElements.get(0);
                dConnection = this.getCDDocument().getDDocument().createConnection(association.getId(), (DNode)eElement.getDModel(), (DNode)targetEElement.getDModel());
                connection = new EElement(association, (DElement)dConnection);
                this.addNormalAssociationCommands(associationCommands, connection);
                this.addAssociationEndCommands(connection, associationCommands);
                this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)connection);
                continue;
            }
            TClass source = association.getSourceAssociationEnd().getOwner();
            List sourceEElements = this.getCDDocument().getElementsByTElement(source);
            if (sourceEElements.isEmpty()) continue;
            EElement sourceEElement = (EElement)sourceEElements.get(0);
            dConnection = this.getCDDocument().getDDocument().createConnection(association.getId(), (DNode)sourceEElement.getDModel(), (DNode)eElement.getDModel());
            connection = new EElement(association, (DElement)dConnection);
            this.addNormalAssociationCommands(associationCommands, connection);
            this.addAssociationEndCommands(connection, associationCommands);
            this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)connection);
        }
        return associationCommands;
    }

    private void addNormalAssociationCommands(CompoundCommand associationCommands, EElement connection) {
        associationCommands.add(this.getEEditDomain().createAddEElementCommand(connection));
        associationCommands.add(this.getEEditDomain().getDCommandFactory().createSetConnectionTypeCommand((DConnection)connection.getDModel(), this.getEEditDomain().getDocument().getDDocument().getConnectionType()));
    }

    private void addSelfAssociationCommands(CompoundCommand commands, EElement connection) {
        DConnection dConnection = (DConnection)connection.getDModel();
        commands.add(this.getEEditDomain().createAddEElementCommand(connection));
        commands.add(this.getEEditDomain().getDCommandFactory().createSetConnectionTypeCommand(dConnection, 1));
        DRelativePoint[] rp = new DRelativePoint[3];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 1;
        int[] flagX = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[1] = -1;
        int[] flagY = nArray2;
        Rectangle r = new Rectangle();
        r.setSize(140, 100);
        int i = 0;
        while (i < rp.length) {
            rp[i] = this.createRelativePoint(r, flagX[i], flagY[i]);
            ++i;
        }
        i = 0;
        while (i < rp.length) {
            commands.add(this.getEEditDomain().getDCommandFactory().createAddBendpointCommand(dConnection, rp[i], i));
            ++i;
        }
    }

    private DRelativePoint createRelativePoint(Rectangle r, int flagX, int flagY) {
        Point center = r.getCenter();
        return DRelativePoint.createInstance((Point)center.getTranslated(new Dimension(flagX * (r.width / 2 + 35), flagY * (r.height / 2 + 35))), (Point)center, (Point)center);
    }

    private void addAssociationEndCommands(EElement association, CompoundCommand associationCommands) {
        TAssociationEnd source = ((TAssociation)association.getTModel()).getSourceAssociationEnd();
        TAssociationEnd target = ((TAssociation)association.getTModel()).getTargetAssociationEnd();
        if (!source.getRole().isNull()) {
            associationCommands.add(this.createAddRoleCommand(association, source, CDConstants.ROLE_SOURCE_RELATIVE_POINT));
        }
        if (!source.getMultiplicity().isNull()) {
            associationCommands.add(this.createAddMultiplicityCommand(association, source, CDConstants.MULTIPLICITY_SOURCE_RELATIVE_POINT));
        }
        if (!target.getRole().isNull()) {
            associationCommands.add(this.createAddRoleCommand(association, target, CDConstants.ROLE_TARGET_RELATIVE_POINT));
        }
        if (!target.getMultiplicity().isNull()) {
            associationCommands.add(this.createAddMultiplicityCommand(association, target, CDConstants.MULTIPLICITY_TARGET_RELATIVE_POINT));
        }
    }

    private Command createAddMultiplicityCommand(EElement association, TAssociationEnd associationEnd, DRelativePoint point) {
        TAssociation cfr_ignored_0 = (TAssociation)association.getTModel();
        CompoundCommand commands = new CompoundCommand();
        DLabel label = this.getCDDocument().getDDocument().createLabel(associationEnd.getMultiplicity().getId(), (DConnection)association.getDModel());
        EElement eRole = new EElement(associationEnd.getMultiplicity(), (DElement)label);
        commands.add(this.getEEditDomain().createAddEElementCommand(eRole));
        this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)eRole);
        commands.add(this.getEEditDomain().getDCommandFactory().createSetLocationCommand(label, point));
        return commands;
    }

    private Command createAddRoleCommand(EElement association, TAssociationEnd associationEnd, DRelativePoint point) {
        TAssociation cfr_ignored_0 = (TAssociation)association.getTModel();
        CompoundCommand commands = new CompoundCommand();
        DLabel label = this.getCDDocument().getDDocument().createLabel(associationEnd.getRole().getId(), (DConnection)association.getDModel());
        EElement eRole = new EElement(associationEnd.getRole(), (DElement)label);
        commands.add(this.getEEditDomain().createAddEElementCommand(eRole));
        this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)eRole);
        commands.add(this.getEEditDomain().getDCommandFactory().createSetLocationCommand(label, point));
        return commands;
    }

    private Command createAddGeneralizationsCommand(EElement eElement) {
        TClass tClass = (TClass)eElement.getTModel();
        CompoundCommand generalizationCommands = new CompoundCommand();
        Collection referedGeneralizations = tClass.getReferedGeneralizations();
        Iterator i = referedGeneralizations.iterator();
        while (i.hasNext()) {
            EElement connection;
            DConnection dConnection;
            TGeneralization generalization = (TGeneralization)i.next();
            if (generalization.getChildClass().equals(tClass)) {
                TClass target = generalization.getParentClass();
                List targetEElements = this.getCDDocument().getElementsByTElement(target);
                if (targetEElements.isEmpty()) continue;
                EElement targetEElement = (EElement)targetEElements.get(0);
                dConnection = this.getCDDocument().getDDocument().createConnection(generalization.getId(), (DNode)eElement.getDModel(), (DNode)targetEElement.getDModel());
                connection = new EElement(generalization, (DElement)dConnection);
                generalizationCommands.add(this.getEEditDomain().createAddEElementCommand(connection));
                generalizationCommands.add(this.getEEditDomain().getDCommandFactory().createSetConnectionTypeCommand(dConnection, this.getEEditDomain().getDocument().getDDocument().getConnectionType()));
                this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)connection);
                continue;
            }
            TClass source = generalization.getChildClass();
            List sourceEElements = this.getCDDocument().getElementsByTElement(source);
            if (sourceEElements.isEmpty()) continue;
            EElement sourceEElement = (EElement)sourceEElements.get(0);
            dConnection = this.getCDDocument().getDDocument().createConnection(generalization.getId(), (DNode)sourceEElement.getDModel(), (DNode)eElement.getDModel());
            connection = new EElement(generalization, (DElement)dConnection);
            generalizationCommands.add(this.getEEditDomain().createAddEElementCommand(connection));
            generalizationCommands.add(this.getEEditDomain().getDCommandFactory().createSetConnectionTypeCommand(dConnection, this.getEEditDomain().getDocument().getDDocument().getConnectionType()));
            this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)connection);
        }
        return generalizationCommands;
    }

    public CDDocument getCDDocument() {
        return (CDDocument)((CDEditDomain)this.getEEditDomain()).getDocument();
    }
}

