/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import diagrammodelfw.model.DLabel;
import diagrammodelfw.model.DNode;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.edit.property.EDocumentEditDialog;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.core.TModelElement;
import trier.model.core.TPackage;

public class CDDocumentEditDialog
extends EDocumentEditDialog {
    private static final String[] FEATURE_LOOKS_TYPES = new String[]{"show all", "hide attributes", "hide methods", "hide all"};
    private static final String[] ICON_LOOKS_TYPES = new String[]{"show icon", "hide icon"};
    private static final String[] STEREO_TYPE_LOOKS_TYPES = new String[]{"show stereo type", "hide stereo type"};
    private Combo featureLooksTypeCombo;
    private Button featureLooksApplyAllButton;
    private Combo iconLooksTypeCombo;
    private Button iconLooksApplyAllButton;
    private Combo stereoTypeLooksTypeCombo;
    private Button stereoTypeLooksApplyAllButton;
    private Button packageApplyAllButton;

    public CDDocumentEditDialog(EEditDomain domain, EElement element) {
        super(domain, element);
    }

    protected Control createDialogArea(Composite parent) {
        Control main = super.createDialogArea(parent);
        main.setSize(800, 400);
        this.initializeNodeLooksCompoiste(parent);
        this.initializePackageSettingGroup(parent);
        main.pack();
        return parent;
    }

    private void initializeNodeLooksCompoiste(Composite parent) {
        Group nodeLooksComposite = new Group(parent, 0);
        nodeLooksComposite.setText("Default Class Looks");
        nodeLooksComposite.setLayout((Layout)new GridLayout(3, false));
        nodeLooksComposite.setLayoutData((Object)new GridData(768));
        this.initializeFeatureLooksSettingComposite((Composite)nodeLooksComposite);
        this.initializeIconLooksSettingComposite((Composite)nodeLooksComposite);
        this.initializeStereoTypeLooksSettingComposite((Composite)nodeLooksComposite);
    }

    private void initializePackageSettingGroup(Composite parent) {
        Group packageSettingGroup = new Group(parent, 0);
        packageSettingGroup.setText("Package");
        packageSettingGroup.setLayout((Layout)new GridLayout(3, false));
        packageSettingGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)packageSettingGroup, 0);
        label.setText("Diagram Package ");
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        Label packageLabel = new Label((Composite)packageSettingGroup, 8);
        GridData comboGridData = new GridData(768);
        comboGridData.widthHint = 250;
        packageLabel.setText(((CDDocument)this.getEDocument()).getPackage().toString());
        packageLabel.setLayoutData((Object)comboGridData);
        this.packageApplyAllButton = new Button((Composite)packageSettingGroup, 8);
        this.packageApplyAllButton.setText("Move All");
        this.packageApplyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.packageApplyAllSeletcted(e);
            }
        });
        gridData = new GridData();
        gridData.widthHint = 100;
        this.packageApplyAllButton.setLayoutData((Object)gridData);
    }

    private void initializeFeatureLooksSettingComposite(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Class Feature Looks:");
        GridData labelGridData = new GridData();
        labelGridData.widthHint = 200;
        label.setLayoutData((Object)labelGridData);
        this.featureLooksTypeCombo = new Combo(composite, 8);
        int i = 0;
        while (i < FEATURE_LOOKS_TYPES.length) {
            this.featureLooksTypeCombo.add(FEATURE_LOOKS_TYPES[i]);
            ++i;
        }
        this.featureLooksTypeCombo.select(this.getDDocument().getNodeType() & 3);
        GridData comboGridData = new GridData(768);
        comboGridData.widthHint = 250;
        this.featureLooksTypeCombo.setLayoutData((Object)comboGridData);
        this.featureLooksTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.featureLooksTypeComboSeletcted(e);
            }
        });
        this.featureLooksApplyAllButton = new Button(composite, 8);
        this.featureLooksApplyAllButton.setText("Apply All");
        this.featureLooksApplyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.featureLooksApplyAllSeletcted(e);
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.featureLooksApplyAllButton.setLayoutData((Object)gridData);
    }

    private void initializeIconLooksSettingComposite(Composite composite) {
        Label iconLabel = new Label(composite, 0);
        iconLabel.setText("Icon Looks:");
        GridData labelGridData = new GridData();
        labelGridData.widthHint = 200;
        iconLabel.setLayoutData((Object)labelGridData);
        this.iconLooksTypeCombo = new Combo(composite, 8);
        int i = 0;
        while (i < ICON_LOOKS_TYPES.length) {
            this.iconLooksTypeCombo.add(ICON_LOOKS_TYPES[i]);
            ++i;
        }
        if ((this.getDDocument().getNodeType() & 8) != 8) {
            this.iconLooksTypeCombo.select(0);
        } else {
            this.iconLooksTypeCombo.select(1);
        }
        GridData comboGridData = new GridData(768);
        comboGridData.widthHint = 250;
        this.iconLooksTypeCombo.setLayoutData((Object)comboGridData);
        this.iconLooksTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.iconLooksTypeComboSeletcted(e);
            }
        });
        this.iconLooksApplyAllButton = new Button(composite, 8);
        this.iconLooksApplyAllButton.setText("Apply All");
        this.iconLooksApplyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.iconLooksApplyAllSeletcted(e);
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.iconLooksApplyAllButton.setLayoutData((Object)gridData);
    }

    private void initializeStereoTypeLooksSettingComposite(Composite composite) {
        Label stereoTypeLabel = new Label(composite, 0);
        stereoTypeLabel.setText("Class Stereo Type Looks:");
        GridData labelGridData = new GridData();
        labelGridData.widthHint = 200;
        stereoTypeLabel.setLayoutData((Object)labelGridData);
        this.stereoTypeLooksTypeCombo = new Combo(composite, 8);
        int i = 0;
        while (i < STEREO_TYPE_LOOKS_TYPES.length) {
            this.stereoTypeLooksTypeCombo.add(STEREO_TYPE_LOOKS_TYPES[i]);
            ++i;
        }
        if ((this.getDDocument().getNodeType() & 4) != 4) {
            this.stereoTypeLooksTypeCombo.select(0);
        } else {
            this.stereoTypeLooksTypeCombo.select(1);
        }
        GridData comboGridData = new GridData(768);
        comboGridData.widthHint = 250;
        this.stereoTypeLooksTypeCombo.setLayoutData((Object)comboGridData);
        this.stereoTypeLooksTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.stereoTypeLooksTypeComboSeletcted(e);
            }
        });
        this.stereoTypeLooksApplyAllButton = new Button(composite, 8);
        this.stereoTypeLooksApplyAllButton.setText("Apply All");
        this.stereoTypeLooksApplyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDDocumentEditDialog.this.stereoTypeLooksApplyAllSeletcted(e);
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.stereoTypeLooksApplyAllButton.setLayoutData((Object)gridData);
    }

    protected void featureLooksTypeComboSeletcted(SelectionEvent e) {
        int type = this.getSelectedFeatureNodeType();
        Command command = this.getEEditDomain().getDCommandFactory().createSetDefaultNodeTypeCommand(this.getCDDocument().calculateNewNodeType(this.getDDocument().getNodeType(), type, false));
        super.executeCommand(command);
    }

    protected void featureLooksApplyAllSeletcted(SelectionEvent e) {
        if (this.getDDocument().getAllNodes().isEmpty()) {
            return;
        }
        int type = this.getSelectedFeatureNodeType();
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getDDocument().getAllNodes().iterator();
        while (i.hasNext()) {
            DNode node = (DNode)i.next();
            commands.add(this.getEEditDomain().getDCommandFactory().createSetNodeTypeCommand(node, this.getCDDocument().calculateNewNodeType(node.getNodeType(), type, false)));
        }
        super.executeCommand((Command)commands);
    }

    protected void iconLooksTypeComboSeletcted(SelectionEvent e) {
        boolean isExclusion = this.iconLooksTypeCombo.getSelectionIndex() == 0;
        Command command = this.getEEditDomain().getDCommandFactory().createSetDefaultNodeTypeCommand(this.getCDDocument().calculateNewNodeType(this.getDDocument().getNodeType(), 8, isExclusion));
        super.executeCommand(command);
    }

    protected void iconLooksApplyAllSeletcted(SelectionEvent e) {
        if (this.getDDocument().getAllNodes().isEmpty()) {
            return;
        }
        boolean isExclusion = this.iconLooksTypeCombo.getSelectionIndex() == 0;
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getDDocument().getAllNodes().iterator();
        while (i.hasNext()) {
            DNode node = (DNode)i.next();
            commands.add(this.getEEditDomain().getDCommandFactory().createSetNodeTypeCommand(node, this.getCDDocument().calculateNewNodeType(node.getNodeType(), 8, isExclusion)));
        }
        super.executeCommand((Command)commands);
    }

    protected void stereoTypeLooksTypeComboSeletcted(SelectionEvent e) {
        boolean isExclusion = this.stereoTypeLooksTypeCombo.getSelectionIndex() == 0;
        Command command = this.getEEditDomain().getDCommandFactory().createSetDefaultNodeTypeCommand(this.getCDDocument().calculateNewNodeType(this.getDDocument().getNodeType(), 4, isExclusion));
        super.executeCommand(command);
    }

    protected void stereoTypeLooksApplyAllSeletcted(SelectionEvent e) {
        if (this.getDDocument().getAllNodes().isEmpty()) {
            return;
        }
        boolean isExclusion = this.stereoTypeLooksTypeCombo.getSelectionIndex() == 0;
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getDDocument().getAllNodes().iterator();
        while (i.hasNext()) {
            DNode node = (DNode)i.next();
            commands.add(this.getEEditDomain().getDCommandFactory().createSetNodeTypeCommand(node, this.getCDDocument().calculateNewNodeType(node.getNodeType(), 4, isExclusion)));
        }
        super.executeCommand((Command)commands);
    }

    protected void packageApplyAllSeletcted(SelectionEvent e) {
        if (this.getEDocument().getAllElements().isEmpty()) {
            return;
        }
        TPackage diagramPackage = ((CDDocument)this.getEDocument()).getPackage();
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getEDocument().getAllElements().iterator();
        while (i.hasNext()) {
            EElement element = (EElement)i.next();
            TModelElement tModelElement = (TModelElement)element.getTModel();
            if (element.getDModel() instanceof DLabel) continue;
            commands.add((Command)new ECommand(this.getEEditDomain().getTCommandFactory().createSetNamespaceCommand(tModelElement, diagramPackage)));
        }
        super.executeCommand((Command)commands);
    }

    private int getSelectedFeatureNodeType() {
        return this.featureLooksTypeCombo.getSelectionIndex() + 0;
    }

    private CDDocument getCDDocument() {
        return (CDDocument)this.getEDocument();
    }
}

