/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import trier.classdiagram.edit.property.CDEditDialog;
import trier.classdiagram.edit.property.CDParameterTableEditorComposite;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.edit.property.EStateChangeListener;
import trier.diagrameditor.model.EElement;
import trier.model.command.TCommand;
import trier.model.command.TCommandFactory;
import trier.model.core.TMethod;
import trier.model.core.TParameter;

public class CDMethodEditDialog
extends CDEditDialog
implements EStateChangeListener {
    private Text signatureText;

    public CDMethodEditDialog(EEditDialog dialog, EElement method) {
        super(dialog, method);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Method Parameters");
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        this.initializeSignatureComposite(composite);
        this.initializeParamterComposite(composite);
        composite.pack();
        return composite;
    }

    private void initializeSignatureComposite(Composite composite) {
        Group signatureGroup = new Group(composite, 0);
        signatureGroup.setLayout((Layout)new GridLayout());
        signatureGroup.setLayoutData((Object)new GridData(768));
        signatureGroup.setText("Signature");
        this.signatureText = new Text((Composite)signatureGroup, 0x800000);
        this.signatureText.setLayoutData((Object)new GridData(768));
        this.signatureText.setEditable(false);
        this.refreshSignatureLabel();
    }

    private void refreshSignatureLabel() {
        String visibility = this.getTMethod().getVisibilityKind().toString();
        String type = this.getTMethod().getType().getName();
        if (type.startsWith("NullObject")) {
            type = "void";
        }
        String name = this.getTMethod().getName();
        StringBuffer parameters = new StringBuffer();
        parameters.append("(");
        List list = this.getTMethod().getParameters();
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                parameters.append(", ");
            }
            TParameter parameter = (TParameter)list.get(i);
            String parameterType = parameter.getType().getName();
            String parameterName = parameter.getName();
            parameters.append(String.valueOf(parameterType) + " " + parameterName);
            ++i;
        }
        parameters.append(")");
        this.signatureText.setText(String.valueOf(visibility) + " " + type + " " + name + parameters.toString());
    }

    protected TMethod getTMethod() {
        return (TMethod)this.getTModel();
    }

    private void initializeParamterComposite(Composite composite) {
        CDParameterTableEditorComposite parameterTableEditorComposite = new CDParameterTableEditorComposite(composite, this);
        parameterTableEditorComposite.addEStateChangeListener(this);
    }

    public void stateChanged() {
        this.refreshSignatureLabel();
        this.getButton(0).setEnabled(true);
    }

    public TCommand[] openDialog() {
        super.open();
        return (TCommand[])this.getCDEditDomain().getCommandStack().getCommands();
    }

    public void restoreOldMethod() {
        super.cancelPressed();
    }

    public TCommandFactory getTCommandFactory() {
        return super.getEEditDomain().getTCommandFactory();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

