/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.edit.property.EModelEditTableComposite;
import trier.diagrameditor.model.ECommand;
import trier.model.command.TCommand;
import trier.model.core.TClassifier;
import trier.model.core.TFeature;
import trier.model.core.TModelElement;
import trier.model.core.TTypedElement;
import trier.model.core.TVisibilityKind;

public abstract class CDModelElementTableEditorComposite
extends EModelEditTableComposite {
    public CDModelElementTableEditorComposite(EEditDialog dialog) {
        super(dialog);
    }

    protected void addNewElement() {
        TModelElement newElement = this.getDefaultElement();
        String uniqueName = this.getUniqueSignatureName(newElement);
        TCommand tmpCommand = this.getTCommandFactory().createSetNameCommand(newElement, uniqueName);
        this.executeCommand(tmpCommand);
        TCommand newCommand = null;
        int insertIndex = 0;
        if (this.lastElementSelected()) {
            newCommand = this.getTCommandFactory().createAddTElementCommand(this.getTElement(), newElement);
            insertIndex = this.getTable().getItemCount();
        } else {
            int[] selectedIndices = this.getTable().getSelectionIndices();
            insertIndex = selectedIndices[selectedIndices.length - 1] + 1;
            newCommand = this.getTCommandFactory().createInsertTElementCommand(this.getTElement(), newElement, insertIndex);
        }
        this.executeCommand(newCommand);
        this.getTableEditor().updateTable();
        this.getTable().setSelection(insertIndex);
        this.stateChanged();
    }

    protected void modifyElement() {
    }

    protected void removeElement() {
        TModelElement[] removeParameters = ((CDModelElementTableEditor)this.getTableEditor()).getSelectedElements();
        CompoundCommand removeCommands = new CompoundCommand();
        int i = 0;
        while (i < removeParameters.length) {
            TCommand removeCommand = this.getTCommandFactory().createRemoveTElementCommand(removeParameters[i]);
            removeCommands.add((Command)new ECommand(removeCommand));
            ++i;
        }
        this.executeCommands((Command)removeCommands);
        this.getTableEditor().updateTable();
        this.stateChanged();
    }

    protected void moveUpElements() {
        CDModelElementTableEditor tableEditor = (CDModelElementTableEditor)this.getTableEditor();
        TModelElement[] moveElements = tableEditor.getSelectedElements();
        CompoundCommand moveCommands = new CompoundCommand();
        int i = 0;
        while (i < moveElements.length) {
            TCommand moveCommand = this.getTCommandFactory().createMoveUpTElementCommand(this.getTElement(), moveElements[i]);
            moveCommands.add((Command)new ECommand(moveCommand));
            ++i;
        }
        this.executeCommands((Command)moveCommands);
        this.getTableEditor().updateTable();
        this.stateChanged();
    }

    protected void moveDownElements() {
        CDModelElementTableEditor tableEditor = (CDModelElementTableEditor)this.getTableEditor();
        TModelElement[] moveElements = tableEditor.getSelectedElements();
        CompoundCommand moveCommands = new CompoundCommand();
        int i = moveElements.length - 1;
        while (i >= 0) {
            TCommand moveCommand = this.getTCommandFactory().createMoveDownTElementCommand(this.getTElement(), moveElements[i]);
            moveCommands.add((Command)new ECommand(moveCommand));
            --i;
        }
        this.executeCommands((Command)moveCommands);
        this.getTableEditor().updateTable();
        this.stateChanged();
    }

    protected void modifyElementVisibility(TFeature modifiedFeature, TVisibilityKind visibilityKind) {
        TCommand modifyCommand = this.getTCommandFactory().createSetVisibilityCommand(modifiedFeature, visibilityKind);
        this.executeCommand(modifyCommand);
        this.stateChanged();
    }

    public void modifyElementName(TModelElement modifiedElement, String value) {
        String newName = value;
        String oldName = modifiedElement.getName();
        if (!newName.equals(oldName) && this.hasSignature(newName)) {
            this.showSignatureDuplicateDialog(newName);
            return;
        }
        TCommand modifyCommand = this.getTCommandFactory().createSetNameCommand(modifiedElement, value);
        this.executeCommand(modifyCommand);
        this.stateChanged();
    }

    protected void modifyElementType(TTypedElement modifiedElement, TClassifier classifier) {
        TCommand modifyCommand = this.getTCommandFactory().createSetTypeCommand(modifiedElement, classifier);
        this.executeCommand(modifyCommand);
        this.stateChanged();
    }
}

