/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.edit.property;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import trier.classdiagram.edit.property.CDEditDialog;
import trier.diagrameditor.edit.property.EEditComposite;
import trier.model.command.TCommand;
import trier.model.core.TModifiedElement;
import trier.model.core.TModifier;

public class CDModifierComposite
extends EEditComposite {
    private Button abstractButton;
    private Button finalButton;
    private Button staticButton;

    public CDModifierComposite(Composite parent, CDEditDialog parentDialog) {
        super(parentDialog);
        Group modifierGroup = new Group(parent, 0);
        modifierGroup.setText("Modifiers");
        modifierGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        modifierGroup.setLayout((Layout)layout);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDModifierComposite.this.buttonSelected(e);
            }
        };
        this.abstractButton = new Button((Composite)modifierGroup, 32);
        this.abstractButton.setText("abstract");
        this.abstractButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.finalButton = new Button((Composite)modifierGroup, 32);
        this.finalButton.setText("final");
        this.finalButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.staticButton = new Button((Composite)modifierGroup, 32);
        this.staticButton.setText("static");
        this.staticButton.addSelectionListener((SelectionListener)selectionAdapter);
        TModifier modifier = this.getTModifiedElement().getModifier();
        if (modifier.isAbstract()) {
            this.abstractButton.setSelection(true);
        }
        if (modifier.isFinal()) {
            this.finalButton.setSelection(true);
        }
        if (modifier.isStatic()) {
            this.staticButton.setSelection(true);
        }
    }

    private void buttonSelected(SelectionEvent event) {
        Button button = (Button)event.widget;
        if (button.equals(this.abstractButton)) {
            this.modifyAbstractModifier(this.abstractButton.getSelection());
        } else if (button.equals(this.finalButton)) {
            this.modifyFinalModifier(this.finalButton.getSelection());
        } else if (button.equals(this.staticButton)) {
            this.modifyStaticModifier(this.staticButton.getSelection());
        }
        this.stateChanged();
    }

    private void modifyFinalModifier(boolean flag) {
        TCommand modifierChangeCommand = this.getTCommandFactory().createSetFinalCommand(this.getTModifiedElement(), flag);
        this.executeCommand(modifierChangeCommand);
        this.stateChanged();
    }

    private void modifyAbstractModifier(boolean flag) {
        TCommand modifierChangeCommand = this.getTCommandFactory().createSetAbstractCommand(this.getTModifiedElement(), flag);
        this.executeCommand(modifierChangeCommand);
        this.stateChanged();
    }

    private void modifyStaticModifier(boolean flag) {
        TCommand modifierChangeCommand = this.getTCommandFactory().createSetStaticCommand(this.getTModifiedElement(), flag);
        this.executeCommand(modifierChangeCommand);
        this.stateChanged();
    }

    private TModifiedElement getTModifiedElement() {
        return (TModifiedElement)((Object)super.getTElement());
    }
}

