/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.Request;
import trier.classdiagram.edit.property.CDAssociationEditDialog;
import trier.classdiagram.figure.CDConnectionFigureFactory;
import trier.diagrameditor.editpart.EConnectionEditPart;
import trier.diagrameditor.model.EElement;
import trier.model.core.TAggregationKind;
import trier.model.core.TAssociation;

public class CDAssociationEditPart
extends EConnectionEditPart {
    public boolean understandsRequest(Request request) {
        if (request.getType().equals("property edit")) {
            return true;
        }
        return super.understandsRequest(request);
    }

    protected void showDirectEditor() {
        this.showPropertyEditor();
    }

    protected void showPropertyEditor() {
        CDAssociationEditDialog dialog = new CDAssociationEditDialog(this.getEditDomain(), (EElement)this.getModel());
        dialog.open();
    }

    protected void refreshVisuals() {
        this.refreshFigure();
        super.refreshVisuals();
    }

    private void refreshFigure() {
        TAggregationKind targetAggregationKind;
        TAggregationKind sourceAggregationKind;
        PolylineConnection connection = (PolylineConnection)this.getConnectionFigure();
        TAssociation model = (TAssociation)this.getElement().getTModel();
        CDConnectionFigureFactory.removeAssociationDecoration(connection);
        if (model.getSourceAssociationEnd().isNavigable()) {
            CDConnectionFigureFactory.addSourceAssociationDecoration(connection);
        }
        if (model.getTargetAssociationEnd().isNavigable()) {
            CDConnectionFigureFactory.addTargetAssociationDecoration(connection);
        }
        if (!(sourceAggregationKind = model.getSourceAssociationEnd().getAggregationKind()).equals(TAggregationKind.NONE)) {
            connection.setSourceDecoration((RotatableDecoration)CDConnectionFigureFactory.createAggregateDecoration(sourceAggregationKind.toString()));
        }
        if (!(targetAggregationKind = model.getTargetAssociationEnd().getAggregationKind()).equals(TAggregationKind.NONE)) {
            connection.setTargetDecoration((RotatableDecoration)CDConnectionFigureFactory.createAggregateDecoration(targetAggregationKind.toString()));
        }
    }

    private TAssociation getTAssociation() {
        return (TAssociation)this.getElement().getTModel();
    }

    public void activate() {
        if (!super.isActive()) {
            super.activate();
            this.getTAssociation().getTargetAssociationEnd().addPropertyChangeListener(this);
            this.getTAssociation().getSourceAssociationEnd().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (super.isActive()) {
            super.deactivate();
            this.getTAssociation().getTargetAssociationEnd().removePropertyChangeListener(this);
            this.getTAssociation().getSourceAssociationEnd().removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("TModelElement changed")) {
            this.refreshVisuals();
        }
    }
}

