/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import trier.diagrameditor.figure.EConnectionFigureFactory;
import trier.model.core.TAggregationKind;

public class CDConnectionFigureFactory
extends EConnectionFigureFactory {
    private static Color lineColor = ColorConstants.black;
    private static Color bgColor = ColorConstants.white;
    private int lineWidth = 1;

    public Connection createConnectionFigure(String connectionType) {
        PolylineConnection polyline = new PolylineConnection();
        polyline.setLineWidth(1);
        polyline.setForegroundColor(ColorConstants.black);
        if (!connectionType.equals("Association")) {
            if (connectionType.equals("NavigableAssociation")) {
                CDConnectionFigureFactory.addTargetAssociationDecoration(polyline);
            } else if (connectionType.equals("AggregateAssociation")) {
                CDConnectionFigureFactory.addAggregateAssociationDecoration(polyline);
            } else if (connectionType.equals("CompositeAssociation")) {
                CDConnectionFigureFactory.addCompositeAssociationDecoration(polyline);
            } else if (connectionType.equals("Generalization")) {
                CDConnectionFigureFactory.addInheritanceDecoration(polyline);
            } else if (connectionType.equals("Dependency")) {
                CDConnectionFigureFactory.addDependencyDecoration(polyline);
            } else if (connectionType.equals("Anchor")) {
                CDConnectionFigureFactory.addAnchorDecoration(polyline);
            } else if (connectionType.equals("Implementation")) {
                CDConnectionFigureFactory.addImplementationDecoration(polyline);
            }
        }
        return polyline;
    }

    public static void addSourceAssociationDecoration(PolylineConnection polyline) {
        polyline.setSourceDecoration((RotatableDecoration)CDConnectionFigureFactory.createNavigatableDecoration());
    }

    public static void addTargetAssociationDecoration(PolylineConnection polyline) {
        polyline.setTargetDecoration((RotatableDecoration)CDConnectionFigureFactory.createNavigatableDecoration());
    }

    private static PolylineDecoration createNavigatableDecoration() {
        PolylineDecoration decoration = new PolylineDecoration();
        decoration.setScale(10.0, 3.0);
        return decoration;
    }

    public static void addCompositeAssociationDecoration(PolylineConnection polyline) {
        polyline.setSourceDecoration((RotatableDecoration)CDConnectionFigureFactory.createAggregateDecoration(TAggregationKind.COMPOSITION_AS_STRING));
    }

    public static void addAggregateAssociationDecoration(PolylineConnection polyline) {
        polyline.setSourceDecoration((RotatableDecoration)CDConnectionFigureFactory.createAggregateDecoration(TAggregationKind.AGGREGATION_AS_STRING));
    }

    public static PolygonDecoration createAggregateDecoration(String aggregationKind) {
        PolygonDecoration decoration = new PolygonDecoration();
        if (aggregationKind.equals(TAggregationKind.AGGREGATION_AS_STRING)) {
            decoration.setBackgroundColor(bgColor);
        }
        decoration.setScale(8.0, 4.0);
        PointList list = new PointList();
        list.addPoint(0, 0);
        list.addPoint(-1, 1);
        list.addPoint(-2, 0);
        list.addPoint(-1, -1);
        decoration.setTemplate(list);
        return decoration;
    }

    public static void removeAssociationDecoration(PolylineConnection polyline) {
        polyline.setSourceDecoration(null);
        polyline.setTargetDecoration(null);
    }

    public static void addInheritanceDecoration(PolylineConnection polyline) {
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setBackgroundColor(bgColor);
        decoration.setScale(15.0, 8.0);
        polyline.setTargetDecoration((RotatableDecoration)decoration);
    }

    public static void addImplementationDecoration(PolylineConnection polyline) {
        polyline.setLineStyle(3);
        CDConnectionFigureFactory.addInheritanceDecoration(polyline);
    }

    public static void addAnchorDecoration(PolylineConnection polyline) {
        polyline.setLineStyle(3);
    }

    public static void addDependencyDecoration(PolylineConnection polyline) {
        PolylineDecoration decoration = new PolylineDecoration();
        decoration.setScale(10.0, 3.0);
        polyline.setLineStyle(3);
        polyline.setTargetDecoration((RotatableDecoration)decoration);
    }
}

