/*
 * Decompiled with CFR 0.152.
 */
package trier.classdiagram.model;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import trier.Trier;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EElement;
import trier.model.core.TAnchor;
import trier.model.core.TAssociation;
import trier.model.core.TClass;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TGeneralization;
import trier.model.core.TMultiplicity;
import trier.model.core.TNamespace;
import trier.model.core.TNote;
import trier.model.core.TPackage;
import trier.model.core.TRole;
import trier.model.core.TStereoType;

public class CDDocument
extends EDocument {
    private static final Logger logger;
    public static final String DEFAULT_CLASSNAME = "NewClass";
    public static final String DEFAULT_INTERFACENAME = "NewInterface";
    public static final String DEFAULT_PACKAGENAME = "NewPackage";
    public static final String INTERFACE = "Interface";
    public static final String CLASS = "Class";
    public static final String PACKAGE = "Package";
    public static final String GENERALIZATION = "Generalization";
    public static final String INHERITANCE = "Inheritance";
    public static final String IMPLEMENTATION = "Implementation";
    public static final String ASSOCIATION = "Association";
    public static final String MULTIPLICITY = "Multiplicity";
    public static final String ROLE = "Role";
    public static final String NAVIGABLE_ASSOCIATION = "NavigableAssociation";
    public static final String AGGREGATE_ASSOCIATION = "AggregateAssociation";
    public static final String COMPOSITE_ASSOCIATION = "CompositeAssociation";
    public static final String ANCHOR = "Anchor";
    public static final String NOTE = "Note";
    public static final String DEPENDENCY = "Dependency";
    public static final String SELF_ASSOCIATION = "SelfAssociation";
    public static final String SELF_ASSOCIATION_TOPLEFT = "SelfAssociationTopLeft";
    public static final String SELF_ASSOCIATION_TOPRIGHT = "SelfAssociationTopRight";
    public static final String SELF_ASSOCIATION_BOTTOMLEFT = "SelfAssociationBottomLeft";
    public static final String SELF_ASSOCIATION_BOTTOMRIGHT = "SelfAssociationBottomRight";
    private TPackage ownedPackage = null;
    private IContainer parentContainer = null;
    private IFile file = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.classdiagram.model.CDDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public CDDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
    }

    public IContainer getParentContainer() {
        return this.parentContainer;
    }

    public TPackage getPackage() {
        if (!this.ownedPackage.isRemoved()) {
            return this.ownedPackage;
        }
        this.setOwnedPackage(this.file);
        return this.ownedPackage;
    }

    public TElement getDiagramOwner() {
        return this.getPackage();
    }

    public IContainer getTargetContainer(TPackage tPackage) {
        IContainer targetContainer = Trier.getInstance().getModelRootContainer(this.getParentContainer().getProject());
        Stack<String> packageStructure = new Stack<String>();
        try {
            TNamespace current = tPackage;
            while (!current.equals(this.getTDocument().getDefaultPackage())) {
                packageStructure.push(current.getName());
                current = current.getNamespace();
            }
            while (!packageStructure.isEmpty()) {
                String childName = (String)packageStructure.pop();
                IFolder childFolder = targetContainer.getFolder((IPath)new Path(childName));
                if (!childFolder.exists()) {
                    childFolder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
                }
                targetContainer = childFolder;
            }
        }
        catch (CoreException e) {
            logger.warn((Object)("create folder failed" + targetContainer), (Throwable)e);
        }
        return targetContainer;
    }

    public EElement createNodeElement(String nodeType) {
        if (nodeType.equals(CLASS)) {
            return this.createClass(DEFAULT_CLASSNAME);
        }
        if (nodeType.equals(INTERFACE)) {
            return this.createInterface(DEFAULT_INTERFACENAME);
        }
        if (nodeType.equals(PACKAGE)) {
            return this.createPackage(DEFAULT_PACKAGENAME);
        }
        if (nodeType.equals(NOTE)) {
            return this.createNote();
        }
        throw new IllegalArgumentException("Illegal type for creation node.");
    }

    public EElement createConnectionEElement(String connectionType, DNode source, DNode target) {
        if (connectionType.equals(ASSOCIATION) || connectionType.startsWith(SELF_ASSOCIATION)) {
            return this.createAssociation(source, target);
        }
        if (connectionType.equals(NAVIGABLE_ASSOCIATION)) {
            return this.createNavigableAssociation(source, target);
        }
        if (connectionType.equals(AGGREGATE_ASSOCIATION)) {
            return this.createAggregateAssociation(source, target);
        }
        if (connectionType.equals(COMPOSITE_ASSOCIATION)) {
            return this.createCompositeAssociation(source, target);
        }
        if (connectionType.equals(GENERALIZATION)) {
            return this.createGeneralization(source, target);
        }
        if (connectionType.equals(ANCHOR)) {
            return this.createAnchor(source, target);
        }
        if (connectionType.equals(DEPENDENCY)) {
            return this.createDependency(source, target);
        }
        throw new IllegalArgumentException("Illegal connection type.");
    }

    public EElement createPackage(String name) {
        TPackage model = this.getTDocument().createPackage(name);
        return new EElement(model, (DElement)this.getDDocument().createNode(model.getId()));
    }

    public EElement createClass(String name) {
        TClass model = this.getTDocument().createClass(name);
        return new EElement(model, (DElement)this.getDDocument().createNode(model.getId()));
    }

    public EElement createInterface(String name) {
        TClass model = this.getTDocument().createInterface(name);
        return new EElement(model, (DElement)this.getDDocument().createNode(model.getId()));
    }

    public EElement createNote() {
        TNote model = this.getTDocument().createNote();
        return new EElement(model, (DElement)this.getDDocument().createNode(model.getId()));
    }

    public EElement createAssociation(DNode source, DNode target) {
        TAssociation model = this.getTDocument().createAssociation();
        DConnection connection = this.getDDocument().createConnection(model.getId(), source, target);
        return new EElement(model, (DElement)connection);
    }

    public EElement createNavigableAssociation(DNode source, DNode target) {
        TAssociation model = this.getTDocument().createNavigableAssociation();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createAggregateAssociation(DNode source, DNode target) {
        TAssociation model = this.getTDocument().createAggregateAssociation();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createCompositeAssociation(DNode source, DNode target) {
        TAssociation model = this.getTDocument().createCompositeAssociation();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createGeneralization(DNode source, DNode target) {
        TGeneralization model = this.getTDocument().createGeneralization();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createAnchor(DNode source, DNode target) {
        TAnchor model = this.getTDocument().createAnchor();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createDependency(DNode source, DNode target) {
        TAnchor model = this.getTDocument().createDependency();
        return new EElement(model, (DElement)this.getDDocument().createConnection(model.getId(), source, target));
    }

    public EElement createMuliplicity(DConnection connection) {
        TMultiplicity multiplicity = this.getTDocument().createMultiplicity();
        return new EElement(multiplicity, (DElement)this.getDDocument().createLabel(multiplicity.getId(), connection));
    }

    public EElement createRole(DConnection connection) {
        TRole role = this.getTDocument().createRole();
        return new EElement(role, (DElement)this.getDDocument().createLabel(role.getId(), connection));
    }

    public TStereoType getDefinedStereoType(String name) {
        return this.getDefinedStereoType(this.getTDocument(), name);
    }

    protected TStereoType getDefinedStereoType(TDocument document, String name) {
        List stereoTypes = document.getDefaultPackage().getOwnedElements(document.getModelCore().getTStereoTypeClass(), name);
        if (stereoTypes.size() != 1) {
            TStereoType stereoType = document.createStereoType(name);
            document.addOwnedElement(document.getDefaultPackage(), stereoType);
            return stereoType;
        }
        return (TStereoType)stereoTypes.get(0);
    }

    public void setOwnedPackage(IFile file) {
        IPath modelRootFolderPath = Trier.getInstance().getModelRootFolderPath(file);
        Stack<String> packageStructure = new Stack<String>();
        this.parentContainer = file.getParent();
        IContainer parent = file.getParent();
        while (!modelRootFolderPath.equals((Object)parent.getFullPath())) {
            packageStructure.push(parent.getName());
            parent = parent.getParent();
        }
        TPackage ownedPackage = this.getTDocument().getDefaultPackage();
        while (!packageStructure.isEmpty()) {
            String childName = (String)packageStructure.pop();
            List childElements = ownedPackage.getOwnedElements(childName);
            if (!childElements.isEmpty() && childElements.get(0) instanceof TPackage) {
                ownedPackage = (TPackage)childElements.get(0);
                continue;
            }
            TPackage childPackage = this.getTDocument().createPackage(childName);
            this.getTDocument().addOwnedElement(ownedPackage, childPackage);
            ownedPackage = childPackage;
        }
        this.ownedPackage = ownedPackage;
    }

    public int calculateNewNodeType(int oldType, int applyType, boolean isExclusion) {
        int newType;
        if (applyType < 4) {
            newType = oldType >> 2 << 2;
            newType += applyType;
        } else {
            newType = !isExclusion ? oldType | applyType : oldType & ~applyType;
        }
        return newType;
    }
}

