/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import trier.diagrameditor.EEditor;

public class EContextMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_SPEC = "diagrameditor.spec";
    public static final String GROUP_VIEW = "diagrameditor.view";
    public static final String GROUP_EDIT = "diagrameditor.edit";
    private ActionRegistry registry;

    public EContextMenuProvider(EditPartViewer viewer, EEditor editor) {
        super(viewer);
        this.registry = editor.getActionRegistry();
    }

    public void buildContextMenu(IMenuManager menu) {
        this.addStandardActionGroups(menu);
        this.addPropertyContributions(menu);
        this.addEditDomainContributions(menu);
        this.addEditPartViewerContributions(menu);
    }

    protected void addPropertyContributions(IMenuManager menu) {
        IAction action = this.registry.getAction((Object)"$property edit");
        if (action.isEnabled()) {
            menu.appendToGroup(GROUP_SPEC, action);
        }
        if ((action = this.registry.getAction((Object)"$diagram setting")).isEnabled()) {
            menu.appendToGroup(GROUP_SPEC, action);
        }
        if ((action = this.registry.getAction((Object)"goodsize")).isEnabled()) {
            menu.appendToGroup(GROUP_SPEC, action);
        }
    }

    protected void addEditDomainContributions(IMenuManager menu) {
        menu.appendToGroup(GROUP_EDIT, this.registry.getAction((Object)"undo"));
        menu.appendToGroup(GROUP_EDIT, this.registry.getAction((Object)"redo"));
        IAction action = this.registry.getAction((Object)"delete");
        if (action.isEnabled()) {
            menu.appendToGroup(GROUP_EDIT, action);
        }
        if ((action = this.registry.getAction((Object)"selectAll")).isEnabled()) {
            menu.appendToGroup(GROUP_EDIT, action);
        }
    }

    protected void addEditPartViewerContributions(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Alignment");
        IAction action = this.registry.getAction((Object)"org.eclipse.gef.align_left");
        if (action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_center")).isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_right")).isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_top")).isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_middle")).isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_bottom")).isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menu.appendToGroup(GROUP_VIEW, (IContributionItem)submenu);
        }
        submenu = new MenuManager("Even Interval");
        action = this.registry.getAction((Object)"$even interval horizonal");
        if (action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"$even interval vertical")).isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menu.appendToGroup(GROUP_VIEW, (IContributionItem)submenu);
        }
        submenu = new MenuManager("Line Type");
        action = this.registry.getAction((Object)"Normal");
        if (action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"Manhattan")).isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menu.appendToGroup(GROUP_VIEW, (IContributionItem)submenu);
        }
    }

    protected void addStandardActionGroups(IMenuManager menu) {
        this.addDeclaredActionGroups(menu);
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void addDeclaredActionGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_SPEC));
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        menu.add((IContributionItem)new Separator(GROUP_VIEW));
    }

    protected ActionRegistry getRegistry() {
        return this.registry;
    }

    protected void setRegistry(ActionRegistry registry) {
        this.registry = registry;
    }
}

