/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor;

import diagrammodelfw.model.DDocument;
import diagrammodelfw.serialization.DDocumentSerializer;
import java.util.EventObject;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectSerializer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import trier.Trier;
import trier.diagrameditor.DiagramEditorException;
import trier.diagrameditor.EDocumentSerializer;
import trier.diagrameditor.EKeyHandlerFactory;
import trier.diagrameditor.EScalableFreeformRootEditPart;
import trier.diagrameditor.action.EDeleteModelAction;
import trier.diagrameditor.action.EDiagramSettingAction;
import trier.diagrameditor.action.EEvenIntervalAction;
import trier.diagrameditor.action.EGoodSizeAction;
import trier.diagrameditor.action.ESelectAllAction;
import trier.diagrameditor.action.ESetLineTypeAction;
import trier.diagrameditor.action.ESpecEditAction;
import trier.diagrameditor.action.EStepMoveAction;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.svg.EExportSVGAction;
import trier.model.core.TDocument;

public abstract class EEditor
extends GraphicalEditorWithPalette
implements CommandStackListener {
    private static final Logger logger;
    private static boolean saving;
    private PaletteRoot palette;
    private KeyHandler keyHandler;
    private ContextMenuProvider contextMenuProvider;
    private boolean dirty = false;
    private ResourceTracker resourceTracker = new ResourceTracker();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.EEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        saving = false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setEditDomain(this.createEEditDomain());
        super.init(site, input);
    }

    public void dispose() {
        super.dispose();
        this.superSetInput(null);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)super.getGraphicalViewer();
        EScalableFreeformRootEditPart root = new EScalableFreeformRootEditPart();
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.getEEditDomain().getEditPartFactory());
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        ContextMenuProvider provider = this.getContextMenuProvider();
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(this.getContextMenuKey(), (MenuManager)provider, (ISelectionProvider)viewer);
        viewer.setKeyHandler(this.getKeyHandler().setParent((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)viewer)));
    }

    protected void initializeGraphicalViewer() {
        super.getGraphicalViewer().setContents((Object)this.getEEditDomain().getDocument());
        this.initializeDragTargetListener();
    }

    protected void initializeDragTargetListener() {
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ESpecEditAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EDeleteModelAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EDiagramSettingAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EDeleteModelAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EGoodSizeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ESetLineTypeAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ESetLineTypeAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 0);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 3);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EEvenIntervalAction((IWorkbenchPart)this, 0);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EEvenIntervalAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EExportSVGAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new ESelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    private void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, true);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            try {
                saving = true;
                EDocumentSerializer serializer = new EDocumentSerializer();
                serializer.saveObject((XMLObjectSerializer)new DDocumentSerializer(), this.getEEditDomain().getDocument().getDDocument(), this.getFile(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
                Trier.getInstance().saveDocument(this.getFile().getProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
                this.getCommandStack().markSaveLocation();
                this.setDirty(false);
            }
            catch (Exception ex) {
                throw new DiagramEditorException("exception caught in doSave()", ex);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            saving = false;
            throw throwable;
        }
        Object var3_6 = null;
        saving = false;
    }

    protected void doSaveAs(IPath path) {
    }

    public void doSaveAs() {
        throw new DiagramEditorException("you cannot save as");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        try {
            logger.info((Object)"EEditor#setInput() called:");
            this.superSetInput(input);
            EDocumentSerializer serializer = new EDocumentSerializer();
            DDocument ddoc = (DDocument)serializer.loadObject((XMLObjectSerializer)new DDocumentSerializer(), this.getFile(), ((Object)((Object)this)).getClass());
            TDocument tdoc = Trier.getInstance().getDocument(this.getFile().getProject(), ((Object)((Object)this)).getClass());
            this.getEEditDomain().setDocument(this.createEDocument(tdoc, ddoc));
        }
        catch (Exception ex) {
            throw new DiagramEditorException("exception caught in setInput()", ex);
        }
    }

    protected void superSetInput(IEditorInput input) {
        if (this.getEditorInput() != null) {
            this.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceTracker);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            this.getFile();
            this.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceTracker);
            this.setTitle(this.getFile().getName());
        }
    }

    protected abstract EDocument createEDocument(TDocument var1, DDocument var2);

    public boolean isDirty() {
        return this.dirty;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.setDirty(true);
    }

    private void setDirty(boolean dirty) {
        if (!this.dirty && dirty) {
            this.dirty = true;
            this.firePropertyChange(257);
        }
        if (this.dirty && !dirty) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.palette == null) {
            this.palette = this.createPaletteRoot();
        }
        return this.palette;
    }

    protected abstract String getContextMenuKey();

    protected ContextMenuProvider getContextMenuProvider() {
        if (this.contextMenuProvider == null) {
            this.contextMenuProvider = this.createContextMenuProvider();
        }
        return this.contextMenuProvider;
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = this.createKeyHandler();
        }
        return this.keyHandler;
    }

    protected void setKeyHandler(KeyHandler keyHandler) {
        this.keyHandler = keyHandler;
    }

    public EEditDomain getEEditDomain() {
        return (EEditDomain)super.getEditDomain();
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    protected DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    protected abstract EEditDomain createEEditDomain();

    protected abstract ContextMenuProvider createContextMenuProvider();

    protected abstract ContentOutlinePage createOutLinePage();

    protected abstract PaletteRoot createPaletteRoot();

    protected KeyHandler createKeyHandler() {
        return EKeyHandlerFactory.createKeyHandler(this);
    }

    public void gotoMarker(IMarker marker) {
        throw new RuntimeException("cannot use gotoMarker()");
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.ui.stackview.CommandStackInspectorPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.createOutLinePage();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    static /* synthetic */ void access$2(EEditor eEditor) {
        eEditor.closeEditor();
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (saving) {
                return;
            }
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            logger.debug((Object)("Path: " + delta.getResource().getProjectRelativePath().toString()));
            logger.debug((Object)("Type: " + delta.getResource().getType()));
            if (delta == null) {
                return true;
            }
            if (delta.getResource() != null && EEditor.this.getFile().getProject().equals((Object)delta.getResource().getProject())) {
                if (delta.getKind() == 4) {
                    if (delta.getResource().equals((Object)EEditor.this.getFile())) {
                        logger.info((Object)("EditorFile changed: " + EEditor.this.getFile().getProject()));
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ ResourceTracker this$1;
                            {
                                this.this$1 = resourceTracker;
                            }

                            public void run() {
                                try {
                                    ResourceTracker.access$0(this.this$1);
                                }
                                catch (Exception ex) {
                                    EEditor.access$1().warn((Object)"Ex occured reading EditorFile", (Throwable)ex);
                                }
                            }
                        });
                    } else if (delta.getResource().getName().equals("modeldb.xml")) {
                        logger.info((Object)("modelDB changed: " + EEditor.this.getFile().getProject()));
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ ResourceTracker this$1;
                            {
                                this.this$1 = resourceTracker;
                            }

                            public void run() {
                                try {
                                    ResourceTracker.access$1(this.this$1);
                                    ResourceTracker.access$0(this.this$1);
                                }
                                catch (Exception ex) {
                                    EEditor.access$1().warn((Object)"Ex occured reading modelDB", (Throwable)ex);
                                }
                            }
                        });
                    }
                } else if (delta.getKind() == 2 && delta.getResource().getFullPath().equals((Object)EEditor.this.getFile().getFullPath())) {
                    logger.info((Object)("editing file remove: " + EEditor.this.getFile()));
                    Display.getDefault().asyncExec(new Runnable(this, delta){
                        final /* synthetic */ ResourceTracker this$1;
                        private final /* synthetic */ IResourceDelta val$delta;
                        {
                            this.this$1 = resourceTracker;
                            this.val$delta = iResourceDelta;
                        }

                        public void run() {
                            try {
                                if (this.val$delta.getMovedToPath() != null) {
                                    ResourceTracker.access$2(this.this$1).superSetInput((IEditorInput)new FileEditorInput(ResourceTracker.access$2(this.this$1).getFile().getProject().getParent().getFile(this.val$delta.getMovedToPath())));
                                } else {
                                    EEditor.access$2(ResourceTracker.access$2(this.this$1));
                                }
                            }
                            catch (Exception ex) {
                                EEditor.access$1().warn((Object)"Ex occured reopen file", (Throwable)ex);
                            }
                        }
                    });
                }
            }
            return true;
        }

        private void reloadModelDB() {
            if (EEditor.this.getEditorInput() == null) {
                return;
            }
            try {
                logger.info((Object)("ModelDB reloading..." + EEditor.this.getFile().getProject()));
                Trier.getInstance().getModelDBFile(EEditor.this.getFile().getProject());
                TDocument tDocument = this.prepareTDocument();
                EEditor.this.getEEditDomain().setDocument(EEditor.this.createEDocument(tDocument, EEditor.this.getEEditDomain().getDocument().getDDocument()));
                this.initializeRootAndContents();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void reloadEditorFile() {
            if (EEditor.this.getEditorInput() == null) {
                return;
            }
            logger.info((Object)("EditorFile reloading..." + EEditor.this.getFile()));
            TDocument tDocument = Trier.getInstance().getDocument(EEditor.this.getFile().getProject(), this.getClass());
            EDocumentSerializer serializer = new EDocumentSerializer();
            DDocument ddoc = (DDocument)serializer.loadObject((XMLObjectSerializer)new DDocumentSerializer(), EEditor.this.getFile(), this.getClass());
            EEditor.this.getEEditDomain().setDocument(EEditor.this.createEDocument(tDocument, ddoc));
            this.initializeRootAndContents();
        }

        private void initializeRootAndContents() {
            ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)EEditor.this.getGraphicalViewer();
            try {
                EEditor.this.getGraphicalViewer().deselectAll();
                viewer.setRootEditPart(null);
            }
            catch (Exception exception) {}
            EScalableFreeformRootEditPart root = new EScalableFreeformRootEditPart();
            viewer.setRootEditPart((RootEditPart)root);
            EEditor.this.getGraphicalViewer().setContents((Object)EEditor.this.getEEditDomain().getDocument());
        }

        private TDocument prepareTDocument() {
            TDocument tdoc = Trier.getInstance().getDocument(EEditor.this.getFile().getProject(), this.getClass());
            if (tdoc == EEditor.this.getEEditDomain().getDocument().getTDocument()) {
                tdoc = Trier.getInstance().recreateDocument(EEditor.this.getFile().getProject(), this.getClass());
            }
            return tdoc;
        }

        static /* synthetic */ void access$0(ResourceTracker resourceTracker) {
            resourceTracker.reloadEditorFile();
        }

        static /* synthetic */ void access$1(ResourceTracker resourceTracker) {
            resourceTracker.reloadModelDB();
        }

        static /* synthetic */ EEditor access$2(ResourceTracker resourceTracker) {
            return resourceTracker.EEditor.this;
        }
    }
}

