/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.action;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class EEvenIntervalAction
extends SelectionAction {
    public static final int HORIZONAL = 0;
    public static final int VERTICAL = 1;
    public static final String ID_HORIZONAL = "$even interval horizonal";
    public static final String ID_VERTICAL = "$even interval vertical";
    public static final String[] labels = new String[]{"Horizonal", "Vertical"};
    public static final String[] ids = new String[]{"$even interval horizonal", "$even interval vertical"};
    private static final Comparator[] comparators = new Comparator[]{new LocationComparator(0), new LocationComparator(1)};
    private ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
    private int direction;

    public EEvenIntervalAction(IWorkbenchPart part, int direction) {
        super(part);
        this.direction = direction;
        this.initialize();
    }

    protected void init() {
        super.init();
    }

    private void initialize() {
        this.setId(ids[this.direction]);
        this.setText(labels[this.direction]);
        this.setToolTipText(labels[this.direction]);
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() < 3) {
            return false;
        }
        Iterator i = this.getSelectedObjects().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof EditPart)) {
                return false;
            }
            if (((EditPart)o).understandsRequest((Request)this.request)) continue;
            return false;
        }
        return true;
    }

    public void run() {
        this.execute(this.createMoveCommand());
    }

    protected Command createMoveCommand() {
        try {
            int max;
            int min;
            CompoundCommand commands = new CompoundCommand();
            List selectedObjects = this.getSelectedObjects();
            Collections.sort(selectedObjects, comparators[this.direction]);
            LinkedList internalObjects = new LinkedList(selectedObjects);
            Object firstObject = internalObjects.removeFirst();
            Object lastObject = internalObjects.removeLast();
            int internalLength = this.calcurateLength(internalObjects);
            int intervalCount = selectedObjects.size() - 2 + 1;
            if (this.direction == 0) {
                min = EEvenIntervalAction.getBounds(firstObject).getRight().x;
                max = EEvenIntervalAction.getBounds(lastObject).getLeft().x;
            } else {
                min = EEvenIntervalAction.getBounds(firstObject).getBottom().y;
                max = EEvenIntervalAction.getBounds(lastObject).getTop().y;
            }
            int interval = (max - min - internalLength) / intervalCount;
            int current = min;
            int i = 0;
            while (i < internalObjects.size()) {
                int move;
                EditPart editpart = (EditPart)internalObjects.get(i);
                current += interval;
                if (this.direction == 0) {
                    move = current - EEvenIntervalAction.getBounds((Object)editpart).x;
                    this.request.setMoveDelta(new Point(move, 0));
                    current += EEvenIntervalAction.getBounds((Object)editpart).width;
                } else {
                    move = current - EEvenIntervalAction.getBounds((Object)editpart).y;
                    this.request.setMoveDelta(new Point(0, move));
                    current += EEvenIntervalAction.getBounds((Object)editpart).height;
                }
                Command command = editpart.getCommand((Request)this.request);
                commands.add(command);
                ++i;
            }
            return commands;
        }
        catch (ClassCastException classCastException) {
            Display.getCurrent().beep();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Display.getCurrent().beep();
        }
        return null;
    }

    private int calcurateLength(List internalEditparts) {
        int length = 0;
        Iterator i = internalEditparts.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (this.direction == 0) {
                length += EEvenIntervalAction.getBounds(o).width;
                continue;
            }
            length += EEvenIntervalAction.getBounds(o).height;
        }
        return length;
    }

    private static Rectangle getBounds(Object o) {
        GraphicalEditPart part = (GraphicalEditPart)o;
        IFigure fig = part.getFigure();
        return fig.getBounds();
    }

    static class LocationComparator
    implements Comparator {
        private int direction;

        LocationComparator(int direction) {
            this.direction = direction;
        }

        public int compare(Object o1, Object o2) {
            Point loc1 = EEvenIntervalAction.getBounds(o1).getCenter();
            Point loc2 = EEvenIntervalAction.getBounds(o2).getCenter();
            if (this.direction == 0) {
                return loc1.x - loc2.x;
            }
            return loc1.y - loc2.y;
        }
    }
}

