/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.action;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class EStepMoveAction
extends SelectionAction {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    public static final String ID_RIGHT = "$stepmove right";
    public static final String ID_LEFT = "$stepmove left";
    public static final String ID_UP = "$stepmove up";
    public static final String ID_DOWN = "$stepmove down";
    private static final String[] labels = new String[]{"Right", "Left", "Up", "Down"};
    private static final String[] ids = new String[]{"$stepmove right", "$stepmove left", "$stepmove up", "$stepmove down"};
    private static final Point[] deltas = new Point[]{new Point(1, 0), new Point(-1, 0), new Point(0, -1), new Point(0, 1)};
    private ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
    private int direction;

    public EStepMoveAction(IWorkbenchPart part, int direction) {
        super(part);
        this.direction = direction;
        this.initialize();
    }

    protected void init() {
        super.init();
    }

    private void initialize() {
        this.setId(ids[this.direction]);
        this.setText(labels[this.direction]);
        this.setToolTipText(labels[this.direction]);
        this.request.setMoveDelta(deltas[this.direction]);
    }

    protected boolean calculateEnabled() {
        try {
            return this.createMoveCommand().canExecute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected Command createMoveCommand() {
        CompoundCommand commands = new CompoundCommand();
        Iterator i = this.getSelectedObjects().iterator();
        while (i.hasNext()) {
            EditPart part;
            Command command;
            Object object = i.next();
            if (!(object instanceof EditPart) || (command = (part = (EditPart)object).getCommand((Request)this.request)) == null || !command.canExecute()) continue;
            commands.add(command);
        }
        return commands;
    }

    public void run() {
        this.execute(this.createMoveCommand());
    }
}

