/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.dnd;

import diagrammodelfw.model.DNode;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import trier.diagrameditor.dnd.TElementDropRequest;
import trier.diagrameditor.dnd.TElementTransfer;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.core.TElement;

public abstract class TElementTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public TElementTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TElementTransfer.getInstance());
    }

    protected void updateTargetRequest() {
        this.getTargetRequest().setType((Object)"selection");
        ((TElementDropRequest)this.getTargetRequest()).setData(this.getCurrentEvent().data);
        ((TElementDropRequest)this.getTargetRequest()).setLocation(new Point(this.getCurrentEvent().x, this.getCurrentEvent().y));
    }

    protected Command getCommand() {
        Rectangle r = new Rectangle(this.getCurrentEvent().x, this.getCurrentEvent().y, this.getDefaultWidth(), this.getDefaultHeight());
        List treeEditParts = (List)this.getCurrentEvent().data;
        CompoundCommand commands = new CompoundCommand();
        Iterator i = treeEditParts.iterator();
        while (i.hasNext()) {
            TElement tElement = (TElement)((TreeEditPart)i.next()).getModel();
            EElement element = this.getEEditDomain().getDocument().createNodeElement(tElement);
            commands.add((Command)this.createAddEElementCommand(this.getConstraintFor(r), element));
            this.getEEditDomain().getEditPartFactory().createEditPart(this.getTargetEditPart(), (Object)element);
            Command referedElementsCommand = this.createAddEConnectionElementCommand(element);
            if (!referedElementsCommand.canExecute()) continue;
            commands.add(referedElementsCommand);
        }
        return commands;
    }

    protected int getDefaultHeight() {
        return 100;
    }

    protected int getDefaultWidth() {
        return 140;
    }

    protected CompoundCommand createAddEElementCommand(Rectangle r, EElement element) {
        CompoundCommand addEElementCommands = new CompoundCommand();
        addEElementCommands.add(this.getEEditDomain().createAddEElementCommand(element));
        addEElementCommands.add(this.getEEditDomain().getDCommandFactory().createSetSizeCommand((DNode)element.getDModel(), r.getSize()));
        addEElementCommands.add(this.getEEditDomain().getDCommandFactory().createSetLocationCommand((DNode)element.getDModel(), r.getLocation()));
        addEElementCommands.add(this.getEEditDomain().getDCommandFactory().createSetNodeTypeCommand((DNode)element.getDModel(), this.getEEditDomain().getDocument().getDDocument().getNodeType()));
        return addEElementCommands;
    }

    protected abstract Command createAddEConnectionElementCommand(EElement var1);

    protected Rectangle getConstraintFor(Rectangle absolute) {
        EditPart editPart = this.getTargetEditPart();
        org.eclipse.swt.graphics.Point location = editPart.getViewer().getControl().toControl(absolute.x, absolute.y);
        Dimension size = absolute.getSize();
        Rectangle r = new Rectangle(location.x, location.y, size.width, size.height);
        return r.setLocation(r.x - r.width / 2, r.y - r.height / 2);
    }

    protected Request createTargetRequest() {
        TElementDropRequest request = new TElementDropRequest();
        request.setEditParts((List)TemplateTransfer.getInstance().getObject());
        return request;
    }

    protected EEditDomain getEEditDomain() {
        return (EEditDomain)this.getViewer().getEditDomain();
    }

    public boolean isEnabled(DropTargetEvent event) {
        List treeEditParts = (List)TElementTransfer.getInstance().getObject();
        if (treeEditParts != null) {
            Iterator i = treeEditParts.iterator();
            while (i.hasNext()) {
                TElement tElement = (TElement)((TreeEditPart)i.next()).getModel();
                if (this.getEEditDomain().getDocument().getElementsByTElement(tElement).isEmpty()) continue;
                return false;
            }
        }
        return super.isEnabled(event);
    }
}

