/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.edit.property;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.edit.property.EStateChangeListener;
import trier.diagrameditor.model.ECommand;
import trier.model.command.TCommand;
import trier.model.command.TCommandFactory;
import trier.model.core.TDocument;
import trier.model.core.TElement;

public abstract class EEditComposite {
    private EEditDialog parentDialog;
    private EStateChangeListener stateChangeHandler;

    public EEditComposite(EEditDialog dialog) {
        this.parentDialog = dialog;
    }

    public void addEStateChangeListener(EStateChangeListener listener) {
        this.stateChangeHandler = listener;
    }

    public TCommandFactory getTCommandFactory() {
        return this.parentDialog.getEEditDomain().getTCommandFactory();
    }

    public TDocument getTDocument() {
        return this.parentDialog.getTDocument();
    }

    public EEditDialog getParentDialog() {
        return this.parentDialog;
    }

    public TElement getTElement() {
        return this.parentDialog.getTModel();
    }

    protected void executeCommand(TCommand command) {
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.add((Command)new ECommand(command));
        this.executeCommands((Command)compoundCommand);
    }

    protected void executeCommands(Command command) {
        this.parentDialog.executeCommand(command);
    }

    public void stateChanged() {
        if (this.stateChangeHandler != null) {
            this.stateChangeHandler.stateChanged();
        }
    }
}

