/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.editpart;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import trier.TrierPlugin;
import trier.diagrameditor.EEditor;
import trier.diagrameditor.editpart.EElementEditPart;
import trier.diagrameditor.figure.ENodeFigure;
import trier.diagrameditor.model.EElement;

public abstract class ENodeEditPart
extends EElementEditPart
implements NodeEditPart {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.editpart.ENodeEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DNode getDNode() {
        return (DNode)super.getDElement();
    }

    public ENodeFigure getNodeFigure() {
        return (ENodeFigure)this.getFigure();
    }

    protected List getModelSourceConnections() {
        List sources = this.getDNode().getSourceConnections();
        return this.getDocument().getElementsByDElements(sources);
    }

    protected List getModelTargetConnections() {
        List targets = this.getDNode().getTargetConnections();
        return this.getDocument().getElementsByDElements(targets);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        DConnection conn = (DConnection)((EElement)connEditPart.getModel()).getDModel();
        if (!$assertionsDisabled && !this.getDNode().getSourceConnections().contains(conn)) {
            throw new AssertionError();
        }
        return this.getNodeFigure().getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        DConnection conn = (DConnection)((EElement)connEditPart.getModel()).getDModel();
        if (!$assertionsDisabled && !this.getDNode().getTargetConnections().contains(conn)) {
            throw new AssertionError();
        }
        return this.getNodeFigure().getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request arg0) {
        return this.getNodeFigure().getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request arg0) {
        return this.getNodeFigure().getConnectionAnchor();
    }

    protected ConnectionEditPart createConnection(Object model) {
        DElement dElement = ((EElement)model).getDModel();
        if (!$assertionsDisabled && !(dElement instanceof DConnection)) {
            throw new AssertionError();
        }
        ConnectionEditPart editpart = (ConnectionEditPart)this.getEditDomain().getEditPartFactory().createEditPart((EditPart)this, model);
        return editpart;
    }

    public boolean understandsRequest(Request request) {
        if (request.getType().equals("$delete model")) {
            return true;
        }
        if (request.getType().equals("$goodsize") && this.getDElement() instanceof DNode) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (request.getType().equals("property edit")) {
            this.showPropertyEditor();
        } else if (request.getType().equals("$delete model")) {
            this.deleteFromModel();
        } else if (request.getType().equals("$goodsize")) {
            this.goodSize();
        } else {
            super.performRequest(request);
        }
    }

    protected void deleteFromModel() {
        IEditorReference[] editors = TrierPlugin.getDefault().getActivePage().getEditorReferences();
        CompoundCommand commands = new CompoundCommand();
        int i = 0;
        while (i < editors.length) {
            EEditor cdEditor;
            IEditorPart editorPart = editors[i].getEditor(false);
            if (editorPart instanceof EEditor && !(cdEditor = (EEditor)editorPart).getEEditDomain().getDocument().getElementsByTElement(this.getElement().getTModel()).isEmpty()) {
                Command command = cdEditor.getEEditDomain().createRemoveEElementFromModelCommand(this.getElement().getTModel());
                commands.add(command);
            }
            ++i;
        }
        if (!commands.isEmpty()) {
            this.getEditDomain().getCommandStack().execute((Command)commands);
        }
    }

    private void goodSize() {
        Dimension d = this.getFigure().getPreferredSize();
        Command command = this.getEditDomain().getDCommandFactory().createSetSizeCommand(this.getDNode(), d);
        this.getEditDomain().getCommandStack().execute(command);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("sourceConnections")) {
            this.refreshSourceConnections();
        } else if (evt.getPropertyName().equals("targetConnections")) {
            this.refreshTargetConnections();
        } else if (evt.getPropertyName().equals("bounds")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("TModelElement changed")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("node type")) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Rectangle r = this.getDNode().getBounds();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }
}

