/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.model;

import org.eclipse.gef.commands.Command;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EElement;

public class ECommandFactory {
    private EDocument document;

    public ECommandFactory(EDocument document) {
        this.document = document;
    }

    public Command createAddEElementCommand(EElement eElement) {
        return new AddEElementCommand(eElement);
    }

    public Command createRemoveEElementCommand(EElement eElement) {
        return new RemoveEElementCommand(eElement);
    }

    private class AddEElementCommand
    extends Command {
        private EElement element = null;

        AddEElementCommand(EElement element) {
            this.element = element;
        }

        public void execute() {
            ECommandFactory.this.document.addEElement(this.element);
        }

        public void undo() {
            ECommandFactory.this.document.removeEElement(this.element);
        }
    }

    private class RemoveEElementCommand
    extends Command {
        private EElement element = null;

        public RemoveEElementCommand(EElement element) {
            this.element = element;
        }

        public void execute() {
            ECommandFactory.this.document.removeEElement(this.element);
        }

        public void undo() {
            ECommandFactory.this.document.addEElement(this.element);
        }
    }
}

