/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.model;

import diagrammodelfw.command.DCommandFactory;
import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DDocument;
import diagrammodelfw.model.DNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;
import trier.diagrameditor.figure.EConnectionFigureFactory;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.ECommandFactory;
import trier.diagrameditor.model.EDocument;
import trier.diagrameditor.model.EElement;
import trier.model.command.TCommandFactory;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TNamespace;

public abstract class EEditDomain
extends DefaultEditDomain {
    private EDocument document = null;
    private ECommandFactory eCommandFactory;
    private DCommandFactory dCommandFactory;
    private TCommandFactory tCommandFactory;
    private EConnectionFigureFactory connectionFigureFactory;
    private EditPartFactory editPartFactory;

    public EEditDomain(IEditorPart editorPart) {
        super(editorPart);
        this.initializeFactories();
    }

    private void initializeFactories() {
        this.connectionFigureFactory = this.createConnectionFigureFactory();
        this.editPartFactory = this.createEditPartFactory();
    }

    public EDocument getDocument() {
        return this.document;
    }

    public void setDocument(EDocument document) {
        this.document = document;
        this.initializeCommandFactories();
    }

    protected void initializeCommandFactories() {
        TDocument tDocument = this.getDocument().getTDocument();
        this.tCommandFactory = new TCommandFactory(tDocument);
        DDocument dDocument = this.getDocument().getDDocument();
        this.dCommandFactory = new DCommandFactory(dDocument);
        this.eCommandFactory = new ECommandFactory(this.getDocument());
    }

    public DCommandFactory getDCommandFactory() {
        return this.dCommandFactory;
    }

    public ECommandFactory getECommandFactory() {
        return this.eCommandFactory;
    }

    public TCommandFactory getTCommandFactory() {
        return this.tCommandFactory;
    }

    public EditPartFactory getEditPartFactory() {
        return this.editPartFactory;
    }

    public abstract EditPartFactory createEditPartFactory();

    public EConnectionFigureFactory getConnectionFigureFactory() {
        return this.connectionFigureFactory;
    }

    public abstract EConnectionFigureFactory createConnectionFigureFactory();

    public Command createAddEElementCommand(TElement parent, EElement child) {
        CompoundCommand commands = new CompoundCommand();
        commands.add((Command)new ECommand(this.tCommandFactory.createAddTElementCommand(parent, child.getTModel())));
        commands.add(this.eCommandFactory.createAddEElementCommand(child));
        commands.add(this.dCommandFactory.createAddElementCommand(child.getDModel()));
        return commands;
    }

    public Command createAddEElementCommand(EElement element) {
        CompoundCommand commands = new CompoundCommand();
        commands.add(this.eCommandFactory.createAddEElementCommand(element));
        commands.add(this.dCommandFactory.createAddElementCommand(element.getDModel()));
        return commands;
    }

    public Command createRemoveEElementFromModelCommand(TElement element) {
        EElement eElement;
        CompoundCommand commands = new CompoundCommand();
        List removeEElements = this.getDocument().getElementsByTElement(element);
        Iterator i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            if (!(eElement.getDModel() instanceof DNode)) continue;
            DNode node = (DNode)eElement.getDModel();
            HashSet connections = new HashSet();
            connections.addAll(node.getSourceConnections());
            connections.addAll(node.getTargetConnections());
            this.createRemoveAllElementsFromModelCommand(commands, connections);
        }
        i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            if (!(eElement.getDModel() instanceof DConnection)) continue;
            DConnection connection = (DConnection)eElement.getDModel();
            this.createRemoveAllElementsFromModelCommand(commands, connection.getLabels());
        }
        i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            commands.add(this.dCommandFactory.createRemoveElementCommand(eElement.getDModel()));
            commands.add(this.eCommandFactory.createRemoveEElementCommand(eElement));
        }
        if (!element.isRemoved()) {
            commands.add((Command)new ECommand(this.tCommandFactory.createRemoveTElementCommand(element)));
        }
        return commands;
    }

    public Command createRemoveEElementCommand(EElement element) {
        EElement eElement;
        CompoundCommand commands = new CompoundCommand();
        List removeEElements = this.getDocument().getElementsByTElement(element.getTModel());
        Iterator i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            if (!(eElement.getDModel() instanceof DNode)) continue;
            DNode node = (DNode)eElement.getDModel();
            HashSet connections = new HashSet();
            connections.addAll(node.getSourceConnections());
            connections.addAll(node.getTargetConnections());
            this.createRemoveAllElementsCommand(commands, connections);
        }
        i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            if (!(eElement.getDModel() instanceof DConnection)) continue;
            DConnection connection = (DConnection)eElement.getDModel();
            this.createRemoveAllElementsCommand(commands, connection.getLabels());
        }
        i = removeEElements.iterator();
        while (i.hasNext()) {
            eElement = (EElement)i.next();
            commands.add(this.dCommandFactory.createRemoveElementCommand(eElement.getDModel()));
            commands.add(this.eCommandFactory.createRemoveEElementCommand(element));
        }
        return commands;
    }

    private void createRemoveAllElementsFromModelCommand(CompoundCommand commands, Collection dElements) {
        List eElements = this.getDocument().getElementsByDElements(dElements);
        Iterator i = eElements.iterator();
        while (i.hasNext()) {
            EElement eElement = (EElement)i.next();
            commands.add(this.createRemoveEElementFromModelCommand(eElement.getTModel()));
        }
    }

    private void createRemoveAllElementsCommand(CompoundCommand commands, Collection dElements) {
        List eElements = this.getDocument().getElementsByDElements(dElements);
        Iterator i = eElements.iterator();
        while (i.hasNext()) {
            EElement eElement = (EElement)i.next();
            commands.add(this.createRemoveEElementCommand(eElement));
        }
    }

    public Command createConnectCommand(TNamespace namespace, EElement connection, EElement source, EElement target) {
        CompoundCommand commands = new CompoundCommand();
        DConnection dConnection = (DConnection)connection.getDModel();
        commands.add(this.dCommandFactory.createReconnectConnectionCommand(dConnection, (DNode)source.getDModel(), (DNode)target.getDModel()));
        commands.add((Command)new ECommand(this.tCommandFactory.createRelateCommand(namespace, connection.getTModel(), source.getTModel(), target.getTModel())));
        return commands;
    }

    public Command createReconnectSourceCommand(EElement connection, EElement source) {
        CompoundCommand commands = new CompoundCommand();
        commands.add((Command)new ECommand(this.tCommandFactory.createReconnectSourceCommand(connection.getTModel(), source.getTModel())));
        DConnection dConnection = (DConnection)connection.getDModel();
        commands.add(this.dCommandFactory.createReconnectConnectionCommand(dConnection, (DNode)source.getDModel(), dConnection.getTarget()));
        return commands;
    }

    public Command createReconnectTargetCommand(EElement connection, EElement target) {
        CompoundCommand commands = new CompoundCommand();
        commands.add((Command)new ECommand(this.tCommandFactory.createReconnectTargetCommand(connection.getTModel(), target.getTModel())));
        DConnection dConnection = (DConnection)connection.getDModel();
        commands.add(this.dCommandFactory.createReconnectConnectionCommand(dConnection, dConnection.getSource(), (DNode)target.getDModel()));
        return commands;
    }

    protected void setDCommandFactory(DCommandFactory factory) {
        this.dCommandFactory = factory;
    }

    protected void setECommandFactory(ECommandFactory factory) {
        this.eCommandFactory = factory;
    }

    protected void setTCommandFactory(TCommandFactory factory) {
        this.tCommandFactory = factory;
    }
}

