/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.svg;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import trier.diagrameditor.svg.GraphicsState;

public class AdaptAWTGraphics
extends Graphics {
    private static final Logger logger;
    private static final AffineTransformOp OP;
    private Graphics2D g;
    private Stack stack = new Stack();
    private Map images = new HashMap();
    private GraphicsState currentState = new GraphicsState();
    private java.awt.Color backupColor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.diagrameditor.svg.AdaptAWTGraphics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        OP = new AffineTransformOp(new AffineTransform(), 1);
    }

    public AdaptAWTGraphics(Graphics2D g) {
        this.g = g;
        this.pushState();
    }

    public void clipRect(Rectangle r) {
        logger.debug((Object)r);
        this.currentState.setClip(r);
        this.updateGraphics();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        logger.debug((Object)("x1=" + x1 + ", y1=" + y1 + ", x2=" + x2 + ", y2=" + y2));
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + width + ", height=" + height));
        this.g.drawRect(x, y, width, height);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + width + ", height=" + height));
        this.prepareBgColor();
        this.g.fillRect(x, y, width, height);
        this.restoreBgColor();
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        logger.debug((Object)("r=" + r + ", arcWidth=" + arcWidth + ", arcHeight=" + arcHeight));
        this.g.drawRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        logger.debug((Object)("r=" + r + ", arcWidth=" + arcWidth + ", arcHeight=" + arcHeight));
        this.prepareBgColor();
        this.g.fillRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
        this.restoreBgColor();
    }

    public void drawOval(int x, int y, int w, int h) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + w + ", height=" + h));
        this.g.drawOval(x, y, w, h);
    }

    public void fillOval(int x, int y, int w, int h) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + w + ", height=" + h));
        this.prepareBgColor();
        this.g.fillOval(x, y, w, h);
        this.restoreBgColor();
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + w + ", height=" + h));
        this.g.drawArc(x, y, w, h, offset, length);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        logger.debug((Object)("x=" + x + ", y=" + y + ", width=" + w + ", height=" + h));
        this.prepareBgColor();
        this.g.drawArc(x, y, w, h, offset, length);
        this.restoreBgColor();
    }

    public void drawPolygon(PointList points) {
        int size = points.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        this.toPointArray(points, xPoints, yPoints);
        this.g.drawPolygon(xPoints, yPoints, size);
    }

    public void drawPolyline(PointList points) {
        int size = points.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        this.toPointArray(points, xPoints, yPoints);
        this.g.drawPolyline(xPoints, yPoints, size);
    }

    public void fillPolygon(PointList points) {
        int size = points.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        this.prepareBgColor();
        this.toPointArray(points, xPoints, yPoints);
        this.g.fillPolygon(xPoints, yPoints, size);
        this.restoreBgColor();
    }

    public void drawString(String s, int x, int y) {
        logger.debug((Object)("text=" + s + ", x=" + x + ", y=" + y));
        this.g.drawString(s, x, y += (int)((double)this.g.getFont().getSize() / 3.0 * 2.0));
    }

    public void drawText(String s, int x, int y) {
        logger.debug((Object)("text=" + s + ", x=" + x + ", y=" + y));
        this.drawString(s, x, y);
    }

    public void fillString(String s, int x, int y) {
        logger.debug((Object)("text=" + s + ", x=" + x + ", y=" + y));
        this.drawString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        logger.debug((Object)("text=" + s + ", x=" + x + ", y=" + y));
        this.drawString(s, x, y);
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        logger.debug((Object)("srcImage=" + srcImage));
        BufferedImage dstImage = this.getImage(srcImage);
        dstImage = dstImage.getSubimage(sx, sy, sw, sh);
        OP.getTransform().setToIdentity();
        double xx = (double)dw / (double)sw;
        double yy = (double)dh / (double)sh;
        OP.getTransform().scale(xx, yy);
        this.g.drawImage(dstImage, OP, dx, dy);
    }

    public void drawImage(Image srcImage, int x, int y) {
        int rw = srcImage.getBounds().width;
        int rh = srcImage.getBounds().height;
        this.drawImage(srcImage, 0, 0, rw, rh, x, y, rw, rh);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        logger.warn((Object)"not implemented.");
    }

    public void drawFocus(int x, int y, int w, int h) {
        logger.warn((Object)"not implemented.");
    }

    public Rectangle getClip(Rectangle rect) {
        logger.debug((Object)rect);
        logger.debug((Object)this.currentState.getClip());
        rect.setBounds(this.currentState.getClip());
        return rect;
    }

    public void setClip(Rectangle r) {
        logger.debug((Object)("r=" + r));
        this.currentState.setClip(r);
        this.updateGraphics();
    }

    public Color getForegroundColor() {
        logger.debug((Object)"");
        return this.toSWTColor(this.g.getColor());
    }

    public void setForegroundColor(Color rgb) {
        logger.debug((Object)rgb);
        this.currentState.setFgColor(rgb);
        this.updateGraphics();
    }

    public Color getBackgroundColor() {
        logger.debug((Object)"");
        return this.toSWTColor(this.g.getColor());
    }

    public void setBackgroundColor(Color rgb) {
        logger.debug((Object)rgb);
        this.currentState.setBgColor(rgb);
        this.updateGraphics();
    }

    public FontMetrics getFontMetrics() {
        logger.warn((Object)"not implemented.");
        return null;
    }

    public org.eclipse.swt.graphics.Font getFont() {
        logger.debug((Object)"");
        return this.currentState.getFont();
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
        logger.debug((Object)font);
        this.currentState.setFont(font);
        this.updateGraphics();
    }

    public int getLineStyle() {
        logger.debug((Object)"");
        return this.currentState.getLineStyle();
    }

    public void setLineStyle(int style) {
        logger.debug((Object)("style=" + style));
        this.currentState.setLineStyle(style);
        this.updateGraphics();
    }

    public int getLineWidth() {
        logger.debug((Object)"");
        return this.currentState.getLineStyle();
    }

    public void setLineWidth(int width) {
        logger.debug((Object)("width=" + width));
        this.currentState.setLineWidth(width);
        this.updateGraphics();
    }

    public boolean getXORMode() {
        logger.debug((Object)"");
        return this.currentState.isXORMode();
    }

    public void setXORMode(boolean b) {
        logger.debug((Object)("mode =" + b));
        this.currentState.setXORMode(b);
        this.updateGraphics();
    }

    public void popState() {
        logger.debug((Object)"");
        this.stack.pop();
        this.restoreState();
    }

    public void pushState() {
        logger.debug((Object)"");
        this.stack.push(new GraphicsState(this.currentState));
    }

    public void restoreState() {
        logger.debug((Object)"");
        this.currentState = new GraphicsState(this.peekState());
        this.updateGraphics();
    }

    private GraphicsState peekState() {
        return (GraphicsState)this.stack.peek();
    }

    private void updateGraphics() {
        logger.debug((Object)this.currentState);
        this.g.setColor(this.toAWTColor(this.currentState.getFgColor()));
        this.g.setBackground(this.toAWTColor(this.currentState.getBgColor()));
        this.g.setStroke(this.currentState.getStroke());
        this.g.setFont(this.toAWTFont(this.currentState.getFont()));
    }

    public void scale(double amount) {
        logger.debug((Object)("amount=" + amount));
        this.g.scale(amount, amount);
    }

    public void translate(int dx, int dy) {
        logger.debug((Object)("dx=" + dx + ", dy=" + dy));
        this.g.translate(dx, dy);
    }

    public void dispose() {
        this.g.dispose();
    }

    private java.awt.Color toAWTColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        java.awt.Color c = new java.awt.Color(r, g, b);
        return c;
    }

    private Color toSWTColor(java.awt.Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        Color c = new Color(null, r, g, b);
        return c;
    }

    private java.awt.Rectangle toAWTRectangle(Rectangle rectangle) {
        int x = rectangle.x;
        int y = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        java.awt.Rectangle r = new java.awt.Rectangle(x, y, w, h);
        return r;
    }

    private Rectangle toSWTRectangle(java.awt.Rectangle rectangle) {
        int x = rectangle.x;
        int y = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        Rectangle r = new Rectangle(x, y, w, h);
        return r;
    }

    private Font toAWTFont(org.eclipse.swt.graphics.Font f) {
        String name = f.getFontData()[0].getName();
        int height = (int)((double)f.getFontData()[0].getHeight() / 2.0 * 3.0);
        int style = this.toAWTFontStyle(f.getFontData()[0].getStyle());
        return new Font(name, style, height);
    }

    private int toAWTFontStyle(int swtStyle) {
        int awtStyle = 0;
        if ((swtStyle & 1) == 1) {
            awtStyle |= 1;
        }
        if ((swtStyle & 2) == 2) {
            awtStyle |= 2;
        }
        return awtStyle;
    }

    private int toSWTFontStyle(int awtStyle) {
        int swtStyle = 0;
        if ((awtStyle & 1) == 1) {
            swtStyle |= 1;
        }
        if ((awtStyle & 2) == 2) {
            swtStyle |= 2;
        }
        return swtStyle;
    }

    private void toPointArray(PointList points, int[] xPoints, int[] yPoints) {
        int size = points.size();
        int i = 0;
        while (i < size) {
            Point p = points.getPoint(i);
            xPoints[i] = p.x;
            yPoints[i] = p.y;
            ++i;
        }
    }

    private void prepareBgColor() {
        this.backupColor = this.g.getColor();
        this.g.setColor(this.g.getBackground());
    }

    private void restoreBgColor() {
        this.g.setColor(this.backupColor);
    }

    private BufferedImage getImage(Image srcImage) {
        if (!this.images.containsKey(srcImage)) {
            this.images.put(srcImage, this.createImage(srcImage));
        }
        return (BufferedImage)this.images.get(srcImage);
    }

    private BufferedImage createImage(Image srcImage) {
        ImageData src = srcImage.getImageData();
        int width = srcImage.getBounds().width;
        int height = srcImage.getBounds().height;
        BufferedImage dstImage = new BufferedImage(width, height, 2);
        WritableRaster dst = dstImage.getRaster();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int[] pixel = this.getPixel(src, x, y);
                dst.setPixel(x, y, pixel);
                ++y;
            }
            ++x;
        }
        return dstImage;
    }

    private int[] getPixel(ImageData data, int x, int y) {
        PaletteData palette = data.palette;
        int pixel = data.getPixel(x, y);
        RGB rgb = palette.getRGB(pixel);
        int[] pixels = new int[]{rgb.red, rgb.green, rgb.blue, data.getAlpha(x, y)};
        return pixels;
    }
}

