/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import trier.diagrameditor.svg.AdaptAWTGraphics;

public class ExportSVGOperation
extends PrintGraphicalViewerOperation {
    public ExportSVGOperation(GraphicalViewer viewer) {
        super(null, viewer);
    }

    public InputStream createExportStream() throws Exception {
        SVGGraphics2D svgg = this.createSVGGraphics2D();
        AdaptAWTGraphics g = new AdaptAWTGraphics((Graphics2D)svgg);
        this.export(svgg, g);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean useCSS = true;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
        svgg.stream((Writer)out, useCSS);
        os.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    protected void export(SVGGraphics2D svgg, Graphics g) {
        super.preparePrintSource();
        this.setupGraphics(svgg, g, this.getPrintSource());
        super.getPrintSource().paint(g);
        super.restorePrintSource();
    }

    protected SVGGraphics2D createSVGGraphics2D() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument doc = (SVGDocument)impl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)doc);
        ctx.setEmbeddedFontsOn(true);
        ctx.setPrecision(3);
        return new SVGGraphics2D(ctx, true);
    }

    protected void setupGraphics(SVGGraphics2D svgg, Graphics g, IFigure f) {
        g.setForegroundColor(f.getForegroundColor());
        g.setBackgroundColor(f.getBackgroundColor());
        g.setFont(f.getFont());
        Rectangle bounds = f.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        g.translate(-x, -y);
        int width = bounds.width;
        int height = bounds.height;
        svgg.setSVGCanvasSize(new Dimension(width, height));
    }
}

