/*
 * Decompiled with CFR 0.152.
 */
package trier.diagrameditor.svg;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class GraphicsState {
    private static final Rectangle DEFAULT_CLIP = new Rectangle(-5000, -5000, 10000, 10000);
    private static float[] DOT_PATTERN = new float[]{3.0f, 3.0f};
    private static float[] DASH_PATTERN = new float[]{6.0f, 3.0f, 2.0f, 3.0f};
    private static float[] DASHDOT_PATTERN = new float[]{6.0f, 3.0f, 2.0f, 3.0f, 2.0f, 3.0f};
    private static float[] DASHDOTDOT_PATTERN = new float[]{6.0f, 3.0f, 2.0f, 3.0f, 2.0f, 3.0f, 2.0f, 3.0f};
    private int lineWidth;
    private int lineStyle;
    private Rectangle clip;
    private Color fgColor;
    private Color bgColor;
    private Font font;
    private boolean XORMode;

    public GraphicsState() {
        this(1, 1, DEFAULT_CLIP, ColorConstants.black, ColorConstants.white, new Font(null, new FontData()), false);
    }

    public GraphicsState(GraphicsState another) {
        this(another.lineWidth, another.lineStyle, another.clip, another.fgColor, another.bgColor, another.font, another.XORMode);
    }

    public GraphicsState(int lineWidth, int lineStyle, Rectangle clip, Color fg, Color bg, Font f, boolean XORMode) {
        this.lineWidth = lineWidth;
        this.lineStyle = lineStyle;
        this.clip = new Rectangle(clip);
        this.fgColor = fg;
        this.bgColor = bg;
        this.font = f;
        this.XORMode = XORMode;
    }

    public Rectangle getClip() {
        return this.clip;
    }

    public void setClip(Rectangle rectangle) {
        this.clip = rectangle;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int i) {
        this.lineStyle = i;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int i) {
        this.lineWidth = i;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color color) {
        this.fgColor = color;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public boolean isXORMode() {
        return this.XORMode;
    }

    public void setXORMode(boolean b) {
        this.XORMode = b;
    }

    public Stroke getStroke() {
        float w = this.lineWidth;
        int cap = 0;
        int join = 0;
        float m = 1.0f;
        float d = 0.0f;
        switch (this.lineStyle) {
            case 1: {
                return new BasicStroke(w);
            }
            case 2: {
                return new BasicStroke(w, cap, join, m, DASH_PATTERN, d);
            }
            case 3: {
                return new BasicStroke(w, cap, join, m, DOT_PATTERN, d);
            }
            case 4: {
                return new BasicStroke(w, cap, join, m, DASHDOT_PATTERN, d);
            }
            case 5: {
                return new BasicStroke(w, cap, join, m, DASHDOTDOT_PATTERN, d);
            }
        }
        return new BasicStroke();
    }
}

