/*
 * Decompiled with CFR 0.152.
 */
package trier.model.command;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import trier.model.command.TCommand;
import trier.model.core.TAggregationKind;
import trier.model.core.TAnchor;
import trier.model.core.TAssociation;
import trier.model.core.TAssociationEnd;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TClassifier;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TFeature;
import trier.model.core.TGeneralization;
import trier.model.core.TMethod;
import trier.model.core.TModelElement;
import trier.model.core.TModifiedElement;
import trier.model.core.TMultiplicity;
import trier.model.core.TNamespace;
import trier.model.core.TNote;
import trier.model.core.TParameter;
import trier.model.core.TRole;
import trier.model.core.TStereoType;
import trier.model.core.TTypedElement;
import trier.model.core.TVisibilityKind;
import trier.model.object.TInstance;
import trier.model.object.TInstanceVariable;
import trier.model.object.TLink;
import trier.model.object.TLinkSource;
import trier.model.object.TObjectModel;
import trier.model.sequence.TMessage;
import trier.model.sequence.TMessageLabel;
import trier.model.sequence.TSequenceModel;
import trier.model.sequence.TSequenciableElement;
import trier.model.state.TFinalState;
import trier.model.state.TGuardCondition;
import trier.model.state.TInitialState;
import trier.model.state.TRootStateMachine;
import trier.model.state.TState;
import trier.model.state.TStateMachine;
import trier.model.state.TTransition;
import trier.model.state.TTransitionLabel;

public class TCommandFactory
implements Serializable {
    private static final Logger logger;
    private TDocument document;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.command.TCommandFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.command.TCommandFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public TCommandFactory(TDocument document) {
        this.document = document;
    }

    public TCommand createAddTElementCommand(TElement parent, TElement child) {
        if (parent instanceof TNamespace && child instanceof TModelElement && !(child instanceof TMethod) && !(child instanceof TAttribute) && !(child instanceof TParameter) && !(child instanceof TState)) {
            return new AddOwnedElementCommand((TNamespace)parent, (TModelElement)child);
        }
        if (parent instanceof TClass && child instanceof TMethod) {
            return new AddMethodCommand((TClass)parent, (TMethod)child);
        }
        if (parent instanceof TClass && child instanceof TAttribute) {
            return new AddAttributeCommand((TClass)parent, (TAttribute)child);
        }
        if (parent instanceof TMethod && child instanceof TParameter) {
            return new AddParameterCommand((TMethod)parent, (TParameter)child);
        }
        if (parent instanceof TGeneralization && child instanceof TClass) {
            return new AddChildCommand((TGeneralization)parent, (TClass)child);
        }
        if (parent instanceof TAssociationEnd && child instanceof TMultiplicity) {
            return new SetMultiplicityCommand((TAssociationEnd)parent, (TMultiplicity)child);
        }
        if (parent instanceof TAssociationEnd && child instanceof TRole) {
            return new SetRoleCommand((TAssociationEnd)parent, (TRole)child);
        }
        if (parent instanceof TInstance && child instanceof TInstanceVariable) {
            return new AddInstanceVariableCommand((TInstance)parent, (TInstanceVariable)child);
        }
        if (parent instanceof TRootStateMachine) {
            TStateMachine stateMachine = (TStateMachine)((Object)parent);
            if (child instanceof TInitialState) {
                return new SetInitialStateCommand(stateMachine, (TInitialState)child);
            }
            if (child instanceof TFinalState) {
                return new AddFinalStateCommand(stateMachine, (TFinalState)child);
            }
            if (child instanceof TState) {
                return new AddStateCommand(stateMachine, (TState)child);
            }
        }
        throw new IllegalArgumentException("Illegal argument for adding. parent:" + parent.toString() + " child:" + child.toString());
    }

    public TCommand createRemoveTElementCommand(TElement modelElement) {
        if (modelElement instanceof TModelElement) {
            return new RemoveCommand((TModelElement)modelElement);
        }
        throw new IllegalArgumentException("this element is not removable model element." + modelElement);
    }

    public TCommand createInsertTElementCommand(TElement parent, TElement child, int index) {
        if (parent instanceof TNamespace && child instanceof TModelElement && !(child instanceof TMethod) && !(child instanceof TAttribute) && !(child instanceof TParameter)) {
            return new AddOwnedElementCommand((TNamespace)parent, (TModelElement)child);
        }
        if (parent instanceof TClass && child instanceof TMethod) {
            return new InsertMethodCommand((TClass)parent, (TMethod)child, index);
        }
        if (parent instanceof TClass && child instanceof TAttribute) {
            return new InsertAttributeCommand((TClass)parent, (TAttribute)child, index);
        }
        if (parent instanceof TMethod && child instanceof TParameter) {
            return new InsertParameterCommand((TMethod)parent, (TParameter)child, index);
        }
        if (parent instanceof TInstance && child instanceof TInstanceVariable) {
            return new InsertInstanceVariableCommand((TInstance)parent, (TInstanceVariable)child, index);
        }
        throw new IllegalArgumentException("Illegal argument for adding. parent:" + parent.toString() + " child:" + child.toString());
    }

    public TCommand createMoveUpTElementCommand(TElement parent, TElement child) {
        if (parent instanceof TNamespace && child instanceof TModelElement && !(child instanceof TMethod) && !(child instanceof TAttribute) && !(child instanceof TParameter)) {
            return new AddOwnedElementCommand((TNamespace)parent, (TModelElement)child);
        }
        if (parent instanceof TClass && child instanceof TMethod) {
            return new MoveUpMethodCommand((TClass)parent, (TMethod)child);
        }
        if (parent instanceof TClass && child instanceof TAttribute) {
            return new MoveUpAttributeCommand((TClass)parent, (TAttribute)child);
        }
        if (parent instanceof TMethod && child instanceof TParameter) {
            return new MoveUpParameterCommand((TMethod)parent, (TParameter)child);
        }
        if (parent instanceof TInstance && child instanceof TInstanceVariable) {
            return new MoveUpInstanceVariableCommand((TInstance)parent, (TInstanceVariable)child);
        }
        throw new IllegalArgumentException("Illegal argument for move up. parent:" + parent.toString() + " child:" + child.toString());
    }

    public TCommand createMoveDownTElementCommand(TElement parent, TElement child) {
        if (parent instanceof TNamespace && child instanceof TModelElement && !(child instanceof TMethod) && !(child instanceof TAttribute) && !(child instanceof TParameter)) {
            return new AddOwnedElementCommand((TNamespace)parent, (TModelElement)child);
        }
        if (parent instanceof TClass && child instanceof TMethod) {
            return new MoveDownMethodCommand((TClass)parent, (TMethod)child);
        }
        if (parent instanceof TClass && child instanceof TAttribute) {
            return new MoveDownAttributeCommand((TClass)parent, (TAttribute)child);
        }
        if (parent instanceof TMethod && child instanceof TParameter) {
            return new MoveDownParameterCommand((TMethod)parent, (TParameter)child);
        }
        if (parent instanceof TInstance && child instanceof TInstanceVariable) {
            return new MoveDownInstanceVariableCommand((TInstance)parent, (TInstanceVariable)child);
        }
        throw new IllegalArgumentException("Illegal argument for move down. parent:" + parent.toString() + " child:" + child.toString());
    }

    public TCommand createRelateCommand(TElement namespace, TElement relation, TElement source, TElement target) {
        if (source instanceof TClass && target instanceof TClass) {
            if (relation instanceof TAssociation) {
                return new RelateAssociationCommand((TNamespace)namespace, (TAssociation)relation, (TClass)source, (TClass)target);
            }
            if (relation instanceof TGeneralization) {
                return new RelateGeneralizationCommand((TNamespace)namespace, (TGeneralization)relation, (TClass)source, (TClass)target);
            }
        }
        if (relation instanceof TAnchor) {
            return new RelateAnchorCommand((TNamespace)namespace, (TAnchor)relation, (TModelElement)source, (TModelElement)target);
        }
        if (relation instanceof TTransition && target instanceof TState && source instanceof TState && namespace instanceof TStateMachine) {
            return new ConnectTransitionCommand((TStateMachine)((Object)namespace), (TTransition)relation, (TState)source, (TState)target);
        }
        if (relation instanceof TMessage && target instanceof TSequenciableElement && source instanceof TSequenciableElement && namespace instanceof TSequenceModel) {
            return new ConnectSequenceCommand((TSequenceModel)namespace, (TMessage)relation, (TSequenciableElement)source, (TSequenciableElement)target);
        }
        if (relation instanceof TLink && target instanceof TInstance && source instanceof TLinkSource && namespace instanceof TObjectModel) {
            return new ConnectLinkCommand((TObjectModel)namespace, (TLink)relation, (TLinkSource)source, (TInstance)target);
        }
        throw new IllegalArgumentException("invalid relative elements. relation:" + relation + "child:" + source + "parent:" + target);
    }

    public TCommand createReconnectSourceCommand(TElement relation, TElement source) {
        if (source instanceof TClass) {
            if (relation instanceof TAssociation) {
                TAssociationEnd sourceEnd = ((TAssociation)relation).getSourceAssociationEnd();
                return new SetOwnerCommand(sourceEnd, (TClass)source);
            }
            if (relation instanceof TGeneralization) {
                return new SetChildCommand((TGeneralization)relation, (TClass)source);
            }
        }
        if (relation instanceof TAnchor) {
            return new ReconnectSourceCommand((TAnchor)relation, (TModelElement)source);
        }
        if (relation instanceof TTransition && source instanceof TState) {
            return new ReconnectTransitionSourceCommand((TTransition)relation, (TState)source);
        }
        if (relation instanceof TMessage && source instanceof TSequenciableElement) {
            return new ReconnectSequenceSourceCommand((TMessage)relation, (TSequenciableElement)source);
        }
        if (relation instanceof TLink && source instanceof TLinkSource) {
            return new ReconnectLinkSourceCommand((TLink)relation, (TLinkSource)source);
        }
        throw new IllegalArgumentException("invalid relative elements. relation:" + relation + "source:" + source);
    }

    public TCommand createReconnectTargetCommand(TElement relation, TElement target) {
        if (target instanceof TClass) {
            if (relation instanceof TAssociation) {
                TAssociationEnd targetEnd = ((TAssociation)relation).getTargetAssociationEnd();
                return new SetOwnerCommand(targetEnd, (TClass)target);
            }
            if (relation instanceof TGeneralization) {
                return new SetParentCommand((TGeneralization)relation, (TClass)target);
            }
        }
        if (relation instanceof TAnchor) {
            return new ReconnectTargetCommand((TAnchor)relation, (TModelElement)target);
        }
        if (relation instanceof TTransition && target instanceof TState) {
            return new ReconnectTransitionTargetCommand((TTransition)relation, (TState)target);
        }
        if (relation instanceof TMessage && target instanceof TSequenciableElement) {
            return new ReconnectSequenceTargetCommand((TMessage)relation, (TSequenciableElement)target);
        }
        if (relation instanceof TLink && target instanceof TInstance) {
            return new ReconnectLinkTargetCommand((TLink)relation, (TInstance)target);
        }
        throw new IllegalArgumentException("invalid relative elements. relation:" + relation + "target:" + target);
    }

    public TCommand createSetNameCommand(TModelElement modelElement, String name) {
        return new SetNameCommand(modelElement, name);
    }

    public TCommand createSetVisibilityCommand(TModifiedElement modifiedElement, TVisibilityKind kind) {
        return new SetVisibilityCommand(modifiedElement, kind);
    }

    public TCommand createSetNamespaceCommand(TModelElement modelElement, TNamespace namespace) {
        if (!$assertionsDisabled && modelElement.getNamespace() == null) {
            throw new AssertionError();
        }
        return new SetNamespaceCommand(modelElement, namespace);
    }

    public TCommand createSetStereoTypeCommand(TModelElement modelElement, TStereoType stereoType) {
        return new SetStereoTypeCommand(modelElement, stereoType);
    }

    public TCommand createSetDescriptionCommand(TNote note, String description) {
        return new SetDescriptionCommand(note, description);
    }

    public TCommand createRelateAnchorCommand(TNamespace namespace, TAnchor anchor, TModelElement source, TModelElement target) {
        return new RelateAnchorCommand(namespace, anchor, source, target);
    }

    public TCommand createReconnectSourceCommand(TAnchor anchor, TModelElement source) {
        return new ReconnectSourceCommand(anchor, source);
    }

    public TCommand createReconnectTargetCommand(TAnchor anchor, TModelElement target) {
        return new ReconnectTargetCommand(anchor, target);
    }

    public TCommand createAddOwnedElementCommand(TNamespace owner, TModelElement modelElement) {
        return new AddOwnedElementCommand(owner, modelElement);
    }

    public TCommand createSetOwnerCommand(TFeature feature, TClass owner) {
        return new SetOwnerCommand(feature, owner);
    }

    public TCommand createSetStaticCommand(TModifiedElement modifiedElement, boolean isStatic) {
        return new SetStaticCommand(modifiedElement, isStatic);
    }

    public TCommand createSetFinalCommand(TModifiedElement modifiedElement, boolean isFinal) {
        return new SetFinalCommand(modifiedElement, isFinal);
    }

    public TCommand createSetTypeCommand(TTypedElement typedElement, TClassifier type) {
        return new SetTypeCommand(typedElement, type);
    }

    public TCommand createRelateGeneralizationCommand(TNamespace namespace, TGeneralization generalization, TClass child, TClass parent) {
        return new RelateGeneralizationCommand(namespace, generalization, child, parent);
    }

    public TCommand createSetChildCommand(TGeneralization generalization, TClass child) {
        return new SetChildCommand(generalization, child);
    }

    public TCommand createAddChildCommand(TGeneralization generalization, TClass child) {
        return new AddChildCommand(generalization, child);
    }

    public TCommand createRemoveChildCommand(TGeneralization generalization, TClass child) {
        return new RemoveChildCommand(generalization, child);
    }

    public TCommand createSetParentCommand(TGeneralization generalization, TClass parent) {
        return new SetParentCommand(generalization, parent);
    }

    public TCommand createRelateAssociationCommand(TNamespace namespace, TAssociation association, TClass source, TClass target) {
        return new RelateAssociationCommand(namespace, association, source, target);
    }

    public TCommand createSetRoleCommand(TAssociationEnd associationEnd, TRole role) {
        return new SetRoleCommand(associationEnd, role);
    }

    public TCommand createSetNavigableCommand(TAssociationEnd associationEnd, boolean isNavigable) {
        return new SetNavigableCommand(associationEnd, isNavigable);
    }

    public TCommand createSetAggregationCommand(TAssociationEnd associationEnd, TAggregationKind aggregationKind) {
        return new SetAggregationKindCommand(associationEnd, aggregationKind);
    }

    public TCommand createSetMultiplicityCommand(TAssociationEnd associationEnd, TMultiplicity multiplicity) {
        return new SetMultiplicityCommand(associationEnd, multiplicity);
    }

    public TCommand createSetMultiplicityRangeCommand(TMultiplicity multiplicity, String value) {
        return new SetMultiplicityRangeCommand(multiplicity, value);
    }

    public TCommand createAddMethodCommand(TClass owner, TMethod method) {
        return new AddMethodCommand(owner, method);
    }

    public TCommand createMoveUpMethodCommand(TClass owner, TMethod method) {
        return new MoveUpMethodCommand(owner, method);
    }

    public TCommand createMoveDownMethodCommand(TClass owner, TMethod method) {
        return new MoveDownMethodCommand(owner, method);
    }

    public TCommand createInsertMethodCommand(TClass owner, TMethod method, int index) {
        return new InsertMethodCommand(owner, method, index);
    }

    public TCommand createAddParameterCommand(TMethod method, TParameter parameter) {
        return new AddParameterCommand(method, parameter);
    }

    public TCommand createMoveUpParameterCommand(TMethod owner, TParameter parameter) {
        return new MoveUpParameterCommand(owner, parameter);
    }

    public TCommand createMoveDownParameterCommand(TMethod owner, TParameter parameter) {
        return new MoveDownParameterCommand(owner, parameter);
    }

    public TCommand createInsertParameterCommand(TMethod owner, TParameter parameter, int index) {
        return new InsertParameterCommand(owner, parameter, index);
    }

    public TCommand createAddAttributeCommand(TClass owner, TAttribute attribute) {
        return new AddAttributeCommand(owner, attribute);
    }

    public TCommand createMoveUpAttributeCommand(TClass owner, TAttribute attribute) {
        return new MoveUpAttributeCommand(owner, attribute);
    }

    public TCommand createMoveDownAttributeCommand(TClass owner, TAttribute attribute) {
        return new MoveDownAttributeCommand(owner, attribute);
    }

    public TCommand createInsertAttributeCommand(TClass owner, TAttribute attribute, int index) {
        return new InsertAttributeCommand(owner, attribute, index);
    }

    public TCommand createSetAbstractCommand(TModifiedElement modifiedElement, boolean isAbstract) {
        return new SetAbstractCommand(modifiedElement, isAbstract);
    }

    public TCommand createSetInterfaceCommand(TClass clazz, boolean isInterface) {
        return new SetInterfaceCommand(clazz, isInterface);
    }

    public TCommand createSetGuardCommand(TTransition transition, TGuardCondition guard) {
        return new SetGuardCommand(transition, guard);
    }

    public TCommand createSetTransitionLabelCommand(TTransition transition, TTransitionLabel label) {
        return new SetTransitionLabelCommand(transition, label);
    }

    public TCommand createSetMessageLabelCommand(TMessage sequence, TMessageLabel message) {
        return new SetMessageLabelCommand(sequence, message);
    }

    public TCommand createSetValueCommand(TInstanceVariable instanceVariable, String value) {
        return new SetValueCommand(instanceVariable, value);
    }

    public TCommand createAddInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
        return new AddInstanceVariableCommand(instance, variable);
    }

    public TCommand createMoveUpInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
        return new MoveUpInstanceVariableCommand(instance, variable);
    }

    public TCommand createMoveDownInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
        return new MoveDownInstanceVariableCommand(instance, variable);
    }

    public TCommand createInsertInstanceVariableCommand(TInstance instance, TInstanceVariable variable, int index) {
        return new InsertInstanceVariableCommand(instance, variable, index);
    }

    protected TDocument getDocument() {
        return this.document;
    }

    class RemoveCommand
    extends TCommand {
        private TModelElement modelElement;

        public RemoveCommand(TModelElement modelElement) {
            this.modelElement = modelElement;
        }

        public void execute() {
            if (!this.modelElement.isRemoved()) {
                TCommandFactory.this.document.remove(this.modelElement);
            }
        }

        public void undo() {
            if (this.modelElement.isRemoved()) {
                TCommandFactory.this.document.comeBack(this.modelElement);
            }
        }
    }

    class SetNameCommand
    extends TCommand {
        private TModelElement modelElement;
        private String name;
        private String oldName;

        public SetNameCommand(TModelElement modelElement, String name) {
            this.modelElement = modelElement;
            this.name = name;
            this.oldName = modelElement.getName();
        }

        public void execute() {
            TCommandFactory.this.document.setName(this.modelElement, this.name);
        }

        public void undo() {
            TCommandFactory.this.document.setName(this.modelElement, this.oldName);
        }
    }

    class SetVisibilityCommand
    extends TCommand {
        private TModifiedElement modifiedElement;
        private TVisibilityKind visibility;
        private TVisibilityKind oldVisibility;

        public SetVisibilityCommand(TModifiedElement modelElement, TVisibilityKind visibility) {
            this.modifiedElement = modelElement;
            this.visibility = visibility;
            this.oldVisibility = modelElement.getVisibilityKind();
        }

        public void execute() {
            TCommandFactory.this.document.setVisibility(this.modifiedElement, this.visibility);
        }

        public void undo() {
            TCommandFactory.this.document.setVisibility(this.modifiedElement, this.oldVisibility);
        }
    }

    class SetNamespaceCommand
    extends TCommand {
        private TModelElement modelElement;
        private TNamespace namespace;
        private TNamespace oldNamespace;

        public SetNamespaceCommand(TModelElement modelElement, TNamespace namespace) {
            this.namespace = namespace;
            this.modelElement = modelElement;
            this.oldNamespace = modelElement.getNamespace();
        }

        public void execute() {
            TCommandFactory.this.document.setNamespace(this.modelElement, this.namespace);
        }

        public void undo() {
            TCommandFactory.this.document.setNamespace(this.modelElement, this.oldNamespace);
        }
    }

    class SetStereoTypeCommand
    extends TCommand {
        private TModelElement modelElement;
        private TStereoType stereoType;
        private TStereoType oldStereoType;

        public SetStereoTypeCommand(TModelElement modelElement, TStereoType stereoType) {
            this.stereoType = stereoType;
            this.modelElement = modelElement;
            this.oldStereoType = modelElement.getStereoType();
        }

        public void execute() {
            TCommandFactory.this.document.setStereoType(this.modelElement, this.stereoType);
        }

        public void undo() {
            TCommandFactory.this.document.setStereoType(this.modelElement, this.oldStereoType);
        }
    }

    class SetDescriptionCommand
    extends TCommand {
        private TNote note;
        private String description;
        private String oldDescription;

        public SetDescriptionCommand(TNote note, String description) {
            this.note = note;
            this.description = description;
            this.oldDescription = note.getDescription();
        }

        public void execute() {
            TCommandFactory.this.document.setDescription(this.note, this.description);
        }

        public void undo() {
            TCommandFactory.this.document.setDescription(this.note, this.oldDescription);
        }
    }

    class RelateAnchorCommand
    extends TCommand {
        private TAnchor anchor;
        private TNamespace namespace;
        private TModelElement source;
        private TModelElement target;

        public RelateAnchorCommand(TNamespace namespace, TAnchor anchor, TModelElement source, TModelElement target) {
            this.anchor = anchor;
            this.namespace = namespace;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            TCommandFactory.this.document.relateAnchor(this.namespace, this.anchor, this.source, this.target);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.anchor);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.anchor);
        }
    }

    class ReconnectSourceCommand
    extends TCommand {
        private TAnchor anchor;
        private TModelElement source;
        private TModelElement oldSource;

        public ReconnectSourceCommand(TAnchor anchor, TModelElement source) {
            this.anchor = anchor;
            this.source = source;
            this.oldSource = anchor.getSource();
        }

        public void execute() {
            TCommandFactory.this.document.reconnectSource(this.anchor, this.source);
        }

        public void undo() {
            TCommandFactory.this.document.reconnectSource(this.anchor, this.oldSource);
        }
    }

    class ReconnectTargetCommand
    extends TCommand {
        private TAnchor anchor;
        private TModelElement target;
        private TModelElement oldTarget;

        public ReconnectTargetCommand(TAnchor anchor, TModelElement target) {
            this.anchor = anchor;
            this.target = target;
            this.oldTarget = anchor.getTarget();
        }

        public void execute() {
            TCommandFactory.this.document.reconnectTarget(this.anchor, this.target);
        }

        public void undo() {
            TCommandFactory.this.document.reconnectTarget(this.anchor, this.oldTarget);
        }
    }

    class AddOwnedElementCommand
    extends TCommand {
        private TNamespace owner;
        private TModelElement modelElement;

        public AddOwnedElementCommand(TNamespace owner, TModelElement modelElement) {
            this.owner = owner;
            this.modelElement = modelElement;
        }

        public void execute() {
            TCommandFactory.this.document.addOwnedElement(this.owner, this.modelElement);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.modelElement);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.modelElement);
        }
    }

    class SetOwnerCommand
    extends TCommand {
        private TFeature feature;
        private TClass owner;
        private TClass oldOwner;

        public SetOwnerCommand(TFeature feature, TClass owner) {
            this.feature = feature;
            this.owner = owner;
            this.oldOwner = feature.getOwner();
        }

        public void execute() {
            TCommandFactory.this.document.setOwner(this.feature, this.owner);
        }

        public void undo() {
            TCommandFactory.this.document.setOwner(this.feature, this.oldOwner);
        }
    }

    class SetStaticCommand
    extends TCommand {
        private TModifiedElement modifiedElement;
        private boolean isStatic;
        private boolean oldIsStatic;

        public SetStaticCommand(TModifiedElement modifiedElement, boolean isStatic) {
            this.modifiedElement = modifiedElement;
            this.isStatic = isStatic;
            this.oldIsStatic = modifiedElement.isStatic();
        }

        public void execute() {
            TCommandFactory.this.document.setStatic(this.modifiedElement, this.isStatic);
        }

        public void undo() {
            TCommandFactory.this.document.setStatic(this.modifiedElement, this.oldIsStatic);
        }
    }

    class SetFinalCommand
    extends TCommand {
        private TModifiedElement modifiedElement;
        private boolean isFinal;
        private boolean oldIsFinal;

        public SetFinalCommand(TModifiedElement modifiedElement, boolean isFinal) {
            this.modifiedElement = modifiedElement;
            this.isFinal = isFinal;
            this.oldIsFinal = modifiedElement.isFinal();
        }

        public void execute() {
            TCommandFactory.this.document.setFinal(this.modifiedElement, this.isFinal);
        }

        public void undo() {
            TCommandFactory.this.document.setFinal(this.modifiedElement, this.oldIsFinal);
        }
    }

    class SetTypeCommand
    extends TCommand {
        private TTypedElement typedElement;
        private TClassifier type;
        private TClassifier oldType;

        public SetTypeCommand(TTypedElement typedElement, TClassifier type) {
            this.typedElement = typedElement;
            this.type = type;
            this.oldType = typedElement.getType();
        }

        public void execute() {
            TCommandFactory.this.document.setType(this.typedElement, this.type);
        }

        public void undo() {
            TCommandFactory.this.document.setType(this.typedElement, this.oldType);
        }
    }

    class RelateGeneralizationCommand
    extends TCommand {
        private TNamespace namespace;
        private TGeneralization generalization;
        private TClass child;
        private TClass parent;

        public RelateGeneralizationCommand(TNamespace namespace, TGeneralization generalization, TClass child, TClass parent) {
            this.namespace = namespace;
            this.generalization = generalization;
            this.child = child;
            this.parent = parent;
        }

        public void execute() {
            TCommandFactory.this.document.relateGeneralization(this.namespace, this.generalization, this.child, this.parent);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.generalization);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.generalization);
        }
    }

    class SetChildCommand
    extends TCommand {
        private TGeneralization generalization;
        private TClass child;
        private List oldChildren;

        public SetChildCommand(TGeneralization generalization, TClass child) {
            this.generalization = generalization;
            this.child = child;
            this.oldChildren = generalization.getChildClasses();
        }

        public void execute() {
            TCommandFactory.this.document.setChild(this.generalization, this.child);
        }

        public void undo() {
            TCommandFactory.this.document.setChildren(this.generalization, this.oldChildren);
        }
    }

    class AddChildCommand
    extends TCommand {
        private TGeneralization generalization;
        private TClass child;

        public AddChildCommand(TGeneralization generalization, TClass child) {
            this.generalization = generalization;
            this.child = child;
        }

        public void execute() {
            TCommandFactory.this.document.addChild(this.generalization, this.child);
        }

        public void undo() {
            TCommandFactory.this.document.removeChild(this.generalization, this.child);
        }
    }

    class RemoveChildCommand
    extends TCommand {
        private TGeneralization generalization;
        private TClass child;

        public RemoveChildCommand(TGeneralization generalization, TClass child) {
            this.generalization = generalization;
            this.child = child;
        }

        public void execute() {
            TCommandFactory.this.document.removeChild(this.generalization, this.child);
        }

        public void undo() {
            TCommandFactory.this.document.addChild(this.generalization, this.child);
        }
    }

    class SetParentCommand
    extends TCommand {
        private TGeneralization generalization;
        private TClass parent;
        private TClass oldParent;

        public SetParentCommand(TGeneralization generalization, TClass parent) {
            this.generalization = generalization;
            this.parent = parent;
            this.oldParent = generalization.getParentClass();
        }

        public void execute() {
            TCommandFactory.this.document.setParent(this.generalization, this.parent);
        }

        public void undo() {
            TCommandFactory.this.document.setParent(this.generalization, this.oldParent);
        }
    }

    class RelateAssociationCommand
    extends TCommand {
        private TNamespace namespace;
        private TAssociation association;
        private TClass source;
        private TClass target;

        public RelateAssociationCommand(TNamespace namespace, TAssociation association, TClass source, TClass target) {
            this.namespace = namespace;
            this.association = association;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            TCommandFactory.this.document.relateAssociation(this.namespace, this.association, this.source, this.target);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.association);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.association);
        }
    }

    class SetRoleCommand
    extends TCommand {
        private TAssociationEnd associationEnd;
        private TRole role;
        private TRole oldRole;

        public SetRoleCommand(TAssociationEnd associationEnd, TRole role) {
            this.associationEnd = associationEnd;
            this.role = role;
            this.oldRole = associationEnd.getRole();
        }

        public void execute() {
            TCommandFactory.this.document.setRole(this.associationEnd, this.role);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.role);
            this.execute();
        }

        public void undo() {
            TCommandFactory.this.document.comeBack(this.oldRole);
            TCommandFactory.this.document.setRole(this.associationEnd, this.oldRole);
        }
    }

    class SetNavigableCommand
    extends TCommand {
        private TAssociationEnd associationEnd;
        private boolean isNavigable;
        private boolean oldIsNavigable;

        public SetNavigableCommand(TAssociationEnd associationEnd, boolean isNavigable) {
            this.associationEnd = associationEnd;
            this.isNavigable = isNavigable;
            this.oldIsNavigable = associationEnd.isNavigable();
        }

        public void execute() {
            TCommandFactory.this.document.setNavigable(this.associationEnd, this.isNavigable);
        }

        public void undo() {
            TCommandFactory.this.document.setNavigable(this.associationEnd, this.oldIsNavigable);
        }
    }

    class SetAggregationKindCommand
    extends TCommand {
        private TAssociationEnd associationEnd;
        private TAggregationKind aggregationKind;
        private TAggregationKind oldAggregationKind;

        public SetAggregationKindCommand(TAssociationEnd associationEnd, TAggregationKind aggregationKind) {
            this.associationEnd = associationEnd;
            this.aggregationKind = aggregationKind;
            this.oldAggregationKind = associationEnd.getAggregationKind();
        }

        public void execute() {
            TCommandFactory.this.document.setAggregationKind(this.associationEnd, this.aggregationKind);
        }

        public void undo() {
            TCommandFactory.this.document.setAggregationKind(this.associationEnd, this.oldAggregationKind);
        }
    }

    class SetMultiplicityCommand
    extends TCommand {
        private TAssociationEnd associationEnd;
        private TMultiplicity multiplicity;
        private TMultiplicity oldMultiplicity;

        public SetMultiplicityCommand(TAssociationEnd associationEnd, TMultiplicity multiplicity) {
            this.associationEnd = associationEnd;
            this.multiplicity = multiplicity;
            this.oldMultiplicity = associationEnd.getMultiplicity();
        }

        public void execute() {
            TCommandFactory.this.document.setMultiplicity(this.associationEnd, this.multiplicity);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.multiplicity);
            this.execute();
        }

        public void undo() {
            TCommandFactory.this.document.comeBack(this.oldMultiplicity);
            TCommandFactory.this.document.setMultiplicity(this.associationEnd, this.oldMultiplicity);
        }
    }

    class SetMultiplicityRangeCommand
    extends TCommand {
        private TMultiplicity multiplicity;
        private String value;
        private String oldValue;

        public SetMultiplicityRangeCommand(TMultiplicity multiplicity, String value) {
            this.multiplicity = multiplicity;
            this.value = value;
            this.oldValue = multiplicity.getMultiplicityRanges();
        }

        public void execute() {
            TCommandFactory.this.document.setMultiplicityRange(this.multiplicity, this.value);
        }

        public void undo() {
            TCommandFactory.this.document.setMultiplicityRange(this.multiplicity, this.oldValue);
        }
    }

    class AddMethodCommand
    extends TCommand {
        private TClass clazz;
        private TMethod method;

        public AddMethodCommand(TClass clazz, TMethod method) {
            this.clazz = clazz;
            this.method = method;
        }

        public void execute() {
            TCommandFactory.this.document.addMethod(this.clazz, this.method);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.method);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.method);
        }
    }

    class MoveUpMethodCommand
    extends TCommand {
        private TClass clazz;
        private TMethod method;

        public MoveUpMethodCommand(TClass clazz, TMethod method) {
            this.clazz = clazz;
            this.method = method;
        }

        public void execute() {
            TCommandFactory.this.document.moveUpMethod(this.clazz, this.method);
        }

        public void undo() {
            TCommandFactory.this.document.moveDownMethod(this.clazz, this.method);
        }
    }

    class MoveDownMethodCommand
    extends TCommand {
        private TClass clazz;
        private TMethod method;

        public MoveDownMethodCommand(TClass clazz, TMethod method) {
            this.clazz = clazz;
            this.method = method;
        }

        public void execute() {
            TCommandFactory.this.document.moveDownMethod(this.clazz, this.method);
        }

        public void undo() {
            TCommandFactory.this.document.moveUpMethod(this.clazz, this.method);
        }
    }

    class InsertMethodCommand
    extends TCommand {
        private TClass clazz;
        private TMethod method;
        private int index;

        public InsertMethodCommand(TClass clazz, TMethod method, int index) {
            this.clazz = clazz;
            this.method = method;
            this.index = index;
        }

        public void execute() {
            TCommandFactory.this.document.insertMethod(this.clazz, this.method, this.index);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.method, this.index);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.method);
        }
    }

    class AddParameterCommand
    extends TCommand {
        private TMethod method;
        private TParameter parameter;

        public AddParameterCommand(TMethod method, TParameter parameter) {
            this.method = method;
            this.parameter = parameter;
        }

        public void execute() {
            TCommandFactory.this.document.addParameter(this.method, this.parameter);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.parameter);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.parameter);
        }
    }

    class MoveUpParameterCommand
    extends TCommand {
        private TMethod method;
        private TParameter parameter;

        public MoveUpParameterCommand(TMethod method, TParameter parameter) {
            this.method = method;
            this.parameter = parameter;
        }

        public void execute() {
            TCommandFactory.this.document.moveUpParameter(this.method, this.parameter);
        }

        public void undo() {
            TCommandFactory.this.document.moveDownParameter(this.method, this.parameter);
        }
    }

    class MoveDownParameterCommand
    extends TCommand {
        private TMethod method;
        private TParameter parameter;

        public MoveDownParameterCommand(TMethod method, TParameter parameter) {
            this.method = method;
            this.parameter = parameter;
        }

        public void execute() {
            TCommandFactory.this.document.moveDownParameter(this.method, this.parameter);
        }

        public void undo() {
            TCommandFactory.this.document.moveUpParameter(this.method, this.parameter);
        }
    }

    class InsertParameterCommand
    extends TCommand {
        private TMethod clazz;
        private TParameter parameter;
        private int index;

        public InsertParameterCommand(TMethod clazz, TParameter parameter, int index) {
            this.clazz = clazz;
            this.parameter = parameter;
            this.index = index;
        }

        public void execute() {
            TCommandFactory.this.document.insertParameter(this.clazz, this.parameter, this.index);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.parameter, this.index);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.parameter);
        }
    }

    class AddAttributeCommand
    extends TCommand {
        private TClass clazz;
        private TAttribute attribute;

        public AddAttributeCommand(TClass clazz, TAttribute attribute) {
            this.clazz = clazz;
            this.attribute = attribute;
        }

        public void execute() {
            TCommandFactory.this.document.addAttribute(this.clazz, this.attribute);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.attribute);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.attribute);
        }
    }

    class MoveUpAttributeCommand
    extends TCommand {
        private TClass clazz;
        private TAttribute attribute;

        public MoveUpAttributeCommand(TClass clazz, TAttribute attribute) {
            this.clazz = clazz;
            this.attribute = attribute;
        }

        public void execute() {
            TCommandFactory.this.document.moveUpAttribute(this.clazz, this.attribute);
        }

        public void undo() {
            TCommandFactory.this.document.moveDownAttribute(this.clazz, this.attribute);
        }
    }

    class MoveDownAttributeCommand
    extends TCommand {
        private TClass clazz;
        private TAttribute attribute;

        public MoveDownAttributeCommand(TClass clazz, TAttribute attribute) {
            this.clazz = clazz;
            this.attribute = attribute;
        }

        public void execute() {
            TCommandFactory.this.document.moveDownAttribute(this.clazz, this.attribute);
        }

        public void undo() {
            TCommandFactory.this.document.moveUpAttribute(this.clazz, this.attribute);
        }
    }

    class InsertAttributeCommand
    extends TCommand {
        private TClass clazz;
        private TAttribute attribute;
        private int index;

        public InsertAttributeCommand(TClass clazz, TAttribute attribute, int index) {
            this.clazz = clazz;
            this.attribute = attribute;
            this.index = index;
        }

        public void execute() {
            TCommandFactory.this.document.insertAttribute(this.clazz, this.attribute, this.index);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.attribute, this.index);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.attribute);
        }
    }

    class SetAbstractCommand
    extends TCommand {
        private TModifiedElement modifiedElement;
        private boolean isAbstract;
        private boolean oldIsAbstract;

        public SetAbstractCommand(TModifiedElement modifiedElement, boolean isAbstract) {
            this.modifiedElement = modifiedElement;
            this.isAbstract = isAbstract;
            this.oldIsAbstract = modifiedElement.isAbstract();
        }

        public void execute() {
            TCommandFactory.this.document.setAbstract(this.modifiedElement, this.isAbstract);
        }

        public void undo() {
            TCommandFactory.this.document.setAbstract(this.modifiedElement, this.oldIsAbstract);
        }
    }

    class SetInterfaceCommand
    extends TCommand {
        private TClass clazz;
        private boolean isInterface;
        private boolean oldIsInterface;

        public SetInterfaceCommand(TClass clazz, boolean isInterface) {
            this.clazz = clazz;
            this.isInterface = isInterface;
            this.oldIsInterface = clazz.isInterface();
        }

        public void execute() {
            TCommandFactory.this.document.setInterface(this.clazz, this.isInterface);
        }

        public void undo() {
            TCommandFactory.this.document.setInterface(this.clazz, this.oldIsInterface);
        }
    }

    class AddStateCommand
    extends TCommand {
        private TStateMachine stateMachine;
        private TState state;

        private AddStateCommand(TStateMachine root, TState state) {
            this.stateMachine = root;
            this.state = state;
        }

        public void execute() {
            TCommandFactory.this.getDocument().addState(this.stateMachine, this.state);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.state);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.state);
        }
    }

    class AddFinalStateCommand
    extends TCommand {
        private TStateMachine stateMachine;
        private TFinalState state;

        private AddFinalStateCommand(TStateMachine root, TFinalState state) {
            this.stateMachine = root;
            this.state = state;
        }

        public void execute() {
            TCommandFactory.this.getDocument().addFinalState(this.stateMachine, this.state);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.state);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.state);
        }
    }

    class SetInitialStateCommand
    extends TCommand {
        private TStateMachine stateMachine;
        private TInitialState state;

        private SetInitialStateCommand(TStateMachine root, TInitialState state) {
            this.stateMachine = root;
            this.state = state;
        }

        public void execute() {
            TCommandFactory.this.getDocument().setInitialState(this.stateMachine, this.state);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.state);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.state);
        }
    }

    class ReconnectTransitionSourceCommand
    extends TCommand {
        private TTransition transition;
        private TState newSourceState;
        private TState oldSourceState;

        public ReconnectTransitionSourceCommand(TTransition transition, TState state) {
            this.transition = transition;
            this.oldSourceState = transition.getSourceState();
            this.newSourceState = state;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectTranstionSource(this.transition, this.newSourceState);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectTranstionSource(this.transition, this.oldSourceState);
        }
    }

    class ReconnectTransitionTargetCommand
    extends TCommand {
        private TTransition transition;
        private TState newTargetState;
        private TState oldTargetState;

        public ReconnectTransitionTargetCommand(TTransition transition, TState state) {
            this.transition = transition;
            this.oldTargetState = transition.getTargetState();
            this.newTargetState = state;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectTranstionTarget(this.transition, this.newTargetState);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectTranstionTarget(this.transition, this.oldTargetState);
        }
    }

    class ConnectTransitionCommand
    extends TCommand {
        private TStateMachine stateMachine;
        private TTransition transition;
        private TState source;
        private TState target;

        private ConnectTransitionCommand(TStateMachine machine, TTransition transition, TState source, TState target) {
            this.stateMachine = machine;
            this.transition = transition;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            TCommandFactory.this.getDocument().connectTransition(this.stateMachine, this.transition, this.source, this.target);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.transition);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.transition);
        }
    }

    class SetGuardCommand
    extends TCommand {
        private TTransition transition;
        private TGuardCondition guard;

        private SetGuardCommand(TTransition transition, TGuardCondition guard) {
            this.transition = transition;
            this.guard = guard;
        }

        public void execute() {
            TCommandFactory.this.getDocument().setGuardCondition(this.transition, this.guard);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.guard);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.guard);
        }
    }

    class ConnectSequenceCommand
    extends TCommand {
        private TSequenceModel sequenceModel;
        private TMessage transition;
        private TSequenciableElement source;
        private TSequenciableElement target;

        private ConnectSequenceCommand(TSequenceModel sequenceModel, TMessage sequence, TSequenciableElement source, TSequenciableElement target) {
            this.sequenceModel = sequenceModel;
            this.transition = sequence;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            TCommandFactory.this.getDocument().connectSequence(this.sequenceModel, this.transition, this.source, this.target);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.transition);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.transition);
        }
    }

    class ConnectLinkCommand
    extends TCommand {
        private TObjectModel namespace;
        private TLink link;
        private TLinkSource source;
        private TInstance target;

        private ConnectLinkCommand(TObjectModel namespace, TLink link, TLinkSource source, TInstance target) {
            this.namespace = namespace;
            this.link = link;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            TCommandFactory.this.getDocument().connectLink(this.namespace, this.link, this.source, this.target);
        }

        public void redo() {
            TCommandFactory.this.getDocument().comeBack(this.link);
        }

        public void undo() {
            TCommandFactory.this.getDocument().remove(this.link);
        }
    }

    class ReconnectLinkTargetCommand
    extends TCommand {
        private TLink link;
        private TInstance newTarget;
        private TInstance oldTarget;

        public ReconnectLinkTargetCommand(TLink link, TInstance newTarget) {
            this.link = link;
            this.oldTarget = link.getTarget();
            this.newTarget = newTarget;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectLinkTarget(this.link, this.newTarget);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectLinkTarget(this.link, this.oldTarget);
        }
    }

    class ReconnectLinkSourceCommand
    extends TCommand {
        private TLink link;
        private TLinkSource newSource;
        private TLinkSource newTarget;

        public ReconnectLinkSourceCommand(TLink link, TLinkSource newSource) {
            this.link = link;
            this.newTarget = link.getSource();
            this.newSource = newSource;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectLinkSource(this.link, this.newSource);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectLinkSource(this.link, this.newTarget);
        }
    }

    class ReconnectSequenceTargetCommand
    extends TCommand {
        private TMessage sequence;
        private TSequenciableElement newTargetSequenciableElement;
        private TSequenciableElement oldTargetSequenciableElement;

        public ReconnectSequenceTargetCommand(TMessage sequence, TSequenciableElement target) {
            this.sequence = sequence;
            this.oldTargetSequenciableElement = sequence.getTarget();
            this.newTargetSequenciableElement = target;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectSequenceTarget(this.sequence, this.newTargetSequenciableElement);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectSequenceTarget(this.sequence, this.oldTargetSequenciableElement);
        }
    }

    class ReconnectSequenceSourceCommand
    extends TCommand {
        private TMessage message;
        private TSequenciableElement newSourceSequenciableElement;
        private TSequenciableElement oldSourceSequenciableElement;

        public ReconnectSequenceSourceCommand(TMessage message, TSequenciableElement source) {
            this.message = message;
            this.oldSourceSequenciableElement = message.getSource();
            this.newSourceSequenciableElement = source;
        }

        public void execute() {
            TCommandFactory.this.getDocument().reconnectSequenceSource(this.message, this.newSourceSequenciableElement);
        }

        public void undo() {
            TCommandFactory.this.getDocument().reconnectSequenceSource(this.message, this.oldSourceSequenciableElement);
        }
    }

    class SetTransitionLabelCommand
    extends TCommand {
        private TTransition transition;
        private TTransitionLabel oldLabel;
        private TTransitionLabel newLabel;

        public SetTransitionLabelCommand(TTransition transition, TTransitionLabel label) {
            this.transition = transition;
            this.newLabel = label;
            this.oldLabel = transition.getLabel();
        }

        public void execute() {
            TCommandFactory.this.getDocument().setTransitionLabel(this.transition, this.newLabel);
        }

        public void redo() {
            TCommandFactory.this.getDocument().setTransitionLabel(this.transition, this.newLabel);
        }

        public void undo() {
            TCommandFactory.this.getDocument().setTransitionLabel(this.transition, this.oldLabel);
        }
    }

    class SetMessageLabelCommand
    extends TCommand {
        private TMessage sequence;
        private TMessageLabel newMessage;
        private TMessageLabel oldMessage;

        public SetMessageLabelCommand(TMessage sequence, TMessageLabel message) {
            this.sequence = sequence;
            this.oldMessage = sequence.getMessageLabel();
            this.newMessage = message;
        }

        public void execute() {
            TCommandFactory.this.getDocument().setMessageLabel(this.sequence, this.newMessage);
        }

        public void redo() {
            TCommandFactory.this.getDocument().setMessageLabel(this.sequence, this.newMessage);
        }

        public void undo() {
            TCommandFactory.this.getDocument().setMessageLabel(this.sequence, this.oldMessage);
        }
    }

    class SetValueCommand
    extends TCommand {
        private TInstanceVariable instanceVariable;
        private String value;
        private String oldValue;

        public SetValueCommand(TInstanceVariable instanceVariable, String value) {
            this.instanceVariable = instanceVariable;
            this.value = value;
            this.oldValue = instanceVariable.getValue().getName();
        }

        public void execute() {
            TCommandFactory.this.document.setValue(this.instanceVariable, this.value);
        }

        public void undo() {
            TCommandFactory.this.document.setValue(this.instanceVariable, this.oldValue);
        }
    }

    class AddInstanceVariableCommand
    extends TCommand {
        private TInstance instance;
        private TInstanceVariable variable;

        public AddInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
            this.instance = instance;
            this.variable = variable;
        }

        public void execute() {
            TCommandFactory.this.document.addInstanceVariable(this.instance, this.variable);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.variable);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.variable);
        }
    }

    class MoveUpInstanceVariableCommand
    extends TCommand {
        private TInstance instance;
        private TInstanceVariable variable;

        public MoveUpInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
            this.instance = instance;
            this.variable = variable;
        }

        public void execute() {
            TCommandFactory.this.document.moveUpInstanceVariable(this.instance, this.variable);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.variable);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.variable);
        }
    }

    class MoveDownInstanceVariableCommand
    extends TCommand {
        private TInstance instance;
        private TInstanceVariable variable;

        public MoveDownInstanceVariableCommand(TInstance instance, TInstanceVariable variable) {
            this.instance = instance;
            this.variable = variable;
        }

        public void execute() {
            TCommandFactory.this.document.moveDownInstanceVariable(this.instance, this.variable);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.variable);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.variable);
        }
    }

    class InsertInstanceVariableCommand
    extends TCommand {
        private TInstance instance;
        private TInstanceVariable variable;
        private int index;

        public InsertInstanceVariableCommand(TInstance instance, TInstanceVariable variable, int index) {
            this.instance = instance;
            this.variable = variable;
            this.index = index;
        }

        public void execute() {
            TCommandFactory.this.document.insertInstanceVariable(this.instance, this.variable, this.index);
        }

        public void redo() {
            TCommandFactory.this.document.comeBack(this.variable);
        }

        public void undo() {
            TCommandFactory.this.document.remove(this.variable);
        }
    }
}

