/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import org.apache.log4j.Logger;
import trier.model.core.TClass;
import trier.model.core.TDataType;
import trier.model.core.TDocument;
import trier.model.core.TDocumentHelper;
import trier.model.core.TFeature;
import trier.model.core.TMethod;
import trier.model.core.TModelElement;
import trier.model.core.TNamespace;
import trier.model.core.TNote;
import trier.model.core.TPackage;
import trier.model.core.TParameter;
import trier.model.core.TStereoType;

public class TModelElementDocumentHelper
extends TDocumentHelper {
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TModelElementDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.core.TModelElementDocumentHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    protected TModelElementDocumentHelper(TDocument document) {
        super(document);
    }

    public void setName(TModelElement modelElement, String name) {
        TClass owner;
        modelElement.setName(name);
        if (modelElement instanceof TParameter) {
            TClass owner2;
            TMethod parent = ((TParameter)modelElement).getOwner();
            if (parent != null && (owner2 = parent.getOwner()) != null) {
                owner2.fireStructureChange("TModelElement changed");
            }
        } else if (modelElement instanceof TFeature && (owner = ((TFeature)modelElement).getOwner()) != null) {
            owner.fireStructureChange("TModelElement changed");
        }
    }

    public void setStereoType(TModelElement element, TStereoType stereoType) {
        if (!element.getStereoType().isNull() && element.getStereoType().getStereoTypedElements().contains(element)) {
            if (element.isRemoved()) {
                throw new IllegalArgumentException("element should be added to model for changing stereo type:" + element.getId());
            }
            element.getStereoType().removeStereoTypedElements(element);
        }
        element.setStereoType(stereoType);
        if (!element.isRemoved()) {
            stereoType.addStereoTypedElements(element);
        }
    }

    public void setNamespace(TModelElement element, TNamespace namespace) {
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && namespace instanceof TDataType) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && namespace instanceof TClass && element instanceof TPackage) {
            throw new AssertionError();
        }
        TNamespace oldNamespace = element.getNamespace();
        if (oldNamespace == null) {
            throw new IllegalArgumentException("The model element is not belong to namespace:" + element.getId());
        }
        if (oldNamespace != namespace) {
            if (oldNamespace != null) {
                oldNamespace.removeOwnedElement(element);
            }
            namespace.addOwnedElement(element);
            element.setNamespace(namespace);
            if (!$assertionsDisabled && oldNamespace.getOwnedElements().contains(element)) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && element.getNamespace() != namespace) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !namespace.getOwnedElements().contains(element)) {
            throw new AssertionError();
        }
    }

    public void setDescription(TNote note, String description) {
        if (!$assertionsDisabled && note == null) {
            throw new AssertionError();
        }
        note.setDescription(description);
        if (!$assertionsDisabled && !note.getDescription().equals(description)) {
            throw new AssertionError();
        }
    }

    public void remove(TModelElement modelElement) {
        modelElement.remove();
    }

    public void comeBack(TModelElement modelElement) {
        modelElement.comeBack();
    }
}

