/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

class TMultiplicityRange {
    private int upper;
    private int lower;

    private TMultiplicityRange(int upper, int lower) {
        this.upper = upper;
        this.lower = lower;
    }

    public TMultiplicityRange(String value) {
        String[] values = value.split("\\.\\.");
        if (values.length == 1) {
            int valueAsInt;
            this.lower = valueAsInt = this.parseInt(values[0]);
            this.upper = valueAsInt;
        } else if (values.length == 2) {
            this.lower = this.parseInt(values[0]);
            this.upper = this.parseInt(values[1]);
        } else {
            throw new IllegalArgumentException("invalid value of multiplicity range:" + value);
        }
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public boolean hasMargin() {
        return this.getLower() != this.getUpper();
    }

    public boolean isInfinity() {
        return this.getUpper() == -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getLower() == -1) {
            buffer.append("*");
        } else {
            buffer.append(this.getLower());
        }
        if (this.hasMargin()) {
            buffer.append("..");
            if (this.isInfinity()) {
                buffer.append("*");
            } else {
                buffer.append(this.getUpper());
            }
        }
        return buffer.toString();
    }

    private int parseInt(String value) {
        int valueAsInt = 0;
        valueAsInt = value.equals("*") ? -1 : Integer.parseInt(value);
        return valueAsInt;
    }

    public String getTagName() {
        return "Multiplicity";
    }
}

