/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TVisibilityKind
implements Serializable {
    private static final Logger logger;
    public static String PUBLIC_AS_STRING;
    public static String PRIVATE_AS_STRING;
    public static String PACKAGE_AS_STRING;
    public static String PROTECTED_AS_STRING;
    public static TVisibilityKind PUBLIC;
    public static TVisibilityKind PRIVATE;
    public static TVisibilityKind PACKAGE;
    public static TVisibilityKind PROTECTED;
    private String name;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.TVisibilityKind");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        PUBLIC_AS_STRING = "public";
        PRIVATE_AS_STRING = "private";
        PACKAGE_AS_STRING = "package";
        PROTECTED_AS_STRING = "protected";
        PUBLIC = new TVisibilityKind(PUBLIC_AS_STRING);
        PRIVATE = new TVisibilityKind(PRIVATE_AS_STRING);
        PACKAGE = new TVisibilityKind(PACKAGE_AS_STRING);
        PROTECTED = new TVisibilityKind(PROTECTED_AS_STRING);
    }

    public static List getAllVisibilityKind() {
        TVisibilityKind[] kinds = new TVisibilityKind[]{PUBLIC, PRIVATE, PROTECTED, PACKAGE};
        return Arrays.asList(kinds);
    }

    public static List getAllVisibilityKindAsString() {
        String[] kinds = new String[]{PUBLIC_AS_STRING, PRIVATE_AS_STRING, PROTECTED_AS_STRING, PACKAGE_AS_STRING};
        return Arrays.asList(kinds);
    }

    public static TVisibilityKind getVisibilityKind(String expression) {
        if (expression.equals(PUBLIC_AS_STRING)) {
            return PUBLIC;
        }
        if (expression.equals(PRIVATE_AS_STRING)) {
            return PRIVATE;
        }
        if (expression.equals(PROTECTED_AS_STRING)) {
            return PROTECTED;
        }
        if (expression.equals(PACKAGE_AS_STRING)) {
            return PACKAGE;
        }
        throw new IllegalArgumentException("Illegal visibility expression :" + expression);
    }

    private TVisibilityKind(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getId() {
        return "VisibilityKind_" + this.toString();
    }

    public String getSign() {
        if (this.name.equals(PUBLIC_AS_STRING)) {
            return "+";
        }
        if (this.name.equals(PROTECTED_AS_STRING)) {
            return "#";
        }
        if (this.name.equals(PACKAGE_AS_STRING)) {
            return " ";
        }
        if (this.name.equals(PRIVATE_AS_STRING)) {
            return "-";
        }
        return null;
    }
}

