/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;
import trier.TrierException;
import trier.model.core.TDocument;
import trier.model.core.serialize.TDocumentSerializer;
import trier.model.core.serialize.xml.TXMLInput;
import trier.model.core.serialize.xml.TXMLOutput;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XDocument;

public class TDocumentXMLSerializer
extends TDocumentSerializer {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.serialize.xml.TDocumentXMLSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.core.serialize.xml.TDocumentXMLSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TDocumentSerializer.serializerClass = clazz2;
    }

    public void serialize(TDocument document, OutputStream output) throws Exception {
        try {
            TXMLOutput xOut = new TXMLOutput();
            XDocument xDocument = xOut.process(document);
            OutputStreamWriter ow = new OutputStreamWriter(output, "UTF-8");
            String print = URelaxer.doc2String4Print(xDocument.makeDocument(), "UTF-8");
            ow.write(print);
            ow.flush();
        }
        catch (Exception e) {
            logger.warn((Object)"serialize xml failed", (Throwable)e);
            throw new TrierException("serialize xml failed", e);
        }
    }

    public TDocument unSerialize(InputStream input) throws Exception {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        XDocument root = factory.createXDocument();
        root.setup(input);
        TXMLInput xIn = new TXMLInput();
        TDocument doc = xIn.process(root);
        return doc;
    }
}

