/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import trier.model.core.TDocument;
import trier.model.core.TModelElement;
import trier.model.core.TNamespace;
import trier.model.core.serialize.xml.IXNamespace;
import trier.model.core.serialize.xml.TXElementBridge;
import trier.model.core.serialize.xml.TXModelElementBridge;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.XAnchor;
import trier.model.core.xml.XAssociation;
import trier.model.core.xml.XClass;
import trier.model.core.xml.XDataType;
import trier.model.core.xml.XGeneralization;
import trier.model.core.xml.XNote;
import trier.model.core.xml.XPackage;
import trier.model.core.xml.XRootStateMachine;
import trier.model.core.xml.XStereoType;
import trier.util.EIdMap;

public abstract class TXNamespaceBridge
extends TXModelElementBridge {
    List associationBridges = new ArrayList();
    List classBridges = new ArrayList();
    List generalizationBridges = new ArrayList();
    List packageBridges = new ArrayList();
    List dataTypeBridges = new ArrayList();
    List stereoTypeBridges = new ArrayList();
    List noteBridges = new ArrayList();
    List anchorBridges = new ArrayList();
    List stateMachineBridges = new ArrayList();

    protected TXNamespaceBridge(TDocument document, Object model, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, xmlElement, idMap, factory);
    }

    public void buildXML() {
        super.buildXML();
        TNamespace tNamespace = this.getTNamespace();
        Iterator i = tNamespace.getOwnedElements().iterator();
        while (i.hasNext()) {
            TModelElement ownedElement = (TModelElement)i.next();
            TXElementBridge ownedElementBridge = super.create(ownedElement);
            ownedElementBridge.buildXML();
            this.addOwnedElement(ownedElementBridge.getXmlElement());
        }
    }

    public void buildStructure() {
        super.buildStructure();
        this.buildOwnedAssociation();
        this.buildOwnedClass();
        this.buildOwnedGeneralization();
        this.buildOwnedPackage();
        this.buildOwnedDataType();
        this.buildOwnedStereoType();
        this.buildOwnedNote();
        this.buildOwnedAnchor();
        this.buildOwnedStateMachines();
    }

    public void buildReference() {
        super.buildReference();
        ArrayList allBridges = new ArrayList(this.associationBridges);
        allBridges.addAll(this.classBridges);
        allBridges.addAll(this.dataTypeBridges);
        allBridges.addAll(this.generalizationBridges);
        allBridges.addAll(this.packageBridges);
        allBridges.addAll(this.stereoTypeBridges);
        allBridges.addAll(this.anchorBridges);
        allBridges.addAll(this.noteBridges);
        allBridges.addAll(this.stateMachineBridges);
        Iterator i = allBridges.iterator();
        while (i.hasNext()) {
            TXModelElementBridge bridge = (TXModelElementBridge)i.next();
            bridge.buildReference();
        }
    }

    private void buildOwnedAssociation() {
        XAssociation[] associations = this.getXNamespace().getAssociation();
        int i = 0;
        while (i < associations.length) {
            TXElementBridge bridge = super.create(associations[i]);
            bridge.buildStructure();
            this.associationBridges.add(bridge);
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedClass() {
        XClass[] classes = this.getXNamespace().getClassValue();
        int i = 0;
        while (i < classes.length) {
            TXElementBridge bridge = super.create(classes[i]);
            this.classBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedGeneralization() {
        XGeneralization[] generalizations = this.getXNamespace().getGeneralization();
        int i = 0;
        while (i < generalizations.length) {
            TXElementBridge bridge = super.create(generalizations[i]);
            this.generalizationBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedPackage() {
        XPackage[] packages = this.getXNamespace().getPackage();
        int i = 0;
        while (i < packages.length) {
            TXElementBridge bridge = super.create(packages[i]);
            this.packageBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedDataType() {
        XDataType[] dataTypes = this.getXNamespace().getDataType();
        int i = 0;
        while (i < dataTypes.length) {
            TXElementBridge bridge = super.create(dataTypes[i]);
            this.dataTypeBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedStereoType() {
        XStereoType[] stereoTypes = this.getXNamespace().getStereoType();
        int i = 0;
        while (i < stereoTypes.length) {
            TXElementBridge bridge = super.create(stereoTypes[i]);
            this.stereoTypeBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedAnchor() {
        XAnchor[] anchors = this.getXNamespace().getAnchor();
        int i = 0;
        while (i < anchors.length) {
            TXElementBridge bridge = super.create(anchors[i]);
            this.stereoTypeBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedNote() {
        XNote[] notes = this.getXNamespace().getNote();
        int i = 0;
        while (i < notes.length) {
            TXElementBridge bridge = super.create(notes[i]);
            this.noteBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    private void buildOwnedStateMachines() {
        XRootStateMachine[] stateMachines = this.getXNamespace().getRootStateMachine();
        int i = 0;
        while (i < stateMachines.length) {
            TXElementBridge bridge = super.create(stateMachines[i]);
            this.stateMachineBridges.add(bridge);
            bridge.buildStructure();
            this.getDocument().addOwnedElement(this.getTNamespace(), (TModelElement)bridge.getModel());
            ++i;
        }
    }

    protected void addOwnedElement(IRNode xmlElement) {
        if (xmlElement instanceof XAssociation) {
            this.getXNamespace().addAssociation((XAssociation)xmlElement);
            return;
        }
        if (xmlElement instanceof XClass) {
            this.getXNamespace().addClassValue((XClass)xmlElement);
            return;
        }
        if (xmlElement instanceof XGeneralization) {
            this.getXNamespace().addGeneralization((XGeneralization)xmlElement);
            return;
        }
        if (xmlElement instanceof XPackage) {
            this.getXNamespace().addPackage((XPackage)xmlElement);
            return;
        }
        if (xmlElement instanceof XDataType) {
            this.getXNamespace().addDataType((XDataType)xmlElement);
            return;
        }
        if (xmlElement instanceof XStereoType) {
            this.getXNamespace().addStereoType((XStereoType)xmlElement);
            return;
        }
        if (xmlElement instanceof XNote) {
            this.getXNamespace().addNote((XNote)xmlElement);
            return;
        }
        if (xmlElement instanceof XAnchor) {
            this.getXNamespace().addAnchor((XAnchor)xmlElement);
            return;
        }
        if (xmlElement instanceof XRootStateMachine) {
            this.getXNamespace().addRootStateMachine((XRootStateMachine)xmlElement);
            return;
        }
        throw new IllegalArgumentException("Illegal owned element.:" + xmlElement);
    }

    public TNamespace getTNamespace() {
        return (TNamespace)this.getModel();
    }

    public IXNamespace getXNamespace() {
        return (IXNamespace)this.getXmlElement();
    }
}

