/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.serialize.xml;

import org.apache.log4j.Logger;
import trier.model.core.TDocument;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.serialize.xml.TXGuardConditionBridge;
import trier.model.core.serialize.xml.TXModelElementBridge;
import trier.model.core.serialize.xml.TXTransitionLabelBridge;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.XTransition;
import trier.model.state.TState;
import trier.model.state.TTransition;
import trier.util.EIdMap;

public class TXTransitionBridge
extends TXModelElementBridge {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.core.serialize.xml.TXTransitionBridge");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected TXTransitionBridge(TDocument document, Object model, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, xmlElement, idMap, factory);
    }

    protected TXTransitionBridge(TDocument document, IRNode xmlElement, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, document.createTransition(((IXModelElement)xmlElement).getId()), xmlElement, idMap, factory);
    }

    protected TXTransitionBridge(TDocument document, Object model, EIdMap idMap, ITrierCoreFactory factory) {
        super(document, model, factory.createXTransition(), idMap, factory);
    }

    public void buildXML() {
        super.buildXML();
        TTransition tTransition = this.getTTransition();
        XTransition xTransition = this.getXTransition();
        xTransition.setSourceState(tTransition.getSourceState().getId());
        xTransition.setTargetState(tTransition.getTargetState().getId());
        TXTransitionLabelBridge labelBridge = (TXTransitionLabelBridge)super.create(tTransition.getLabel());
        labelBridge.buildXML();
        xTransition.setTransitionLabel(labelBridge.getXTransitionLabel());
        if (!tTransition.getGuardCondition().isNull()) {
            TXGuardConditionBridge guardBridge = (TXGuardConditionBridge)super.create(tTransition.getGuardCondition());
            guardBridge.buildXML();
            xTransition.setGuardCondition(guardBridge.getXGuardCondition());
        }
    }

    public void buildStructure() {
        super.buildStructure();
        TTransition tTransition = this.getTTransition();
        XTransition xTransition = this.getXTransition();
        TXTransitionLabelBridge labelBridge = (TXTransitionLabelBridge)super.create(xTransition.getTransitionLabel());
        labelBridge.buildStructure();
        this.getDocument().setTransitionLabel(tTransition, labelBridge.getTTransitionLabel());
        if (xTransition.getGuardCondition() != null) {
            TXGuardConditionBridge guardBridge = (TXGuardConditionBridge)super.create(xTransition.getGuardCondition());
            guardBridge.buildStructure();
            this.getDocument().setGuardCondition(tTransition, guardBridge.getTGuardCondition());
        }
    }

    public void buildReference() {
        super.buildReference();
        TTransition tTransition = this.getTTransition();
        XTransition xTransition = this.getXTransition();
        this.getDocument().setTransitionSource(tTransition, (TState)this.getDocument().getTElement(xTransition.getSourceState()));
        this.getDocument().setTransitionTarget(tTransition, (TState)this.getDocument().getTElement(xTransition.getTargetState()));
    }

    public XTransition getXTransition() {
        return (XTransition)this.getXmlElement();
    }

    public TTransition getTTransition() {
        return (TTransition)this.getModel();
    }
}

