/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XAssociationEnd;

public class XAssociation
implements Serializable,
Cloneable,
IXModelElement,
IRNode {
    private String id_;
    private String name_;
    private String typedStereoType_;
    private XAssociationEnd associationEnd1_;
    private XAssociationEnd associationEnd2_;
    private IRNode parentRNode_;

    public XAssociation() {
        this.id_ = "";
    }

    public XAssociation(XAssociation source) {
        this.setup(source);
    }

    public XAssociation(RStack stack) {
        this.setup(stack);
    }

    public XAssociation(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XAssociation(Element element) {
        this.setup(element);
    }

    public XAssociation(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XAssociation(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XAssociation(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XAssociation(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XAssociation(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XAssociation(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XAssociation source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setTypedStereoType(source.getTypedStereoType());
        this.setAssociationEnd1(source.getAssociationEnd1());
        this.setAssociationEnd2(source.getAssociationEnd2());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.typedStereoType_ = URelaxer.getAttributePropertyAsString(element, "typedStereoType");
        if (XAssociationEnd.isMatch(stack)) {
            this.setAssociationEnd1(factory.createXAssociationEnd(stack));
        }
        if (XAssociationEnd.isMatch(stack)) {
            this.setAssociationEnd2(factory.createXAssociationEnd(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXAssociation(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("Association");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.typedStereoType_ != null) {
            URelaxer.setAttributePropertyByString(element, "typedStereoType", this.typedStereoType_);
        }
        if (this.associationEnd1_ != null) {
            this.associationEnd1_.makeElement(element);
        }
        if (this.associationEnd2_ != null) {
            this.associationEnd2_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getTypedStereoType() {
        return this.typedStereoType_;
    }

    public final void setTypedStereoType(String typedStereoType) {
        this.typedStereoType_ = typedStereoType;
    }

    public final XAssociationEnd getAssociationEnd1() {
        return this.associationEnd1_;
    }

    public final void setAssociationEnd1(XAssociationEnd associationEnd1) {
        this.associationEnd1_ = associationEnd1;
        if (associationEnd1 != null) {
            associationEnd1.rSetParentRNode(this);
        }
    }

    public final XAssociationEnd getAssociationEnd2() {
        return this.associationEnd2_;
    }

    public final void setAssociationEnd2(XAssociationEnd associationEnd2) {
        this.associationEnd2_ = associationEnd2;
        if (associationEnd2 != null) {
            associationEnd2.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<Association");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.append(" typedStereoType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.associationEnd1_ != null) {
            this.associationEnd1_.makeTextElement(buffer);
        }
        if (this.associationEnd2_ != null) {
            this.associationEnd2_.makeTextElement(buffer);
        }
        buffer.append("</Association>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<Association");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.write(" typedStereoType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.associationEnd1_ != null) {
            this.associationEnd1_.makeTextElement(buffer);
        }
        if (this.associationEnd2_ != null) {
            this.associationEnd2_.makeTextElement(buffer);
        }
        buffer.write("</Association>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<Association");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.print(" typedStereoType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.associationEnd1_ != null) {
            this.associationEnd1_.makeTextElement(buffer);
        }
        if (this.associationEnd2_ != null) {
            this.associationEnd2_.makeTextElement(buffer);
        }
        buffer.print("</Association>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypedStereoTypeAsString() {
        return URelaxer.getString(this.getTypedStereoType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypedStereoTypeByString(String string) {
        this.setTypedStereoType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<XAssociationEnd> classNodes = new ArrayList<XAssociationEnd>();
        if (this.associationEnd1_ != null) {
            classNodes.add(this.associationEnd1_);
        }
        if (this.associationEnd2_ != null) {
            classNodes.add(this.associationEnd2_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "Association")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        XAssociationEnd.isMatchHungry(target);
        XAssociationEnd.isMatchHungry(target);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XAssociation.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XAssociation.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

