/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.serialize.xml.IXState;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XSourceTransition;
import trier.model.core.xml.XTargetTransition;

public class XFinalState
implements Serializable,
Cloneable,
IXState,
IRNode {
    private String id_;
    private String name_;
    private String typedStereoType_;
    private List sourceTransition_ = new ArrayList();
    private List targetTransition_ = new ArrayList();
    private IRNode parentRNode_;

    public XFinalState() {
        this.id_ = "";
    }

    public XFinalState(XFinalState source) {
        this.setup(source);
    }

    public XFinalState(RStack stack) {
        this.setup(stack);
    }

    public XFinalState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XFinalState(Element element) {
        this.setup(element);
    }

    public XFinalState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XFinalState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XFinalState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XFinalState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XFinalState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XFinalState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XFinalState source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setTypedStereoType(source.getTypedStereoType());
        this.sourceTransition_.clear();
        int size = source.sourceTransition_.size();
        int i = 0;
        while (i < size) {
            this.addSourceTransition((XSourceTransition)source.getSourceTransition(i).clone());
            ++i;
        }
        this.targetTransition_.clear();
        size = source.targetTransition_.size();
        i = 0;
        while (i < size) {
            this.addTargetTransition((XTargetTransition)source.getTargetTransition(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.typedStereoType_ = URelaxer.getAttributePropertyAsString(element, "typedStereoType");
        this.sourceTransition_.clear();
        while (XSourceTransition.isMatch(stack)) {
            this.addSourceTransition(factory.createXSourceTransition(stack));
        }
        this.targetTransition_.clear();
        while (XTargetTransition.isMatch(stack)) {
            this.addTargetTransition(factory.createXTargetTransition(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXFinalState(this);
    }

    public void makeElement(Node parent) {
        Cloneable value;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("FinalState");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.typedStereoType_ != null) {
            URelaxer.setAttributePropertyByString(element, "typedStereoType", this.typedStereoType_);
        }
        int size = this.sourceTransition_.size();
        int i = 0;
        while (i < size) {
            value = (XSourceTransition)this.sourceTransition_.get(i);
            ((XSourceTransition)value).makeElement(element);
            ++i;
        }
        size = this.targetTransition_.size();
        i = 0;
        while (i < size) {
            value = (XTargetTransition)this.targetTransition_.get(i);
            ((XTargetTransition)value).makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getTypedStereoType() {
        return this.typedStereoType_;
    }

    public final void setTypedStereoType(String typedStereoType) {
        this.typedStereoType_ = typedStereoType;
    }

    public final XSourceTransition[] getSourceTransition() {
        XSourceTransition[] array = new XSourceTransition[this.sourceTransition_.size()];
        return this.sourceTransition_.toArray(array);
    }

    public final void setSourceTransition(XSourceTransition[] sourceTransition) {
        this.sourceTransition_.clear();
        int i = 0;
        while (i < sourceTransition.length) {
            this.addSourceTransition(sourceTransition[i]);
            ++i;
        }
        i = 0;
        while (i < sourceTransition.length) {
            sourceTransition[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setSourceTransition(XSourceTransition sourceTransition) {
        this.sourceTransition_.clear();
        this.addSourceTransition(sourceTransition);
        if (sourceTransition != null) {
            sourceTransition.rSetParentRNode(this);
        }
    }

    public final void addSourceTransition(XSourceTransition sourceTransition) {
        this.sourceTransition_.add(sourceTransition);
        if (sourceTransition != null) {
            sourceTransition.rSetParentRNode(this);
        }
    }

    public final void addSourceTransition(XSourceTransition[] sourceTransition) {
        int i = 0;
        while (i < sourceTransition.length) {
            this.addSourceTransition(sourceTransition[i]);
            ++i;
        }
        i = 0;
        while (i < sourceTransition.length) {
            sourceTransition[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeSourceTransition() {
        return this.sourceTransition_.size();
    }

    public final XSourceTransition getSourceTransition(int index) {
        return (XSourceTransition)this.sourceTransition_.get(index);
    }

    public final void setSourceTransition(int index, XSourceTransition sourceTransition) {
        this.sourceTransition_.set(index, sourceTransition);
    }

    public final void addSourceTransition(int index, XSourceTransition sourceTransition) {
        this.sourceTransition_.add(index, sourceTransition);
    }

    public final void removeSourceTransition(int index) {
        this.sourceTransition_.remove(index);
    }

    public final void removeSourceTransition(XSourceTransition sourceTransition) {
        this.sourceTransition_.remove(sourceTransition);
    }

    public final void clearSourceTransition() {
        this.sourceTransition_.clear();
    }

    public final XTargetTransition[] getTargetTransition() {
        XTargetTransition[] array = new XTargetTransition[this.targetTransition_.size()];
        return this.targetTransition_.toArray(array);
    }

    public final void setTargetTransition(XTargetTransition[] targetTransition) {
        this.targetTransition_.clear();
        int i = 0;
        while (i < targetTransition.length) {
            this.addTargetTransition(targetTransition[i]);
            ++i;
        }
        i = 0;
        while (i < targetTransition.length) {
            targetTransition[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setTargetTransition(XTargetTransition targetTransition) {
        this.targetTransition_.clear();
        this.addTargetTransition(targetTransition);
        if (targetTransition != null) {
            targetTransition.rSetParentRNode(this);
        }
    }

    public final void addTargetTransition(XTargetTransition targetTransition) {
        this.targetTransition_.add(targetTransition);
        if (targetTransition != null) {
            targetTransition.rSetParentRNode(this);
        }
    }

    public final void addTargetTransition(XTargetTransition[] targetTransition) {
        int i = 0;
        while (i < targetTransition.length) {
            this.addTargetTransition(targetTransition[i]);
            ++i;
        }
        i = 0;
        while (i < targetTransition.length) {
            targetTransition[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeTargetTransition() {
        return this.targetTransition_.size();
    }

    public final XTargetTransition getTargetTransition(int index) {
        return (XTargetTransition)this.targetTransition_.get(index);
    }

    public final void setTargetTransition(int index, XTargetTransition targetTransition) {
        this.targetTransition_.set(index, targetTransition);
    }

    public final void addTargetTransition(int index, XTargetTransition targetTransition) {
        this.targetTransition_.add(index, targetTransition);
    }

    public final void removeTargetTransition(int index) {
        this.targetTransition_.remove(index);
    }

    public final void removeTargetTransition(XTargetTransition targetTransition) {
        this.targetTransition_.remove(targetTransition);
    }

    public final void clearTargetTransition() {
        this.targetTransition_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        Cloneable value;
        buffer.append("<FinalState");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.append(" typedStereoType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.sourceTransition_.size();
        int i = 0;
        while (i < size) {
            value = (XSourceTransition)this.sourceTransition_.get(i);
            ((XSourceTransition)value).makeTextElement(buffer);
            ++i;
        }
        size = this.targetTransition_.size();
        i = 0;
        while (i < size) {
            value = (XTargetTransition)this.targetTransition_.get(i);
            ((XTargetTransition)value).makeTextElement(buffer);
            ++i;
        }
        buffer.append("</FinalState>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        Cloneable value;
        buffer.write("<FinalState");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.write(" typedStereoType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.sourceTransition_.size();
        int i = 0;
        while (i < size) {
            value = (XSourceTransition)this.sourceTransition_.get(i);
            ((XSourceTransition)value).makeTextElement(buffer);
            ++i;
        }
        size = this.targetTransition_.size();
        i = 0;
        while (i < size) {
            value = (XTargetTransition)this.targetTransition_.get(i);
            ((XTargetTransition)value).makeTextElement(buffer);
            ++i;
        }
        buffer.write("</FinalState>");
    }

    public void makeTextElement(PrintWriter buffer) {
        Cloneable value;
        buffer.print("<FinalState");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.print(" typedStereoType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.sourceTransition_.size();
        int i = 0;
        while (i < size) {
            value = (XSourceTransition)this.sourceTransition_.get(i);
            ((XSourceTransition)value).makeTextElement(buffer);
            ++i;
        }
        size = this.targetTransition_.size();
        i = 0;
        while (i < size) {
            value = (XTargetTransition)this.targetTransition_.get(i);
            ((XTargetTransition)value).makeTextElement(buffer);
            ++i;
        }
        buffer.print("</FinalState>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypedStereoTypeAsString() {
        return URelaxer.getString(this.getTypedStereoType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypedStereoTypeByString(String string) {
        this.setTypedStereoType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.sourceTransition_);
        classNodes.addAll(this.targetTransition_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "FinalState")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        while (XSourceTransition.isMatchHungry(target)) {
        }
        while (XTargetTransition.isMatchHungry(target)) {
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XFinalState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XFinalState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

